/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.items;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.placement.PlacementHandler;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class VerticalSlabItem
extends BlockItem {
    public VerticalSlabItem() {
        super((Block)DSBlocks.VERTICAL_SLAB.get(), new Item.Properties().func_200916_a(DoubleSlabs.TAB));
    }

    public static ItemStack setStack(ItemStack stack, ItemStack toSet) {
        ItemStack copy = toSet.func_77946_l();
        copy.func_190920_e(1);
        stack.func_77983_a("item", (INBT)copy.func_77955_b(new CompoundNBT()));
        return stack;
    }

    public static ItemStack getStack(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("item");
        return ItemStack.func_199557_a((CompoundNBT)nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ForgeRegistries.ITEMS.forEach(item -> {
                if (item != null && SlabSupport.isHorizontalSlab(item)) {
                    ItemStack stack = new ItemStack((IItemProvider)this);
                    items.add((Object)VerticalSlabItem.setStack(stack, item.func_190903_i()));
                }
            });
        }
    }

    protected boolean func_195943_a(BlockPos pos, World world, @Nullable PlayerEntity player, ItemStack stack, BlockState state) {
        boolean result = super.func_195943_a(pos, world, player, stack, state);
        if (player != null) {
            VerticalSlabBlock.getTile((IBlockReader)world, pos).ifPresent(tile -> {
                ItemStack slabStack = VerticalSlabItem.getStack(stack);
                IHorizontalSlabSupport support = SlabSupport.getHorizontalSlabSupport(slabStack, player, Hand.MAIN_HAND);
                if (support != null) {
                    boolean positive = tile.getPositiveBlockInfo().getBlockState() == null;
                    BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, Hand.MAIN_HAND, slabStack, positive ? SlabType.BOTTOM : SlabType.TOP, support);
                    if (positive) {
                        tile.getPositiveBlockInfo().setBlockState(slabState);
                    } else {
                        tile.getNegativeBlockInfo().setBlockState(slabState);
                    }
                }
            });
        }
        return result;
    }

    public String func_77667_c(ItemStack stack) {
        return VerticalSlabItem.getStack(stack).func_77977_a();
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent("item.vertical_slab.prefix", new Object[]{new TranslationTextComponent(this.func_77667_c(stack), new Object[0])});
    }
}

