/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.placement;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.IVerticalSlabSupport;
import cjminecraft.doubleslabs.common.blocks.DoubleSlabBlock;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.capability.config.IPlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfig;
import cjminecraft.doubleslabs.common.capability.config.PlayerConfigCapability;
import cjminecraft.doubleslabs.common.config.DSConfig;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.items.VerticalSlabItem;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import cjminecraft.doubleslabs.common.util.DoubleSlabBlockItemUseContext;
import cjminecraft.doubleslabs.common.util.RayTraceUtil;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="doubleslabs")
public class PlacementHandler {
    private static boolean canPlace(World world, BlockPos pos, Direction face, PlayerEntity player, Hand hand, ItemStack stack, Consumer<Boolean> cancelEventConsumer, boolean activateBlock) {
        boolean flag1;
        if (!player.func_175151_a(pos, face, stack)) {
            return false;
        }
        if (MathHelper.func_76128_c((double)player.field_70165_t) == pos.func_177958_n() && MathHelper.func_76128_c((double)player.field_70163_u) == pos.func_177956_o() && MathHelper.func_76128_c((double)player.field_70161_v) == pos.func_177952_p()) {
            return false;
        }
        if (!activateBlock) {
            return true;
        }
        boolean flag = !player.func_184614_ca().func_190926_b() || !player.func_184592_cb().func_190926_b();
        boolean bl = flag1 = !player.func_70093_af() || !flag || player.func_184614_ca().doesSneakBypassUse((IWorldReader)world, pos, player) && player.func_184592_cb().doesSneakBypassUse((IWorldReader)world, pos, player);
        if (flag1) {
            boolean result = world.func_180495_p(pos).func_215687_a(world, player, hand, RayTraceUtil.rayTrace(player));
            if (result) {
                cancelEventConsumer.accept(result);
            }
            return !result;
        }
        return true;
    }

    private static boolean activateBlock(World world, BlockPos pos, PlayerEntity player, Hand hand, Consumer<Boolean> cancelEventConsumer) {
        boolean flag1;
        boolean flag = !player.func_184614_ca().func_190926_b() || !player.func_184592_cb().func_190926_b();
        boolean bl = flag1 = !player.func_70093_af() || !flag || player.func_184614_ca().doesSneakBypassUse((IWorldReader)world, pos, player) && player.func_184592_cb().doesSneakBypassUse((IWorldReader)world, pos, player);
        if (flag1) {
            boolean result = world.func_180495_p(pos).func_215687_a(world, player, hand, RayTraceUtil.rayTrace(player));
            if (result) {
                cancelEventConsumer.accept(result);
            }
            return result;
        }
        return false;
    }

    private static BlockState prepareState(BlockState state) {
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
            return (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public static BlockItemUseContext getUseContext(PlayerEntity player, Hand hand) {
        return new BlockItemUseContext(new ItemUseContext(player, hand, RayTraceUtil.rayTrace(player)));
    }

    public static BlockItemUseContext getUseContext(PlayerEntity player, Hand hand, ItemStack stack, BlockPos pos) {
        return new DoubleSlabBlockItemUseContext(player, hand, stack, RayTraceUtil.rayTrace(player), pos);
    }

    public static BlockState getStateFromSupport(World world, BlockPos pos, PlayerEntity player, Hand hand, ItemStack stack, SlabType half, IHorizontalSlabSupport support) {
        return support.getStateForHalf(world, pos, support.getStateFromStack(stack, PlacementHandler.getUseContext(player, hand, stack, pos)), half);
    }

    public static BlockState getStateFromSupport(World world, BlockPos pos, PlayerEntity player, Hand hand, ItemStack stack, Direction direction, IVerticalSlabSupport support) {
        return support.getStateForDirection(world, pos, support.getStateFromStack(stack, PlacementHandler.getUseContext(player, hand, stack, pos)), direction);
    }

    private static void finishBlockPlacement(World world, BlockPos pos, BlockState state, PlayerEntity player, ItemStack stack, Consumer<Boolean> cancel) {
        SoundType soundType = state.getSoundType((IWorldReader)world, pos, (Entity)player);
        world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        cancel.accept(true);
        if (player instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
        }
    }

    private static boolean canPlace(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        ISelectionContext context = player == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)player);
        return state.func_196955_c((IWorldReader)world, pos) && world.func_217350_a(state, pos, context);
    }

    private static boolean placeSlab(World world, BlockPos pos, BlockState state, PlayerEntity player, Consumer<SlabTileEntity> setStates) {
        if (!PlacementHandler.canPlace(world, pos, state, player)) {
            return false;
        }
        if (world.func_180501_a(pos, state, 11)) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof SlabTileEntity) {
                SlabTileEntity tile = (SlabTileEntity)tileEntity;
                setStates.accept(tile);
            }
            return true;
        }
        return false;
    }

    private static boolean placeSlab(World world, BlockPos pos, BlockState state, PlayerEntity player, BlockState negativeState, BlockState positiveState) {
        return PlacementHandler.placeSlab(world, pos, state, player, tile -> {
            tile.getNegativeBlockInfo().setBlockState(negativeState);
            tile.getPositiveBlockInfo().setBlockState(positiveState);
        });
    }

    private static boolean shouldPlaceVerticalSlab(PlayerEntity player, Direction face) {
        if (((Boolean)DSConfig.SERVER.disableVerticalSlabPlacement.get()).booleanValue()) {
            return false;
        }
        IPlayerConfig config = (IPlayerConfig)player.getCapability(PlayerConfigCapability.PLAYER_CONFIG).orElse((Object)new PlayerConfig());
        return config.getVerticalSlabPlacementMethod().shouldPlace(player, face, config.placeVerticalSlabs());
    }

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().func_190926_b()) {
            ItemStack stack = event.getItemStack();
            World world = event.getWorld();
            PlayerEntity player = event.getPlayer();
            Hand hand = event.getHand();
            Direction face = event.getFace();
            BlockPos pos = event.getPos();
            if (stack.func_77973_b() == DSItems.VERTICAL_SLAB.get()) {
                stack = VerticalSlabItem.getStack(stack);
            }
            IHorizontalSlabSupport horizontalSlabItemSupport = SlabSupport.getHorizontalSlabSupport(stack, player, hand);
            Consumer<Boolean> cancel = resultType -> {
                event.setCanceled(true);
                event.setCancellationResult(resultType != false ? ActionResultType.SUCCESS : ActionResultType.PASS);
            };
            BlockState state = world.func_180495_p(pos);
            BlockItemUseContext context = PlacementHandler.getUseContext(player, hand);
            if (horizontalSlabItemSupport == null) {
                TileEntity tileEntity;
                IVerticalSlabSupport verticalSlabItemSupport = SlabSupport.getVerticalSlabSupport(stack, player, hand);
                if (verticalSlabItemSupport == null) {
                    return;
                }
                boolean offset = false;
                if (state.func_177230_c() != DSBlocks.VERTICAL_SLAB.get() && world.func_180495_p(pos.func_177972_a(face)).func_177230_c() == DSBlocks.VERTICAL_SLAB.get()) {
                    pos = pos.func_177972_a(face);
                    state = world.func_180495_p(pos);
                    tileEntity = world.func_175625_s(pos);
                    offset = true;
                    if (tileEntity instanceof SlabTileEntity) {
                        Direction direction = face = ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() != null ? ((Direction)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176734_d() : (Direction)state.func_177229_b((IProperty)VerticalSlabBlock.FACING);
                    }
                }
                if (state.func_177230_c() == DSBlocks.VERTICAL_SLAB.get()) {
                    if (!(((Boolean)state.func_177229_b((IProperty)VerticalSlabBlock.DOUBLE)).booleanValue() || face != ((Direction)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176734_d() || !((tileEntity = world.func_175625_s(pos)) instanceof SlabTileEntity) || event.getPlayer().func_70093_af() || face == state.func_177229_b((IProperty)VerticalSlabBlock.FACING) && ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() != null)) {
                        BlockState newState = (BlockState)state.func_206870_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true));
                        BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() != null ? face.func_176734_d() : face, verticalSlabItemSupport);
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(slabState.func_177230_c())) {
                            return;
                        }
                        if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                            return;
                        }
                        if (PlacementHandler.placeSlab(world, pos, newState, player, tile -> {
                            if (tile.getPositiveBlockInfo().getBlockState() != null) {
                                tile.getNegativeBlockInfo().setBlockState(slabState);
                            } else {
                                tile.getPositiveBlockInfo().setBlockState(slabState);
                            }
                        })) {
                            PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                        }
                    }
                } else {
                    IVerticalSlabSupport blockSupport = SlabSupport.getVerticalSlabSupport((IBlockReader)world, pos, state);
                    if (blockSupport == null) {
                        offset = true;
                        blockSupport = SlabSupport.getVerticalSlabSupport((IBlockReader)world, pos = pos.func_177972_a(face), state = world.func_180495_p(pos));
                        if (blockSupport == null) {
                            return;
                        }
                        face = blockSupport.getDirection(event.getWorld(), pos, state);
                    }
                    if (DSConfig.SERVER.isBlacklistedVerticalSlab(state.func_177230_c())) {
                        return;
                    }
                    if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                        return;
                    }
                    state = PlacementHandler.prepareState(state);
                    Direction direction = blockSupport.getDirection(event.getWorld(), pos, state);
                    if (face == direction) {
                        BlockState finalState;
                        BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, direction.func_176734_d(), verticalSlabItemSupport);
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(slabState.func_177230_c())) {
                            return;
                        }
                        BlockState newState = (BlockState)((BlockState)((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).func_176223_P().func_206870_a((IProperty)VerticalSlabBlock.FACING, (Comparable)direction)).func_206870_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true));
                        if (PlacementHandler.placeSlab(world, pos, newState, player, arg_0 -> PlacementHandler.lambda$onItemUse$3(slabState, finalState = state, arg_0))) {
                            PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                        }
                    }
                }
            } else {
                IFluidState fluidstate;
                IHorizontalSlabSupport horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((IBlockReader)world, pos, state);
                boolean verticalSlab = state.func_177230_c() == DSBlocks.VERTICAL_SLAB.get() && (Boolean)state.func_177229_b((IProperty)VerticalSlabBlock.DOUBLE) == false && (((SlabTileEntity)world.func_175625_s(pos)).getPositiveBlockInfo().getBlockState() != null ? face == ((Direction)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176734_d() : face == state.func_177229_b((IProperty)VerticalSlabBlock.FACING));
                boolean offset = false;
                if (horizontalSlabSupport == null && !verticalSlab) {
                    IVerticalSlabSupport verticalSlabSupport = SlabSupport.getVerticalSlabSupport((IBlockReader)world, pos, state);
                    if (verticalSlabSupport != null) {
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(state.func_177230_c())) {
                            return;
                        }
                        Direction direction = verticalSlabSupport.getDirection(world, pos, state);
                        if (face == direction) {
                            state = PlacementHandler.prepareState(state);
                            if (PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                                return;
                            }
                            BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, SlabType.BOTTOM, horizontalSlabItemSupport);
                            BlockState newState = (BlockState)((BlockState)((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).func_196258_a(context).func_206870_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)VerticalSlabBlock.FACING, (Comparable)direction);
                            if (PlacementHandler.placeSlab(world, pos, newState, player, state, slabState)) {
                                PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                            }
                            return;
                        }
                    }
                    BlockPos newPos = pos.func_177972_a(face);
                    BlockState newState = world.func_180495_p(newPos);
                    offset = true;
                    verticalSlab = newState.func_177230_c() == DSBlocks.VERTICAL_SLAB.get() && (Boolean)newState.func_177229_b((IProperty)VerticalSlabBlock.DOUBLE) == false;
                    horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((IBlockReader)world, newPos, newState);
                    if (horizontalSlabSupport == null && !verticalSlab) {
                        verticalSlabSupport = SlabSupport.getVerticalSlabSupport((IBlockReader)world, newPos, newState);
                        if (verticalSlabSupport != null) {
                            if (DSConfig.SERVER.isBlacklistedVerticalSlab(newState.func_177230_c())) {
                                return;
                            }
                            newState = PlacementHandler.prepareState(newState);
                            Direction direction = verticalSlabSupport.getDirection(world, newPos, newState);
                            BlockState slabState = PlacementHandler.getStateFromSupport(world, newPos, player, hand, stack, SlabType.BOTTOM, horizontalSlabItemSupport);
                            BlockState verticalSlabState = (BlockState)((BlockState)((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).func_196258_a(context).func_206870_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)VerticalSlabBlock.FACING, (Comparable)direction);
                            if (PlacementHandler.placeSlab(world, newPos, verticalSlabState, player, newState, slabState)) {
                                PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                            }
                        } else if (PlacementHandler.shouldPlaceVerticalSlab(player, face)) {
                            BlockState slabState;
                            if (state.func_196953_a(context)) {
                                newState = state;
                                newPos = pos;
                                if (PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                                    return;
                                }
                            } else if (!newState.func_196953_a(context)) {
                                return;
                            }
                            if (DSConfig.SERVER.isBlacklistedVerticalSlab((slabState = PlacementHandler.getStateFromSupport(world, newPos, player, hand, stack, SlabType.BOTTOM, horizontalSlabItemSupport)).func_177230_c())) {
                                return;
                            }
                            if (PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                                return;
                            }
                            BlockState verticalSlabState = ((DynamicSlabBlock)DSBlocks.VERTICAL_SLAB.get()).func_196258_a(context);
                            if (PlacementHandler.placeSlab(world, newPos, verticalSlabState, player, tile -> tile.getPositiveBlockInfo().setBlockState(slabState))) {
                                PlacementHandler.finishBlockPlacement(world, newPos, slabState, player, event.getItemStack(), cancel);
                            }
                        }
                        return;
                    }
                    state = newState;
                    pos = newPos;
                    if (horizontalSlabSupport != null) {
                        Direction direction = face = horizontalSlabSupport.getHalf(world, pos, newState) == SlabType.BOTTOM ? Direction.UP : Direction.DOWN;
                    }
                }
                if (verticalSlab) {
                    if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                        return;
                    }
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof SlabTileEntity && !player.func_70093_af() && (face != state.func_177229_b((IProperty)VerticalSlabBlock.FACING) || ((SlabTileEntity)tileEntity).getPositiveBlockInfo().getBlockState() == null)) {
                        SlabTileEntity tile2 = (SlabTileEntity)tileEntity;
                        fluidstate = world.func_204610_c(pos);
                        BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, tile2.getPositiveBlockInfo().getBlockState() != null ? SlabType.TOP : SlabType.BOTTOM, horizontalSlabItemSupport);
                        BlockState newState = (BlockState)((BlockState)state.func_206870_a((IProperty)VerticalSlabBlock.DOUBLE, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)VerticalSlabBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a && (VerticalSlabBlock.either((IBlockReader)world, pos, i -> i.getSupport() != null && i.getSupport().waterloggableWhenDouble(i.getWorld(), i.getPos(), i.getBlockState())) || horizontalSlabItemSupport.waterloggableWhenDouble(world, pos, slabState))));
                        if (DSConfig.SERVER.isBlacklistedVerticalSlab(slabState.func_177230_c())) {
                            return;
                        }
                        if (PlacementHandler.placeSlab(world, pos, newState, player, t -> {
                            if (t.getPositiveBlockInfo().getBlockState() != null) {
                                t.getNegativeBlockInfo().setBlockState(slabState);
                            } else {
                                t.getPositiveBlockInfo().setBlockState(slabState);
                            }
                        })) {
                            PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                        }
                        return;
                    }
                }
                if (horizontalSlabSupport == null) {
                    return;
                }
                if (DSConfig.SERVER.isBlacklistedHorizontalSlab(state.func_177230_c())) {
                    return;
                }
                SlabType half = horizontalSlabSupport.getHalf(world, pos, state);
                if (half == SlabType.DOUBLE) {
                    return;
                }
                if (!((Boolean)DSConfig.SERVER.replaceSameSlab.get()).booleanValue() && horizontalSlabItemSupport.equals(horizontalSlabSupport) && horizontalSlabSupport.areSame(world, pos, state, stack)) {
                    return;
                }
                if (face == Direction.UP && half == SlabType.BOTTOM || face == Direction.DOWN && half == SlabType.TOP) {
                    TileEntity tileEntity;
                    BlockState finalState1;
                    state = PlacementHandler.prepareState(state);
                    if (!offset && PlacementHandler.activateBlock(world, pos, player, hand, cancel)) {
                        return;
                    }
                    BlockState slabState = PlacementHandler.getStateFromSupport(world, pos, player, hand, stack, half == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM, horizontalSlabItemSupport);
                    if (DSConfig.SERVER.isBlacklistedHorizontalSlab(slabState.func_177230_c())) {
                        return;
                    }
                    fluidstate = world.func_204610_c(pos);
                    BlockState newState = (BlockState)((DynamicSlabBlock)DSBlocks.DOUBLE_SLAB.get()).func_196258_a(context).func_206870_a((IProperty)DoubleSlabBlock.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a && (horizontalSlabItemSupport.waterloggableWhenDouble(world, pos, slabState) || horizontalSlabSupport.waterloggableWhenDouble(world, pos, state))));
                    if (PlacementHandler.placeSlab(world, pos, newState, player, arg_0 -> PlacementHandler.lambda$onItemUse$7(half, finalState1 = state, tileEntity = world.func_175625_s(pos), slabState, arg_0))) {
                        PlacementHandler.finishBlockPlacement(world, pos, slabState, player, event.getItemStack(), cancel);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void lambda$onItemUse$7(SlabType half, BlockState finalState1, TileEntity tileEntity, BlockState slabState, SlabTileEntity tile) {
        if (half == SlabType.BOTTOM) {
            tile.getNegativeBlockInfo().setBlockState(finalState1);
            tile.getNegativeBlockInfo().setTileEntity(tileEntity);
            tile.getPositiveBlockInfo().setBlockState(slabState);
        } else {
            tile.getNegativeBlockInfo().setBlockState(slabState);
            tile.getPositiveBlockInfo().setBlockState(finalState1);
            tile.getPositiveBlockInfo().setTileEntity(tileEntity);
        }
    }

    private static /* synthetic */ void lambda$onItemUse$3(BlockState slabState, BlockState finalState, SlabTileEntity tile) {
        tile.getPositiveBlockInfo().setBlockState(slabState);
        tile.getNegativeBlockInfo().setBlockState(finalState);
    }
}

