/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.mixin;

import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.client.util.AmbientOcclusionFace;
import cjminecraft.doubleslabs.client.util.DoubleSlabCulling;
import cjminecraft.doubleslabs.common.blocks.VerticalSlabBlock;
import cjminecraft.doubleslabs.common.tileentity.SlabTileEntity;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.LightUtil;

@OnlyIn(value=Dist.CLIENT)
public abstract class BlockModelRendererMixin {
    public static boolean renderModelSmooth(BlockModelRenderer renderer, IEnviromentBlockReader world, IBakedModel model, BlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, Random random, long rand, IModelData modelData) {
        if (model instanceof DynamicSlabBakedModel) {
            boolean flag = false;
            float[] afloat = new float[Direction.values().length * 2];
            BitSet bitset = new BitSet(3);
            AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new AmbientOcclusionFace();
            boolean doubleSlab = false;
            boolean renderNegative = true;
            boolean renderPositive = true;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof SlabTileEntity) {
                SlabTileEntity slab = (SlabTileEntity)tile;
                doubleSlab = slab.getPositiveBlockInfo().getBlockState() != null && slab.getNegativeBlockInfo().getBlockState() != null && DynamicSlabBakedModel.useDoubleSlabModel(slab.getPositiveBlockInfo().getBlockState(), slab.getNegativeBlockInfo().getBlockState());
                renderNegative = slab.getNegativeBlockInfo().getBlockState() != null;
                renderPositive = slab.getPositiveBlockInfo().getBlockState() != null;
            }
            for (Direction direction : Direction.values()) {
                List quads;
                random.setSeed(rand);
                if (doubleSlab) {
                    quads = model.getQuads(state, direction, random, modelData);
                    if (quads.isEmpty() || checkSides && !DoubleSlabCulling.shouldDoubleSlabSideBeRendered(state, world, pos, direction)) continue;
                    BlockModelRendererMixin.renderQuadsSmooth(renderer, world, state, pos, buffer, quads, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                    flag = true;
                    continue;
                }
                if (renderPositive) {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)true);
                    quads = model.getQuads(state, direction, random, modelData);
                    if (!(quads.isEmpty() || checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, true))) {
                        BlockModelRendererMixin.renderQuadsSmooth(renderer, world, state, pos, buffer, quads, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                        flag = true;
                    }
                }
                if (!renderNegative) continue;
                if (MinecraftForgeClient.getRenderLayer() == null && model instanceof VerticalSlabBakedModel) {
                    BlockState newState = (BlockState)state.func_206870_a((IProperty)VerticalSlabBlock.FACING, (Comparable)((Direction)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176734_d());
                    quads = ((VerticalSlabBakedModel)model).getModel(newState).getQuads(newState, direction, random, modelData);
                } else {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)false);
                    quads = model.getQuads(state, direction, random, modelData);
                }
                if (quads.isEmpty() || checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, false)) continue;
                BlockModelRendererMixin.renderQuadsSmooth(renderer, world, state, pos, buffer, quads, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                flag = true;
            }
            modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, null);
            random.setSeed(rand);
            List list1 = model.getQuads(state, null, random, modelData);
            if (!list1.isEmpty()) {
                BlockModelRendererMixin.renderQuadsSmooth(renderer, world, state, pos, buffer, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface);
                flag = true;
            }
            return flag;
        }
        return false;
    }

    public static boolean renderModelFlat(BlockModelRenderer renderer, IEnviromentBlockReader world, IBakedModel model, BlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, Random random, long rand, IModelData modelData) {
        if (model instanceof DynamicSlabBakedModel) {
            boolean flag = false;
            BitSet bitset = new BitSet(3);
            boolean doubleSlab = false;
            boolean renderNegative = true;
            boolean renderPositive = true;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof SlabTileEntity) {
                SlabTileEntity slab = (SlabTileEntity)tile;
                doubleSlab = slab.getPositiveBlockInfo().getBlockState() != null && slab.getNegativeBlockInfo().getBlockState() != null && DynamicSlabBakedModel.useDoubleSlabModel(slab.getPositiveBlockInfo().getBlockState(), slab.getNegativeBlockInfo().getBlockState());
                renderNegative = slab.getNegativeBlockInfo().getBlockState() != null;
                renderPositive = slab.getPositiveBlockInfo().getBlockState() != null;
            }
            for (Direction direction : Direction.values()) {
                List list;
                random.setSeed(rand);
                if (doubleSlab) {
                    list = model.getQuads(state, direction, random, modelData);
                    if (list.isEmpty() || checkSides && !DoubleSlabCulling.shouldDoubleSlabSideBeRendered(state, world, pos, direction)) continue;
                    int i = state.func_215684_a(world, pos.func_177972_a(direction));
                    BlockModelRendererMixin.renderQuadsFlat(renderer, world, state, pos, i, false, buffer, list, bitset);
                    flag = true;
                    continue;
                }
                if (renderPositive) {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)true);
                    list = model.getQuads(state, direction, random, modelData);
                    if (!(list.isEmpty() || checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, true))) {
                        int i = state.func_215684_a(world, pos.func_177972_a(direction));
                        BlockModelRendererMixin.renderQuadsFlat(renderer, world, state, pos, i, false, buffer, list, bitset);
                        flag = true;
                    }
                }
                if (!renderNegative) continue;
                modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)false);
                if (MinecraftForgeClient.getRenderLayer() == null && model instanceof VerticalSlabBakedModel) {
                    BlockState newState = (BlockState)state.func_206870_a((IProperty)VerticalSlabBlock.FACING, (Comparable)((Direction)state.func_177229_b((IProperty)VerticalSlabBlock.FACING)).func_176734_d());
                    list = ((VerticalSlabBakedModel)model).getModel(newState).getQuads(newState, direction, random, modelData);
                } else {
                    modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, (Object)false);
                    list = model.getQuads(state, direction, random, modelData);
                }
                if (list.isEmpty() || checkSides && !DoubleSlabCulling.shouldSideBeRendered(state, world, pos, direction, false)) continue;
                int i = state.func_215684_a(world, pos.func_177972_a(direction));
                BlockModelRendererMixin.renderQuadsFlat(renderer, world, state, pos, i, false, buffer, list, bitset);
                flag = true;
            }
            modelData.setData(DynamicSlabBakedModel.RENDER_POSITIVE, null);
            random.setSeed(rand);
            List list1 = model.getQuads(state, (Direction)null, random, modelData);
            if (!list1.isEmpty()) {
                BlockModelRendererMixin.renderQuadsFlat(renderer, world, state, pos, -1, true, buffer, list1, bitset);
                flag = true;
            }
            return flag;
        }
        return false;
    }

    private static void fillQuadBounds(IEnviromentBlockReader blockReaderIn, BlockState stateIn, BlockPos posIn, int[] vertexData, Direction face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * 8]);
            float f7 = Float.intBitsToFloat(vertexData[i * 8 + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * 8 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[Direction.WEST.func_176745_a()] = f;
            quadBounds[Direction.EAST.func_176745_a()] = f3;
            quadBounds[Direction.DOWN.func_176745_a()] = f1;
            quadBounds[Direction.UP.func_176745_a()] = f4;
            quadBounds[Direction.NORTH.func_176745_a()] = f2;
            quadBounds[Direction.SOUTH.func_176745_a()] = f5;
            int j = Direction.values().length;
            quadBounds[Direction.WEST.func_176745_a() + j] = 1.0f - f;
            quadBounds[Direction.EAST.func_176745_a() + j] = 1.0f - f3;
            quadBounds[Direction.DOWN.func_176745_a() + j] = 1.0f - f1;
            quadBounds[Direction.UP.func_176745_a() + j] = 1.0f - f4;
            quadBounds[Direction.NORTH.func_176745_a() + j] = 1.0f - f2;
            quadBounds[Direction.SOUTH.func_176745_a() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (face) {
            case DOWN: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f1 == f4 && (f1 < 1.0E-4f || stateIn.func_224756_o((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case UP: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f1 == f4 && (f4 > 0.9999f || stateIn.func_224756_o((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case NORTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, f2 == f5 && (f2 < 1.0E-4f || stateIn.func_224756_o((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case SOUTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, f2 == f5 && (f5 > 0.9999f || stateIn.func_224756_o((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case WEST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f == f3 && (f < 1.0E-4f || stateIn.func_224756_o((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case EAST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f == f3 && (f3 > 0.9999f || stateIn.func_224756_o((IBlockReader)blockReaderIn, posIn)));
            }
        }
    }

    private static void renderQuadsSmooth(BlockModelRenderer renderer, IEnviromentBlockReader worldIn, BlockState state, BlockPos pos, BufferBuilder buffer, List<BakedQuad> quads, float[] weights, BitSet bitSet, AmbientOcclusionFace aoFace) {
        Vec3d vec3d = state.func_191059_e((IBlockReader)worldIn, pos);
        double d0 = (double)pos.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)pos.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)pos.func_177952_p() + vec3d.field_72449_c;
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            BlockModelRendererMixin.fillQuadBounds(worldIn, state, pos, bakedquad.func_178209_a(), bakedquad.func_178210_d(), weights, bitSet);
            aoFace.updateVertexBrightness(worldIn, state, pos, bakedquad.func_178210_d(), weights, bitSet);
            buffer.func_178981_a(bakedquad.func_178209_a());
            buffer.func_178962_a(aoFace.vertexBrightness[0], aoFace.vertexBrightness[1], aoFace.vertexBrightness[2], aoFace.vertexBrightness[3]);
            if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((Direction)bakedquad.func_178210_d());
                aoFace.vertexColorMultiplier[0] = aoFace.vertexColorMultiplier[0] * diffuse;
                aoFace.vertexColorMultiplier[1] = aoFace.vertexColorMultiplier[1] * diffuse;
                aoFace.vertexColorMultiplier[2] = aoFace.vertexColorMultiplier[2] * diffuse;
                aoFace.vertexColorMultiplier[3] = aoFace.vertexColorMultiplier[3] * diffuse;
            }
            if (bakedquad.func_178212_b()) {
                int k = renderer.field_187499_a.func_216860_a(state, worldIn, pos, bakedquad.func_178211_c());
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                buffer.func_178978_a(aoFace.vertexColorMultiplier[0] * f, aoFace.vertexColorMultiplier[0] * f1, aoFace.vertexColorMultiplier[0] * f2, 4);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[1] * f, aoFace.vertexColorMultiplier[1] * f1, aoFace.vertexColorMultiplier[1] * f2, 3);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[2] * f, aoFace.vertexColorMultiplier[2] * f1, aoFace.vertexColorMultiplier[2] * f2, 2);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[3] * f, aoFace.vertexColorMultiplier[3] * f1, aoFace.vertexColorMultiplier[3] * f2, 1);
            } else {
                buffer.func_178978_a(aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[0], 4);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[1], 3);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[2], 2);
                buffer.func_178978_a(aoFace.vertexColorMultiplier[3], aoFace.vertexColorMultiplier[3], aoFace.vertexColorMultiplier[3], 1);
            }
            buffer.func_178987_a(d0, d1, d2);
        }
    }

    private static void renderQuadsFlat(BlockModelRenderer renderer, IEnviromentBlockReader world, BlockState state, BlockPos pos, int brightness, boolean ownBrightness, BufferBuilder buffer, List<BakedQuad> list, BitSet bitSet) {
        Vec3d vec3d = state.func_191059_e((IBlockReader)world, pos);
        double d0 = (double)pos.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)pos.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)pos.func_177952_p() + vec3d.field_72449_c;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = list.get(i);
            if (ownBrightness) {
                BlockModelRendererMixin.fillQuadBounds(world, state, pos, bakedquad.func_178209_a(), bakedquad.func_178210_d(), null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? pos.func_177972_a(bakedquad.func_178210_d()) : pos;
                brightness = state.func_215684_a(world, blockpos);
            }
            buffer.func_178981_a(bakedquad.func_178209_a());
            buffer.func_178962_a(brightness, brightness, brightness, brightness);
            if (bakedquad.func_178212_b()) {
                int k = renderer.field_187499_a.func_216860_a(state, world, pos, bakedquad.func_178211_c());
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                if (bakedquad.shouldApplyDiffuseLighting()) {
                    float diffuse = LightUtil.diffuseLight((Direction)bakedquad.func_178210_d());
                    f *= diffuse;
                    f1 *= diffuse;
                    f2 *= diffuse;
                }
                buffer.func_178978_a(f, f1, f2, 4);
                buffer.func_178978_a(f, f1, f2, 3);
                buffer.func_178978_a(f, f1, f2, 2);
                buffer.func_178978_a(f, f1, f2, 1);
            } else if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((Direction)bakedquad.func_178210_d());
                buffer.func_178978_a(diffuse, diffuse, diffuse, 4);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 3);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 2);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 1);
            }
            buffer.func_178987_a(d0, d1, d2);
        }
    }
}

