/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.zlt.create_vibrant_vaults.block.ModBlockTags;
import org.apache.commons.lang3.tuple.Pair;

public final class ItemVaultConnectivityHelper {
    private ItemVaultConnectivityHelper() {
    }

    public static Direction.Axis getItemVaultPreferredAxis(Block placing, BlockState placedOn) {
        return ModBlockTags.VERTICAL_VAULTS.matches(placedOn) || !ItemVaultConnectivityHelper.isVault(placedOn, placing) ? null : (Direction.Axis)placedOn.m_61143_(ItemVaultBlock.HORIZONTAL_AXIS);
    }

    public static boolean isVault(Block block) {
        return AllBlocks.ITEM_VAULT.is((Object)block) || ModBlockTags.VIBRANT_VAULTS.matches(block);
    }

    public static boolean isVault(BlockState state) {
        return ItemVaultConnectivityHelper.isVault(state.m_60734_());
    }

    public static boolean isVault(Block a, Block b) {
        if (AllBlocks.ITEM_VAULT.is((Object)a)) {
            return AllBlocks.ITEM_VAULT.is((Object)b);
        }
        if (ModBlockTags.VIBRANT_VAULTS.matches(a)) {
            return a == b;
        }
        return false;
    }

    public static boolean isVault(BlockState a, Block b) {
        return ItemVaultConnectivityHelper.isVault(a.m_60734_(), b);
    }

    public static boolean isVault(BlockState a, BlockState b) {
        return ItemVaultConnectivityHelper.isVault(a.m_60734_(), b.m_60734_());
    }

    public static boolean isVault(BlockEntity a, Block b) {
        return ItemVaultConnectivityHelper.isVault(a.m_58900_(), b);
    }

    public static boolean isVault(BlockEntity a, BlockEntity b) {
        return ItemVaultConnectivityHelper.isVault(a.m_58900_(), b.m_58900_());
    }

    public static <T extends BlockEntity> void formItemVaultMulti(T be) {
        SearchCache cache = new SearchCache();
        ArrayList<T> frontier = new ArrayList<T>();
        frontier.add(be);
        ItemVaultConnectivityHelper.formItemVaultMulti(be, (BlockGetter)be.m_58904_(), cache, frontier);
    }

    @Nullable
    private static <T extends BlockEntity> T checked(BlockEntity be) {
        return (T)(be instanceof IMultiBlockEntityContainer ? be : null);
    }

    @Nullable
    public static <T extends BlockEntity> T partAt(Block block, BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        return be != null && ItemVaultConnectivityHelper.isVault(be, block) && !be.m_58901_() ? (T)ItemVaultConnectivityHelper.checked(be) : null;
    }

    @Nullable
    public static <T extends BlockEntity> T partAt(BlockEntity blockEntity, BlockGetter level, BlockPos pos) {
        return ItemVaultConnectivityHelper.partAt(blockEntity.m_58900_().m_60734_(), level, pos);
    }

    public static <T extends BlockEntity> void splitItemVaultMulti(T be) {
        ItemVaultConnectivityHelper.splitItemVaultMultiAndInvalidate(be, null);
    }

    private static <T extends BlockEntity> void splitItemVaultMultiAndInvalidate(T be, @Nullable SearchCache<T> cache) {
        Level level = be.m_58904_();
        if (level == null) {
            return;
        }
        if ((be = ((IMultiBlockEntityContainer)be).getControllerBE()) == null) {
            return;
        }
        int height = ((IMultiBlockEntityContainer)be).getHeight();
        int width = ((IMultiBlockEntityContainer)be).getWidth();
        if (width == 1 && height == 1) {
            return;
        }
        BlockPos origin = be.m_58899_();
        Direction.Axis axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> origin.m_7918_(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.m_7918_(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.m_7918_(xOffset, zOffset, yOffset);
                    };
                    T partAt = ItemVaultConnectivityHelper.partAt(be, (BlockGetter)level, pos);
                    if (partAt == null || !((IMultiBlockEntityContainer)partAt).getController().equals((Object)origin)) continue;
                    BlockEntity controllerBE = ((IMultiBlockEntityContainer)partAt).getControllerBE();
                    ((IMultiBlockEntityContainer)partAt).setExtraData(controllerBE == null ? null : ((IMultiBlockEntityContainer)controllerBE).getExtraData());
                    ((IMultiBlockEntityContainer)partAt).removeController(true);
                    if (cache == null) continue;
                    cache.put(pos, partAt);
                }
            }
        }
    }

    private static <T extends BlockEntity> int tryToFormNewItemVaultMultiOfWidth(T be, int width, SearchCache<T> cache, boolean simulate) {
        int amount = 0;
        int height = 0;
        Level level = be.m_58904_();
        if (level == null) {
            return 0;
        }
        BlockPos origin = be.m_58899_();
        Direction.Axis axis = ((IMultiBlockEntityContainer)be).getMainConnectionAxis();
        block10: for (int yOffset = 0; yOffset < ((IMultiBlockEntityContainer)be).getMaxLength(axis, width); ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos conPos;
                    Direction.Axis conAxis;
                    BlockEntity controller;
                    int otherWidth;
                    BlockPos pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> origin.m_7918_(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.m_7918_(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.m_7918_(xOffset, zOffset, yOffset);
                    };
                    Optional<T> part = cache.getOrCache(be, (BlockGetter)level, pos);
                    if (part.isEmpty() || (otherWidth = ((IMultiBlockEntityContainer)(controller = (BlockEntity)part.get())).getWidth()) > width || otherWidth == width && ((IMultiBlockEntityContainer)controller).getHeight() == ((IMultiBlockEntityContainer)be).getMaxLength(axis, width) || axis != (conAxis = ((IMultiBlockEntityContainer)controller).getMainConnectionAxis()) || !(conPos = controller.m_58899_()).equals((Object)origin) && (axis == Direction.Axis.Y ? conPos.m_123341_() < origin.m_123341_() || conPos.m_123343_() < origin.m_123343_() || conPos.m_123341_() + otherWidth > origin.m_123341_() + width || conPos.m_123343_() + otherWidth > origin.m_123343_() + width : axis == Direction.Axis.Z && conPos.m_123341_() < origin.m_123341_() || conPos.m_123342_() < origin.m_123342_() || axis == Direction.Axis.X && conPos.m_123343_() < origin.m_123343_() || axis == Direction.Axis.Z && conPos.m_123341_() + otherWidth > origin.m_123341_() + width || conPos.m_123342_() + otherWidth > origin.m_123342_() + width || axis == Direction.Axis.X && conPos.m_123343_() + otherWidth > origin.m_123343_() + width)) break block10;
                }
            }
            amount += width * width;
            ++height;
        }
        if (simulate) {
            return amount;
        }
        Object extraData = ((IMultiBlockEntityContainer)be).getExtraData();
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = switch (axis) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.Axis.X -> origin.m_7918_(yOffset, xOffset, zOffset);
                        case Direction.Axis.Y -> origin.m_7918_(xOffset, yOffset, zOffset);
                        case Direction.Axis.Z -> origin.m_7918_(xOffset, zOffset, yOffset);
                    };
                    T part = ItemVaultConnectivityHelper.partAt(be, (BlockGetter)level, pos);
                    if (part == null || part == be) continue;
                    extraData = ((IMultiBlockEntityContainer)be).modifyExtraData(extraData);
                    ItemVaultConnectivityHelper.splitItemVaultMultiAndInvalidate(part, cache);
                    ((IMultiBlockEntityContainer)part).setController(origin);
                    ((IMultiBlockEntityContainer)part).preventConnectivityUpdate();
                    cache.put(pos, be);
                    ((IMultiBlockEntityContainer)part).setHeight(height);
                    ((IMultiBlockEntityContainer)part).setWidth(width);
                    ((IMultiBlockEntityContainer)part).notifyMultiUpdated();
                }
            }
        }
        ((IMultiBlockEntityContainer)be).setExtraData(extraData);
        ((IMultiBlockEntityContainer)be).notifyMultiUpdated();
        return amount;
    }

    private static <T extends BlockEntity> int tryToFormNewItemVaultMulti(T be, SearchCache<T> cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!((IMultiBlockEntityContainer)be).isController()) {
            return 0;
        }
        int radius = ((IMultiBlockEntityContainer)be).getMaxWidth();
        for (int w = 1; w <= radius; ++w) {
            int amount = ItemVaultConnectivityHelper.tryToFormNewItemVaultMultiOfWidth(be, w, cache, true);
            if (amount < bestAmount) continue;
            bestWidth = w;
            bestAmount = amount;
        }
        if (!simulate) {
            int beWidth = ((IMultiBlockEntityContainer)be).getWidth();
            if (beWidth == bestWidth && beWidth * beWidth * ((IMultiBlockEntityContainer)be).getHeight() == bestAmount) {
                return bestAmount;
            }
            ItemVaultConnectivityHelper.splitItemVaultMultiAndInvalidate(be, cache);
            ItemVaultConnectivityHelper.tryToFormNewItemVaultMultiOfWidth(be, bestWidth, cache, false);
            ((IMultiBlockEntityContainer)be).preventConnectivityUpdate();
            ((IMultiBlockEntityContainer)be).setWidth(bestWidth);
            ((IMultiBlockEntityContainer)be).setHeight(bestAmount / bestWidth / bestWidth);
            ((IMultiBlockEntityContainer)be).notifyMultiUpdated();
        }
        return bestAmount;
    }

    private static <T extends BlockEntity> void formItemVaultMulti(BlockEntity blockEntity, BlockGetter level, SearchCache<T> cache, List<T> frontier) {
        PriorityQueue<Pair> creationQueue = new PriorityQueue<Pair>((one, two) -> (Integer)two.getKey() - (Integer)one.getKey());
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        Direction.Axis mainAxis = ((IMultiBlockEntityContainer)((BlockEntity)frontier.get(0))).getMainConnectionAxis();
        int minX = mainAxis == Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minY = mainAxis != Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int minZ = mainAxis == Direction.Axis.Y ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        for (BlockEntity be : frontier) {
            BlockPos pos = be.m_58899_();
            minX = Math.min(pos.m_123341_(), minX);
            minY = Math.min(pos.m_123342_(), minY);
            minZ = Math.min(pos.m_123343_(), minZ);
        }
        if (mainAxis == Direction.Axis.Y) {
            minX -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.get(0))).getMaxWidth();
        }
        if (mainAxis != Direction.Axis.Y) {
            minY -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.get(0))).getMaxWidth();
        }
        if (mainAxis == Direction.Axis.Y) {
            minZ -= ((IMultiBlockEntityContainer)((BlockEntity)frontier.get(0))).getMaxWidth();
        }
        while (!frontier.isEmpty()) {
            BlockEntity part = (BlockEntity)frontier.remove(0);
            BlockPos partPos = part.m_58899_();
            if (visited.contains(partPos)) continue;
            visited.add(partPos);
            int amount = ItemVaultConnectivityHelper.tryToFormNewItemVaultMulti(part, cache, true);
            if (amount > 1) {
                creationQueue.add(Pair.of((Object)amount, (Object)part));
            }
            for (Direction.Axis axis : Iterate.axes) {
                T nextBe;
                Direction dir = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
                BlockPos next = partPos.m_121945_(dir);
                if (next.m_123341_() <= minX || next.m_123342_() <= minY || next.m_123343_() <= minZ || visited.contains(next) || (nextBe = ItemVaultConnectivityHelper.partAt(blockEntity, level, next)) == null || nextBe.m_58901_()) continue;
                frontier.add(nextBe);
            }
        }
        visited.clear();
        while (!creationQueue.isEmpty()) {
            Pair next = (Pair)creationQueue.poll();
            BlockEntity toCreate = (BlockEntity)next.getValue();
            if (visited.contains(toCreate.m_58899_())) continue;
            visited.add(toCreate.m_58899_());
            ItemVaultConnectivityHelper.tryToFormNewItemVaultMulti(toCreate, cache, false);
        }
    }

    private static class SearchCache<T extends BlockEntity> {
        Map<BlockPos, Optional<T>> controllerMap = new HashMap<BlockPos, Optional<T>>();

        void put(BlockPos pos, T target) {
            this.controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(BlockPos pos) {
            this.controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(BlockPos pos) {
            return this.controllerMap.containsKey(pos);
        }

        Optional<T> getOrCache(BlockEntity be, BlockGetter level, BlockPos pos) {
            if (this.hasVisited(pos)) {
                return this.controllerMap.get(pos);
            }
            Object partAt = ItemVaultConnectivityHelper.partAt(be, level, pos);
            if (partAt == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            Object controller = ItemVaultConnectivityHelper.checked(level.m_7702_(((IMultiBlockEntityContainer)partAt).getController()));
            if (controller == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            this.put(pos, controller);
            return Optional.of(controller);
        }
    }
}

