/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block;

import com.simibubi.create.AllTags;
import net.createmod.catnip.lang.Lang;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.ModBlocks;

public enum ModBlockTags {
    VAULTS,
    VIBRANT_VAULTS,
    HORIZONTAL_VAULTS,
    VERTICAL_VAULTS,
    ITEM_VAULTS,
    SHIPPING_CONTAINERS,
    BASIC_SHIPPING_CONTAINERS,
    WHITE_VAULTS,
    ORANGE_VAULTS,
    MAGENTA_VAULTS,
    LIGHT_BLUE_VAULTS,
    YELLOW_VAULTS,
    LIME_VAULTS,
    PINK_VAULTS,
    GRAY_VAULTS,
    LIGHT_GRAY_VAULTS,
    CYAN_VAULTS,
    PURPLE_VAULTS,
    BLUE_VAULTS,
    BROWN_VAULTS,
    GREEN_VAULTS,
    RED_VAULTS,
    BLACK_VAULTS,
    BASE_VAULTS,
    COLORED_HORIZONTAL_ITEM_VAULTS,
    COLORED_VERTICAL_ITEM_VAULTS,
    COLORED_HORIZONTAL_SHIPPING_CONTAINERS,
    COLORED_VERTICAL_SHIPPING_CONTAINERS,
    COLORED_HORIZONTAL_BASIC_SHIPPING_CONTAINERS,
    COLORED_VERTICAL_BASIC_SHIPPING_CONTAINERS,
    FROGPORTS,
    VIBRANT_FROGPORTS,
    STOCK_LINKS,
    VIBRANT_STOCK_LINKS,
    REDSTONE_REQUESTERS,
    VIBRANT_REDSTONE_REQUESTERS,
    PACKAGERS,
    VIBRANT_PACKAGERS;

    public final TagKey<Block> tag = AllTags.optionalTag((IForgeRegistry)ForgeRegistries.BLOCKS, (ResourceLocation)CreateVibrantVaults.asResource(Lang.asId((String)this.name())));

    public boolean matches(Block block) {
        return block.m_204297_().m_203656_(this.tag);
    }

    public boolean matches(ItemStack stack) {
        BlockItem blockItem;
        Item item;
        return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
    }

    public boolean matches(BlockState state) {
        return state.m_204336_(this.tag);
    }

    public static ModBlockTags ofType(ModBlocks.VibrantVaultType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ModBlocks.VibrantVaultType.ITEM_VAULT -> ITEM_VAULTS;
            case ModBlocks.VibrantVaultType.SHIPPING_CONTAINER -> SHIPPING_CONTAINERS;
            case ModBlocks.VibrantVaultType.BASIC_SHIPPING_CONTAINER -> BASIC_SHIPPING_CONTAINERS;
        };
    }

    public static ModBlockTags ofColor(ModBlocks.VibrantVaultColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case ModBlocks.VibrantVaultColor.WHITE -> WHITE_VAULTS;
            case ModBlocks.VibrantVaultColor.ORANGE -> ORANGE_VAULTS;
            case ModBlocks.VibrantVaultColor.MAGENTA -> MAGENTA_VAULTS;
            case ModBlocks.VibrantVaultColor.LIGHT_BLUE -> LIGHT_BLUE_VAULTS;
            case ModBlocks.VibrantVaultColor.YELLOW -> YELLOW_VAULTS;
            case ModBlocks.VibrantVaultColor.LIME -> LIME_VAULTS;
            case ModBlocks.VibrantVaultColor.PINK -> PINK_VAULTS;
            case ModBlocks.VibrantVaultColor.GRAY -> GRAY_VAULTS;
            case ModBlocks.VibrantVaultColor.LIGHT_GRAY -> LIGHT_GRAY_VAULTS;
            case ModBlocks.VibrantVaultColor.CYAN -> CYAN_VAULTS;
            case ModBlocks.VibrantVaultColor.PURPLE -> PURPLE_VAULTS;
            case ModBlocks.VibrantVaultColor.BLUE -> BLUE_VAULTS;
            case ModBlocks.VibrantVaultColor.BROWN -> BROWN_VAULTS;
            case ModBlocks.VibrantVaultColor.GREEN -> GREEN_VAULTS;
            case ModBlocks.VibrantVaultColor.RED -> RED_VAULTS;
            case ModBlocks.VibrantVaultColor.BLACK -> BLACK_VAULTS;
            case ModBlocks.VibrantVaultColor.BASE -> BASE_VAULTS;
        };
    }

    public static ModBlockTags ofOrientation(boolean vertical) {
        return vertical ? VERTICAL_VAULTS : HORIZONTAL_VAULTS;
    }

    public static ModBlockTags ofColored(ModBlocks.VibrantVaultType type, boolean vertical) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ModBlocks.VibrantVaultType.ITEM_VAULT -> {
                if (vertical) {
                    yield COLORED_VERTICAL_ITEM_VAULTS;
                }
                yield COLORED_HORIZONTAL_ITEM_VAULTS;
            }
            case ModBlocks.VibrantVaultType.SHIPPING_CONTAINER -> {
                if (vertical) {
                    yield COLORED_VERTICAL_SHIPPING_CONTAINERS;
                }
                yield COLORED_HORIZONTAL_SHIPPING_CONTAINERS;
            }
            case ModBlocks.VibrantVaultType.BASIC_SHIPPING_CONTAINER -> vertical ? COLORED_VERTICAL_BASIC_SHIPPING_CONTAINERS : COLORED_HORIZONTAL_BASIC_SHIPPING_CONTAINERS;
        };
    }

    public static void init() {
    }
}

