/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.create_vibrant_vaults.block;

import com.simibubi.create.AllMountedStorageTypes;
import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.content.logistics.packagePort.PackagePortItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlockItem;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.content.logistics.vault.ItemVaultItem;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import net.createmod.catnip.lang.Lang;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.HorizontalVaultBlock;
import net.zlt.create_vibrant_vaults.block.VerticalVaultBlock;
import net.zlt.create_vibrant_vaults.block.VibrantFrogportBlock;
import net.zlt.create_vibrant_vaults.block.VibrantPackagerBlock;
import net.zlt.create_vibrant_vaults.block.VibrantRedstoneRequesterBlock;
import net.zlt.create_vibrant_vaults.block.VibrantStockLinkBlock;
import net.zlt.create_vibrant_vaults.block.VibrantVaultBlock;
import net.zlt.create_vibrant_vaults.ct.HorizontalVaultCTBehaviour;
import net.zlt.create_vibrant_vaults.ct.VerticalVaultCTBehaviour;
import net.zlt.create_vibrant_vaults.data.VibrantPackagerBlockStateGenerator;
import net.zlt.create_vibrant_vaults.data.VibrantStockLinkBlockStateGenerator;
import net.zlt.create_vibrant_vaults.item.ModCreativeModeTabs;

public final class ModBlocks {
    public static final List<List<BlockEntry<VibrantVaultBlock>>> VIBRANT_VAULTS;
    public static final List<BlockEntry<VibrantFrogportBlock>> VIBRANT_FROGPORTS;
    public static final List<BlockEntry<VibrantStockLinkBlock>> VIBRANT_STOCK_LINKS;
    public static final List<BlockEntry<VibrantRedstoneRequesterBlock>> VIBRANT_REDSTONE_REQUESTERS;
    public static final List<BlockEntry<VibrantPackagerBlock>> VIBRANT_PACKAGERS;

    private ModBlocks() {
    }

    public static BlockEntry<VibrantVaultBlock> getVibrantVault(VibrantVaultType type, VibrantVaultColor color, boolean vertical) {
        return VIBRANT_VAULTS.get(type.ordinal() * 2 + (vertical ? 1 : 0)).get(color.ordinal());
    }

    public static BlockEntry<VibrantFrogportBlock> getVibrantFrogport(VibrantVaultColor color) {
        return VIBRANT_FROGPORTS.get(color.ordinal());
    }

    public static BlockEntry<VibrantStockLinkBlock> getVibrantStockLink(VibrantVaultColor color) {
        return VIBRANT_STOCK_LINKS.get(color.ordinal());
    }

    public static BlockEntry<VibrantRedstoneRequesterBlock> getVibrantRedstoneRequester(VibrantVaultColor color) {
        return VIBRANT_REDSTONE_REQUESTERS.get(color.ordinal());
    }

    public static BlockEntry<VibrantPackagerBlock> getVibrantPackager(VibrantVaultColor color) {
        return VIBRANT_PACKAGERS.get(color.ordinal());
    }

    private static NonNullBiConsumer<DataGenContext<Block, VibrantVaultBlock>, RegistrateBlockstateProvider> vibrantVaultBlockState(String blockName, String typeId, String colorId, boolean vertical) {
        return vertical ? (c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(blockName, CreateVibrantVaults.asResource("block/template_vertical_item_vault"))).texture("top", p.modLoc("block/" + typeId + "/" + colorId + "/vault_top_small"))).texture("side", p.modLoc("block/" + typeId + "/" + colorId + "/vault_side_small"))) : (c, p) -> p.getVariantBuilder((Block)c.get()).forAllStates(s -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().getBuilder(blockName)).parent((ModelFile)new ModelFile.UncheckedModelFile(Create.asResource((String)"block/item_vault")))).texture("0", p.modLoc("block/" + typeId + "/" + colorId + "/vault_bottom_small"))).texture("1", p.modLoc("block/" + typeId + "/" + colorId + "/vault_front_small"))).texture("2", p.modLoc("block/" + typeId + "/" + colorId + "/vault_side_small"))).texture("3", p.modLoc("block/" + typeId + "/" + colorId + "/vault_top_small"))).texture("particle", p.modLoc("block/" + typeId + "/" + colorId + "/vault_top_small"))).rotationY(s.m_61143_(ItemVaultBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? 90 : 0).build());
    }

    private static BlockEntry<VibrantVaultBlock> vibrantVault(VibrantVaultType type, VibrantVaultColor color, boolean vertical) {
        String typeId = type.asId(vertical);
        String colorId = color.asId();
        String blockName = color == VibrantVaultColor.BASE ? typeId : colorId + "_" + typeId;
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateVibrantVaults.REGISTRATE.block(blockName, properties -> vertical ? new VerticalVaultBlock(type, color, (BlockBehaviour.Properties)properties) : new HorizontalVaultBlock(type, color, (BlockBehaviour.Properties)properties)).initialProperties(SharedProperties::softMetal).properties(p -> p.m_284180_(color.mapColor).m_60918_(SoundType.f_56725_).m_155956_(1200.0f)).transform(TagGen.pickaxeOnly())).blockstate(ModBlocks.vibrantVaultBlockState(blockName, typeId, colorId, vertical)).onRegister(CreateRegistrate.connectedTextures(() -> vertical ? new VerticalVaultCTBehaviour(type, color) : new HorizontalVaultCTBehaviour(type, color)))).transform((NonNullFunction)MountedItemStorageType.mountedItemStorage((RegistryEntry)AllMountedStorageTypes.VAULT))).item(ItemVaultItem::new).build()).register();
    }

    private static BlockEntry<VibrantFrogportBlock> vibrantFrogport(VibrantVaultColor color) {
        return ((BlockBuilder)((BlockBuilder)CreateVibrantVaults.REGISTRATE.block(color.asId() + "_package_frogport", properties -> new VibrantFrogportBlock(color, (BlockBehaviour.Properties)properties)).initialProperties(SharedProperties::softMetal).properties(p -> p.m_60955_().m_284180_(color.mapColor).m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).addLayer(() -> RenderType::m_110457_).blockstate((c, p) -> p.simpleBlock((Block)c.getEntry(), (ModelFile)new ModelFile.UncheckedModelFile(p.modLoc("block/" + c.getName() + "/block")))).item(PackagePortItem::new).model(AssetLookup::customItemModel).build()).register();
    }

    private static BlockEntry<VibrantStockLinkBlock> vibrantStockLink(VibrantVaultColor color) {
        return ((BlockBuilder)((BlockBuilder)CreateVibrantVaults.REGISTRATE.block(color.asId() + "_stock_link", properties -> new VibrantStockLinkBlock(color, (BlockBehaviour.Properties)properties)).initialProperties(SharedProperties::softMetal).properties(p -> p.m_284180_(color.mapColor).m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).blockstate((arg_0, arg_1) -> ((VibrantStockLinkBlockStateGenerator)new VibrantStockLinkBlockStateGenerator()).generate(arg_0, arg_1)).item(LogisticallyLinkedBlockItem::new).transform(ModelGen.customItemModel((String[])new String[]{"_", "block_vertical"}))).register();
    }

    private static BlockEntry<VibrantRedstoneRequesterBlock> vibrantRedstoneRequester(VibrantVaultColor color) {
        return ((BlockBuilder)((BlockBuilder)CreateVibrantVaults.REGISTRATE.block(color.asId() + "_redstone_requester", properties -> new VibrantRedstoneRequesterBlock(color, (BlockBehaviour.Properties)properties)).initialProperties(SharedProperties::stone).properties(p -> p.m_60918_(SoundType.f_56725_).m_60955_()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> BlockStateGen.horizontalAxisBlock((DataGenContext)c, (RegistrateBlockstateProvider)p, state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? new ModelFile.UncheckedModelFile(p.modLoc("block/" + c.getName() + "/block_powered")) : new ModelFile.UncheckedModelFile(p.modLoc("block/" + c.getName() + "/block")))).item(RedstoneRequesterBlockItem::new).transform(ModelGen.customItemModel((String[])new String[]{"_", "block"}))).register();
    }

    private static BlockEntry<VibrantPackagerBlock> vibrantPackager(VibrantVaultColor color) {
        return ((BlockBuilder)((BlockBuilder)CreateVibrantVaults.REGISTRATE.block(color.asId() + "_packager", properties -> new VibrantPackagerBlock(color, (BlockBehaviour.Properties)properties)).initialProperties(SharedProperties::softMetal).properties(p -> p.m_60955_().m_60924_(($1, $2, $3) -> false).m_284180_(color.mapColor).m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).addLayer(() -> RenderType::m_110457_).blockstate((arg_0, arg_1) -> ((VibrantPackagerBlockStateGenerator)new VibrantPackagerBlockStateGenerator()).generate(arg_0, arg_1)).item().model(AssetLookup::customItemModel).build()).register();
    }

    private static List<List<BlockEntry<VibrantVaultBlock>>> getVibrantVaults() {
        VibrantVaultColor[] colors = VibrantVaultColor.values();
        VibrantVaultType[] types = VibrantVaultType.values();
        ArrayList<List<BlockEntry<VibrantVaultBlock>>> result = new ArrayList<List<BlockEntry<VibrantVaultBlock>>>(types.length * 2);
        for (VibrantVaultType type : types) {
            boolean includeBaseColor = type != VibrantVaultType.ITEM_VAULT;
            ArrayList<BlockEntry<VibrantVaultBlock>> horizontalVaults = new ArrayList<BlockEntry<VibrantVaultBlock>>(includeBaseColor ? colors.length : colors.length - 1);
            ArrayList<BlockEntry<VibrantVaultBlock>> verticalVaults = new ArrayList<BlockEntry<VibrantVaultBlock>>(colors.length);
            for (VibrantVaultColor color : colors) {
                if (color != VibrantVaultColor.BASE || includeBaseColor) {
                    horizontalVaults.add(color.ordinal(), ModBlocks.vibrantVault(type, color, false));
                }
                verticalVaults.add(color.ordinal(), ModBlocks.vibrantVault(type, color, true));
            }
            result.add(type.ordinal() * 2, horizontalVaults);
            result.add(type.ordinal() * 2 + 1, verticalVaults);
        }
        return result;
    }

    private static List<BlockEntry<VibrantFrogportBlock>> getVibrantFrogports() {
        VibrantVaultColor[] colors = VibrantVaultColor.values();
        ArrayList<BlockEntry<VibrantFrogportBlock>> result = new ArrayList<BlockEntry<VibrantFrogportBlock>>(colors.length - 1);
        for (VibrantVaultColor color : colors) {
            if (color == VibrantVaultColor.BASE) continue;
            result.add(color.ordinal(), ModBlocks.vibrantFrogport(color));
        }
        return result;
    }

    private static List<BlockEntry<VibrantStockLinkBlock>> getVibrantStockLinks() {
        VibrantVaultColor[] colors = VibrantVaultColor.values();
        ArrayList<BlockEntry<VibrantStockLinkBlock>> result = new ArrayList<BlockEntry<VibrantStockLinkBlock>>(colors.length - 1);
        for (VibrantVaultColor color : colors) {
            if (color == VibrantVaultColor.BASE) continue;
            result.add(color.ordinal(), ModBlocks.vibrantStockLink(color));
        }
        return result;
    }

    private static List<BlockEntry<VibrantRedstoneRequesterBlock>> getVibrantRedstoneRequesters() {
        VibrantVaultColor[] colors = VibrantVaultColor.values();
        ArrayList<BlockEntry<VibrantRedstoneRequesterBlock>> result = new ArrayList<BlockEntry<VibrantRedstoneRequesterBlock>>(colors.length - 1);
        for (VibrantVaultColor color : colors) {
            if (color == VibrantVaultColor.BASE) continue;
            result.add(color.ordinal(), ModBlocks.vibrantRedstoneRequester(color));
        }
        return result;
    }

    private static List<BlockEntry<VibrantPackagerBlock>> getVibrantPackagers() {
        VibrantVaultColor[] colors = VibrantVaultColor.values();
        ArrayList<BlockEntry<VibrantPackagerBlock>> result = new ArrayList<BlockEntry<VibrantPackagerBlock>>(colors.length - 1);
        for (VibrantVaultColor color : colors) {
            if (color == VibrantVaultColor.BASE) continue;
            result.add(color.ordinal(), ModBlocks.vibrantPackager(color));
        }
        return result;
    }

    public static void init() {
    }

    static {
        CreateVibrantVaults.REGISTRATE.setCreativeTab(ModCreativeModeTabs.BASE_CREATIVE_TAB);
        VIBRANT_VAULTS = ModBlocks.getVibrantVaults();
        VIBRANT_FROGPORTS = ModBlocks.getVibrantFrogports();
        VIBRANT_STOCK_LINKS = ModBlocks.getVibrantStockLinks();
        VIBRANT_REDSTONE_REQUESTERS = ModBlocks.getVibrantRedstoneRequesters();
        VIBRANT_PACKAGERS = ModBlocks.getVibrantPackagers();
    }

    public static enum VibrantVaultType {
        ITEM_VAULT,
        SHIPPING_CONTAINER,
        BASIC_SHIPPING_CONTAINER;


        public String asId(boolean vertical) {
            String id = Lang.asId((String)this.name());
            return vertical ? "vertical_" + id : id;
        }
    }

    public static enum VibrantVaultColor implements StringRepresentable
    {
        WHITE(DyeColor.WHITE.m_284406_()),
        ORANGE(DyeColor.ORANGE.m_284406_()),
        MAGENTA(DyeColor.MAGENTA.m_284406_()),
        LIGHT_BLUE(DyeColor.LIGHT_BLUE.m_284406_()),
        YELLOW(DyeColor.YELLOW.m_284406_()),
        LIME(DyeColor.LIME.m_284406_()),
        PINK(DyeColor.PINK.m_284406_()),
        GRAY(DyeColor.GRAY.m_284406_()),
        LIGHT_GRAY(DyeColor.LIGHT_GRAY.m_284406_()),
        CYAN(DyeColor.CYAN.m_284406_()),
        PURPLE(DyeColor.PURPLE.m_284406_()),
        BLUE(DyeColor.BLUE.m_284406_()),
        BROWN(DyeColor.BROWN.m_284406_()),
        GREEN(DyeColor.GREEN.m_284406_()),
        RED(DyeColor.RED.m_284406_()),
        BLACK(DyeColor.BLACK.m_284406_()),
        BASE(MapColor.f_283908_);

        public static final StringRepresentable.EnumCodec<VibrantVaultColor> CODEC;
        private static final IntFunction<VibrantVaultColor> BY_ID;
        public final MapColor mapColor;

        private VibrantVaultColor(MapColor mapColor) {
            this.mapColor = mapColor;
        }

        public String asId() {
            return Lang.asId((String)this.name());
        }

        public static VibrantVaultColor byId(int id) {
            return BY_ID.apply(id);
        }

        public static VibrantVaultColor byName(String name) {
            return (VibrantVaultColor)CODEC.m_262792_(name, (Enum)BASE);
        }

        public String m_7912_() {
            return this.asId();
        }

        static {
            CODEC = StringRepresentable.m_216439_(VibrantVaultColor::values);
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])VibrantVaultColor.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

