package net.zlt.create_vibrant_vaults.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Nullable;
import java.util.*;

public final class ItemVaultConnectivityHelper {
    private ItemVaultConnectivityHelper() {
    }

    public static class_2350.class_2351 getItemVaultPreferredAxis(class_2248 placing, class_2680 placedOn) {
        return ModBlockTags.VERTICAL_VAULTS.matches(placedOn) || !isVault(placedOn, placing) ? null : placedOn.method_11654(ItemVaultBlock.HORIZONTAL_AXIS);
    }

    public static boolean isVault(class_2248 block) {
        return AllBlocks.ITEM_VAULT.is(block) || ModBlockTags.VIBRANT_VAULTS.matches(block);
    }

    public static boolean isVault(class_2680 state) {
        return isVault(state.method_26204());
    }

    public static boolean isVault(class_2248 a, class_2248 b) {
        if (AllBlocks.ITEM_VAULT.is(a)) {
            return AllBlocks.ITEM_VAULT.is(b);
        }

        if (ModBlockTags.VIBRANT_VAULTS.matches(a)) {
            return a == b;
        }

        return false;
    }

    public static boolean isVault(class_2680 a, class_2248 b) {
        return isVault(a.method_26204(), b);
    }

    public static boolean isVault(class_2680 a, class_2680 b) {
        return isVault(a.method_26204(), b.method_26204());
    }

    public static boolean isVault(class_2586 a, class_2248 b) {
        return isVault(a.method_11010(), b);
    }

    public static boolean isVault(class_2586 a, class_2586 b) {
        return isVault(a.method_11010(), b.method_11010());
    }

    public static <T extends class_2586 & IMultiBlockEntityContainer> void formItemVaultMulti(T be) {
        SearchCache<T> cache = new SearchCache<>();
        List<T> frontier = new ArrayList<>();
        frontier.add(be);
        formItemVaultMulti(be, be.method_10997(), cache, frontier);
    }

    @Nullable
    @SuppressWarnings("unchecked")
    private static <T extends class_2586 & IMultiBlockEntityContainer> T checked(class_2586 be) {
        return be instanceof IMultiBlockEntityContainer ? (T) be : null;
    }

    @Nullable
    public static <T extends class_2586 & IMultiBlockEntityContainer> T partAt(class_2248 block, class_1922 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        return be != null && isVault(be, block) && !be.method_11015() ? checked(be) : null;
    }

    @Nullable
    public static <T extends class_2586 & IMultiBlockEntityContainer> T partAt(class_2586 blockEntity, class_1922 level, class_2338 pos) {
        return partAt(blockEntity.method_11010().method_26204(), level, pos);
    }

    public static <T extends class_2586 & IMultiBlockEntityContainer> void splitItemVaultMulti(T be) {
        splitItemVaultMultiAndInvalidate(be, null);
    }

    private static <T extends class_2586 & IMultiBlockEntityContainer> void splitItemVaultMultiAndInvalidate(T be, @Nullable SearchCache<T> cache) {
        class_1937 level = be.method_10997();
        if (level == null) {
            return;
        }

        be = be.getControllerBE();
        if (be == null) {
            return;
        }

        int height = be.getHeight();
        int width = be.getWidth();
        if (width == 1 && height == 1) {
            return;
        }

        class_2338 origin = be.method_11016();
        class_2350.class_2351 axis = be.getMainConnectionAxis();

        for (int yOffset = 0; yOffset < height; yOffset++) {
            for (int xOffset = 0; xOffset < width; xOffset++) {
                for (int zOffset = 0; zOffset < width; zOffset++) {
                    class_2338 pos = switch (axis) {
                        case field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };

                    T partAt = partAt(be, level, pos);
                    if (partAt == null) {
                        continue;
                    }

                    if (!partAt.getController().equals(origin)) {
                        continue;
                    }

                    T controllerBE = partAt.getControllerBE();
                    partAt.setExtraData((controllerBE == null ? null : controllerBE.getExtraData()));
                    partAt.removeController(true);

                    if (cache != null) {
                        cache.put(pos, partAt);
                    }
                }
            }
        }
    }

    private static <T extends class_2586 & IMultiBlockEntityContainer> int tryToFormNewItemVaultMultiOfWidth(T be, int width, SearchCache<T> cache, boolean simulate) {
        int amount = 0;
        int height = 0;
        class_1937 level = be.method_10997();
        if (level == null) {
            return 0;
        }

        class_2338 origin = be.method_11016();
        class_2350.class_2351 axis = be.getMainConnectionAxis();

        Search:
        for (int yOffset = 0; yOffset < be.getMaxLength(axis, width); yOffset++) {
            for (int xOffset = 0; xOffset < width; xOffset++) {
                for (int zOffset = 0; zOffset < width; zOffset++) {
                    class_2338 pos = switch (axis) {
                        case field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };
                    Optional<T> part = cache.getOrCache(be, level, pos);
                    if (part.isEmpty()) {
                        break Search;
                    }

                    T controller = part.get();
                    int otherWidth = controller.getWidth();
                    if (otherWidth > width) {
                        break Search;
                    }

                    if (otherWidth == width && controller.getHeight() == be.getMaxLength(axis, width)) {
                        break Search;
                    }

                    class_2350.class_2351 conAxis = controller.getMainConnectionAxis();
                    if (axis != conAxis) {
                        break Search;
                    }

                    class_2338 conPos = controller.method_11016();
                    if (!conPos.equals(origin)) {
                        if (axis == class_2350.class_2351.field_11052) { // Vertical multi
                            if (conPos.method_10263() < origin.method_10263()) {
                                break Search;
                            }
                            if (conPos.method_10260() < origin.method_10260()) {
                                break Search;
                            }
                            if (conPos.method_10263() + otherWidth > origin.method_10263() + width) {
                                break Search;
                            }
                            if (conPos.method_10260() + otherWidth > origin.method_10260() + width) {
                                break Search;
                            }
                        } else { // Horizontal multi
                            if (axis == class_2350.class_2351.field_11051 && conPos.method_10263() < origin.method_10263()) {
                                break Search;
                            }
                            if (conPos.method_10264() < origin.method_10264()) {
                                break Search;
                            }
                            if (axis == class_2350.class_2351.field_11048 && conPos.method_10260() < origin.method_10260()) {
                                break Search;
                            }
                            if (axis == class_2350.class_2351.field_11051 && conPos.method_10263() + otherWidth > origin.method_10263() + width) {
                                break Search;
                            }
                            if (conPos.method_10264() + otherWidth > origin.method_10264() + width) {
                                break Search;
                            }
                            if (axis == class_2350.class_2351.field_11048 && conPos.method_10260() + otherWidth > origin.method_10260() + width) {
                                break Search;
                            }
                        }
                    }
                }
            }
            amount += width * width;
            height++;
        }

        if (simulate) {
            return amount;
        }

        Object extraData = be.getExtraData();

        for (int yOffset = 0; yOffset < height; yOffset++) {
            for (int xOffset = 0; xOffset < width; xOffset++) {
                for (int zOffset = 0; zOffset < width; zOffset++) {
                    class_2338 pos = switch (axis) {
                        case field_11048 -> origin.method_10069(yOffset, xOffset, zOffset);
                        case field_11052 -> origin.method_10069(xOffset, yOffset, zOffset);
                        case field_11051 -> origin.method_10069(xOffset, zOffset, yOffset);
                    };
                    T part = partAt(be, level, pos);
                    if (part == null) {
                        continue;
                    }
                    if (part == be) {
                        continue;
                    }

                    extraData = be.modifyExtraData(extraData);

                    splitItemVaultMultiAndInvalidate(part, cache);
                    part.setController(origin);
                    part.preventConnectivityUpdate();
                    cache.put(pos, be);
                    part.setHeight(height);
                    part.setWidth(width);
                    part.notifyMultiUpdated();
                }
            }
        }
        be.setExtraData(extraData);
        be.notifyMultiUpdated();
        return amount;
    }

    private static <T extends class_2586 & IMultiBlockEntityContainer> int tryToFormNewItemVaultMulti(T be, SearchCache<T> cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!be.isController()) {
            return 0;
        }

        int radius = be.getMaxWidth();
        for (int w = 1; w <= radius; w++) {
            int amount = tryToFormNewItemVaultMultiOfWidth(be, w, cache, true);
            if (amount < bestAmount) {
                continue;
            }

            bestWidth = w;
            bestAmount = amount;
        }

        if (!simulate) {
            int beWidth = be.getWidth();
            if (beWidth == bestWidth && beWidth * beWidth * be.getHeight() == bestAmount) {
                return bestAmount;
            }

            splitItemVaultMultiAndInvalidate(be, cache);
            tryToFormNewItemVaultMultiOfWidth(be, bestWidth, cache, false);

            be.preventConnectivityUpdate();
            be.setWidth(bestWidth);
            be.setHeight(bestAmount / bestWidth / bestWidth);
            be.notifyMultiUpdated();
        }

        return bestAmount;
    }

    private static <T extends class_2586 & IMultiBlockEntityContainer> void formItemVaultMulti(class_2586 blockEntity, class_1922 level, SearchCache<T> cache, List<T> frontier) {
        PriorityQueue<Pair<Integer, T>> creationQueue = new PriorityQueue<>((one, two) -> two.getKey() - one.getKey());
        Set<class_2338> visited = new HashSet<>();
        class_2350.class_2351 mainAxis = frontier.get(0).getMainConnectionAxis();

        int minX = (mainAxis == class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
        int minY = (mainAxis != class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
        int minZ = (mainAxis == class_2350.class_2351.field_11052 ? Integer.MAX_VALUE : Integer.MIN_VALUE);

        for (T be : frontier) {
            class_2338 pos = be.method_11016();
            minX = Math.min(pos.method_10263(), minX);
            minY = Math.min(pos.method_10264(), minY);
            minZ = Math.min(pos.method_10260(), minZ);
        }
        if (mainAxis == class_2350.class_2351.field_11052) {
            minX -= frontier.get(0).getMaxWidth();
        }
        if (mainAxis != class_2350.class_2351.field_11052) {
            minY -= frontier.get(0).getMaxWidth();
        }
        if (mainAxis == class_2350.class_2351.field_11052) {
            minZ -= frontier.get(0).getMaxWidth();
        }

        while (!frontier.isEmpty()) {
            T part = frontier.remove(0);
            class_2338 partPos = part.method_11016();
            if (visited.contains(partPos)) {
                continue;
            }

            visited.add(partPos);

            int amount = tryToFormNewItemVaultMulti(part, cache, true);
            if (amount > 1) {
                creationQueue.add(Pair.of(amount, part));
            }

            for (class_2350.class_2351 axis : Iterate.axes) {
                class_2350 dir = class_2350.method_10156(class_2350.class_2352.field_11060, axis);
                class_2338 next = partPos.method_10093(dir);

                if (next.method_10263() <= minX || next.method_10264() <= minY || next.method_10260() <= minZ) {
                    continue;
                }
                if (visited.contains(next)) {
                    continue;
                }

                T nextBe = partAt(blockEntity, level, next);
                if (nextBe == null) {
                    continue;
                }
                if (nextBe.method_11015()) {
                    continue;
                }

                frontier.add(nextBe);
            }
        }
        visited.clear();

        while (!creationQueue.isEmpty()) {
            Pair<Integer, T> next = creationQueue.poll();
            T toCreate = next.getValue();
            if (visited.contains(toCreate.method_11016())) {
                continue;
            }

            visited.add(toCreate.method_11016());
            tryToFormNewItemVaultMulti(toCreate, cache, false);
        }
    }

    private static class SearchCache<T extends class_2586 & IMultiBlockEntityContainer> {
        Map<class_2338, Optional<T>> controllerMap;

        public SearchCache() {
            controllerMap = new HashMap<>();
        }

        void put(class_2338 pos, T target) {
            controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(class_2338 pos) {
            controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(class_2338 pos) {
            return controllerMap.containsKey(pos);
        }

        Optional<T> getOrCache(class_2586 be, class_1922 level, class_2338 pos) {
            if (hasVisited(pos))
                return controllerMap.get(pos);

            T partAt = partAt(be, level, pos);
            if (partAt == null) {
                putEmpty(pos);
                return Optional.empty();
            }
            T controller = checked(level.method_8321(partAt.getController()));
            if (controller == null) {
                putEmpty(pos);
                return Optional.empty();
            }
            put(pos, controller);
            return Optional.of(controller);
        }
    }
}
