package net.zlt.create_vibrant_vaults.block;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagePort.PackagePortItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.content.logistics.redstoneRequester.RedstoneRequesterBlockItem;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.content.logistics.vault.ItemVaultItem;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.data.BlockStateGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import io.github.fabricators_of_create.porting_lib.models.generators.ConfiguredModel;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import net.createmod.catnip.lang.Lang;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2741;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_7995;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.ct.HorizontalVaultCTBehaviour;
import net.zlt.create_vibrant_vaults.ct.VerticalVaultCTBehaviour;
import net.zlt.create_vibrant_vaults.data.VibrantPackagerBlockStateGenerator;
import net.zlt.create_vibrant_vaults.data.VibrantStockLinkBlockStateGenerator;
import net.zlt.create_vibrant_vaults.item.ModCreativeModeTabs;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;

import static com.simibubi.create.foundation.data.CreateRegistrate.connectedTextures;
import static com.simibubi.create.foundation.data.ModelGen.customItemModel;
import static com.simibubi.create.foundation.data.TagGen.pickaxeOnly;

public final class ModBlocks {
    private ModBlocks() {
    }

    static {
        CreateVibrantVaults.REGISTRATE.setCreativeTab(ModCreativeModeTabs.BASE_CREATIVE_TAB.key());
    }

    /**
     * Same order as {@link class_1767} from white to black.
     */
    public enum VibrantVaultColor implements class_3542 {
        WHITE(class_1767.field_7952.method_7794()),
        ORANGE(class_1767.field_7946.method_7794()),
        MAGENTA(class_1767.field_7958.method_7794()),
        LIGHT_BLUE(class_1767.field_7951.method_7794()),
        YELLOW(class_1767.field_7947.method_7794()),
        LIME(class_1767.field_7961.method_7794()),
        PINK(class_1767.field_7954.method_7794()),
        GRAY(class_1767.field_7944.method_7794()),
        LIGHT_GRAY(class_1767.field_7967.method_7794()),
        CYAN(class_1767.field_7955.method_7794()),
        PURPLE(class_1767.field_7945.method_7794()),
        BLUE(class_1767.field_7966.method_7794()),
        BROWN(class_1767.field_7957.method_7794()),
        GREEN(class_1767.field_7942.method_7794()),
        RED(class_1767.field_7964.method_7794()),
        BLACK(class_1767.field_7963.method_7794()),
        BASE(class_3620.field_16015);

        @SuppressWarnings("deprecation")
        public static final class_3542.class_7292<VibrantVaultColor> CODEC = class_3542.method_28140(VibrantVaultColor::values);
        private static final IntFunction<VibrantVaultColor> BY_ID = class_7995.method_47914(Enum::ordinal, values(), class_7995.class_7996.field_41664);

        public final class_3620 mapColor;

        VibrantVaultColor(class_3620 mapColor) {
            this.mapColor = mapColor;
        }

        public String asId() {
            return Lang.asId(name());
        }

        public static VibrantVaultColor byId(int id) {
            return BY_ID.apply(id);
        }

        public static VibrantVaultColor byName(String name) {
            return CODEC.method_47920(name, BASE);
        }

        @Override
        public String method_15434() {
            return asId();
        }
    }

    public enum VibrantVaultType {
        ITEM_VAULT,
        SHIPPING_CONTAINER,
        BASIC_SHIPPING_CONTAINER;

        public String asId(boolean vertical) {
            String id = Lang.asId(name());
            return vertical ? "vertical_" + id : id;
        }
    }

    public static final List<List<BlockEntry<VibrantVaultBlock>>> VIBRANT_VAULTS = getVibrantVaults();
    public static final List<BlockEntry<VibrantFrogportBlock>> VIBRANT_FROGPORTS = getVibrantFrogports();
    public static final List<BlockEntry<VibrantStockLinkBlock>> VIBRANT_STOCK_LINKS = getVibrantStockLinks();
    public static final List<BlockEntry<VibrantRedstoneRequesterBlock>> VIBRANT_REDSTONE_REQUESTERS = getVibrantRedstoneRequesters();
    public static final List<BlockEntry<VibrantPackagerBlock>> VIBRANT_PACKAGERS = getVibrantPackagers();

    public static BlockEntry<VibrantVaultBlock> getVibrantVault(VibrantVaultType type, VibrantVaultColor color, boolean vertical) {
        return VIBRANT_VAULTS.get(type.ordinal() * 2 + (vertical ? 1 : 0)).get(color.ordinal());
    }

    public static BlockEntry<VibrantFrogportBlock> getVibrantFrogport(VibrantVaultColor color) {
        return VIBRANT_FROGPORTS.get(color.ordinal());
    }

    public static BlockEntry<VibrantStockLinkBlock> getVibrantStockLink(VibrantVaultColor color) {
        return VIBRANT_STOCK_LINKS.get(color.ordinal());
    }

    public static BlockEntry<VibrantRedstoneRequesterBlock> getVibrantRedstoneRequester(VibrantVaultColor color) {
        return VIBRANT_REDSTONE_REQUESTERS.get(color.ordinal());
    }

    public static BlockEntry<VibrantPackagerBlock> getVibrantPackager(VibrantVaultColor color) {
        return VIBRANT_PACKAGERS.get(color.ordinal());
    }

    private static NonNullBiConsumer<DataGenContext<class_2248, VibrantVaultBlock>, RegistrateBlockstateProvider> vibrantVaultBlockState(String blockName, String typeId, String colorId, boolean vertical) {
        return vertical ?
            (c, p) -> p.simpleBlock(c.get(), p.models()
                .withExistingParent(blockName, CreateVibrantVaults.asResource("block/template_vertical_item_vault"))
                .texture("top", p.modLoc("block/" + typeId + "/" + colorId + "/vault_top_small"))
                .texture("side", p.modLoc("block/" + typeId + "/" + colorId + "/vault_side_small"))
            ) :
            (c, p) -> p.getVariantBuilder(c.get())
            .forAllStates(s -> ConfiguredModel.builder()
                .modelFile(p.models()
                    .getBuilder(blockName).parent(new ModelFile.UncheckedModelFile(Create.asResource("block/item_vault")))
                    .texture("0", p.modLoc("block/" + typeId + "/" + colorId + "/vault_bottom_small"))
                    .texture("1", p.modLoc("block/" + typeId + "/" + colorId + "/vault_front_small"))
                    .texture("2", p.modLoc("block/" + typeId + "/" + colorId + "/vault_side_small"))
                    .texture("3", p.modLoc("block/" + typeId + "/" + colorId + "/vault_top_small"))
                    .texture("particle", p.modLoc("block/" + typeId + "/" + colorId + "/vault_top_small"))
                )
                .rotationY(s.method_11654(ItemVaultBlock.HORIZONTAL_AXIS) == class_2350.class_2351.field_11048 ? 90 : 0)
                .build()
            );
    }

    private static BlockEntry<VibrantVaultBlock> vibrantVault(VibrantVaultType type, VibrantVaultColor color, boolean vertical) {
        String typeId = type.asId(vertical);
        String colorId = color.asId();
        String blockName = color == VibrantVaultColor.BASE ? typeId : colorId + "_" + typeId;
        return CreateVibrantVaults.REGISTRATE.block(blockName, properties -> vertical ? new VerticalVaultBlock(type, color, properties) : new HorizontalVaultBlock(type, color, properties))
            .initialProperties(SharedProperties::softMetal)
            .properties(p -> p
                .method_31710(color.mapColor)
                .method_9626(class_2498.field_22150)
                .method_36558(1200)
            )
            .transform(pickaxeOnly())
            .blockstate(vibrantVaultBlockState(blockName, typeId, colorId, vertical))
            .onRegister(connectedTextures(() -> vertical ? new VerticalVaultCTBehaviour(type, color) : new HorizontalVaultCTBehaviour(type, color)))
            .item(ItemVaultItem::new)
            .build()
            .register();
    }

    private static BlockEntry<VibrantFrogportBlock> vibrantFrogport(VibrantVaultColor color) {
        return CreateVibrantVaults.REGISTRATE.block(color.asId() + "_package_frogport", properties -> new VibrantFrogportBlock(color, properties))
            .initialProperties(SharedProperties::softMetal)
            .properties(p -> p
                .method_22488()
                .method_31710(color.mapColor)
                .method_9626(class_2498.field_22150)
            )
            .transform(pickaxeOnly())
            .addLayer(() -> class_1921::method_23579)
            .blockstate((c, p) -> p.simpleBlock(c.getEntry(), new ModelFile.UncheckedModelFile(p.modLoc("block/" + c.getName() + "/block"))))
            .item(PackagePortItem::new)
            .model(AssetLookup::customItemModel)
            .build()
            .register();
    }

    private static BlockEntry<VibrantStockLinkBlock> vibrantStockLink(VibrantVaultColor color) {
        return CreateVibrantVaults.REGISTRATE.block(color.asId() + "_stock_link", properties -> new VibrantStockLinkBlock(color, properties))
            .initialProperties(SharedProperties::softMetal)
            .properties(p -> p
                .method_31710(color.mapColor)
                .method_9626(class_2498.field_22150)
            )
            .transform(pickaxeOnly())
            .blockstate(new VibrantStockLinkBlockStateGenerator()::generate)
            .item(LogisticallyLinkedBlockItem::new)
            .transform(customItemModel("_", "block_vertical"))
            .register();
    }

    private static BlockEntry<VibrantRedstoneRequesterBlock> vibrantRedstoneRequester(VibrantVaultColor color) {
        return CreateVibrantVaults.REGISTRATE.block(color.asId() + "_redstone_requester", properties -> new VibrantRedstoneRequesterBlock(color, properties))
            .initialProperties(SharedProperties::stone)
            .properties(p -> p
                .method_9626(class_2498.field_22150)
                .method_22488()
            )
            .transform(pickaxeOnly())
            .blockstate((c, p) -> BlockStateGen.horizontalAxisBlock(c, p, state -> state.method_11654(class_2741.field_12484) ? new ModelFile.UncheckedModelFile(p.modLoc("block/" + c.getName() + "/block_powered")) : new ModelFile.UncheckedModelFile(p.modLoc("block/" + c.getName() + "/block"))))
            .item(RedstoneRequesterBlockItem::new)
            .transform(customItemModel("_", "block"))
            .register();
    }

    private static BlockEntry<VibrantPackagerBlock> vibrantPackager(VibrantVaultColor color) {
        return CreateVibrantVaults.REGISTRATE.block(color.asId() + "_packager", properties -> new VibrantPackagerBlock(color, properties))
            .initialProperties(SharedProperties::softMetal)
            .properties(p -> p
                .method_22488()
                .method_26236(($1, $2, $3) -> false)
                .method_31710(color.mapColor)
                .method_9626(class_2498.field_22150)
            )
            .transform(pickaxeOnly())
            .addLayer(() -> class_1921::method_23579)
            .blockstate(new VibrantPackagerBlockStateGenerator()::generate)
            .item()
            .model(AssetLookup::customItemModel)
            .build()
            .register();
    }

    private static List<List<BlockEntry<VibrantVaultBlock>>> getVibrantVaults() {
        VibrantVaultColor[] colors = VibrantVaultColor.values();
        VibrantVaultType[] types = VibrantVaultType.values();
        List<List<BlockEntry<VibrantVaultBlock>>> result = new ArrayList<>(types.length * 2);
        for (VibrantVaultType type : types) {
            boolean includeBaseColor = type != VibrantVaultType.ITEM_VAULT;
            List<BlockEntry<VibrantVaultBlock>> horizontalVaults = new ArrayList<>(includeBaseColor ? colors.length : colors.length - 1);
            List<BlockEntry<VibrantVaultBlock>> verticalVaults = new ArrayList<>(colors.length);
            for (VibrantVaultColor color : colors) {
                if (color != VibrantVaultColor.BASE || includeBaseColor) {
                    horizontalVaults.add(color.ordinal(), vibrantVault(type, color, false));
                }
                verticalVaults.add(color.ordinal(), vibrantVault(type, color, true));
            }
            result.add(type.ordinal() * 2, horizontalVaults);
            result.add(type.ordinal() * 2 + 1, verticalVaults);
        }
        return result;
    }

    private static List<BlockEntry<VibrantFrogportBlock>> getVibrantFrogports() {
        VibrantVaultColor[] colors = VibrantVaultColor.values();
        List<BlockEntry<VibrantFrogportBlock>> result = new ArrayList<>(colors.length - 1);
        for (VibrantVaultColor color : colors) {
            if (color != VibrantVaultColor.BASE) {
                result.add(color.ordinal(), vibrantFrogport(color));
            }
        }
        return result;
    }

    private static List<BlockEntry<VibrantStockLinkBlock>> getVibrantStockLinks() {
        VibrantVaultColor[] colors = VibrantVaultColor.values();
        List<BlockEntry<VibrantStockLinkBlock>> result = new ArrayList<>(colors.length - 1);
        for (VibrantVaultColor color : colors) {
            if (color != VibrantVaultColor.BASE) {
                result.add(color.ordinal(), vibrantStockLink(color));
            }
        }
        return result;
    }

    private static List<BlockEntry<VibrantRedstoneRequesterBlock>> getVibrantRedstoneRequesters() {
        VibrantVaultColor[] colors = VibrantVaultColor.values();
        List<BlockEntry<VibrantRedstoneRequesterBlock>> result = new ArrayList<>(colors.length - 1);
        for (VibrantVaultColor color : colors) {
            if (color != VibrantVaultColor.BASE) {
                result.add(color.ordinal(), vibrantRedstoneRequester(color));
            }
        }
        return result;
    }

    private static List<BlockEntry<VibrantPackagerBlock>> getVibrantPackagers() {
        VibrantVaultColor[] colors = VibrantVaultColor.values();
        List<BlockEntry<VibrantPackagerBlock>> result = new ArrayList<>(colors.length - 1);
        for (VibrantVaultColor color : colors) {
            if (color != VibrantVaultColor.BASE) {
                result.add(color.ordinal(), vibrantPackager(color));
            }
        }
        return result;
    }

    public static void init() {
    }
}
