package net.zlt.create_vibrant_vaults.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import net.minecraft.class_1269;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.zlt.create_vibrant_vaults.mixin.accessor.IWrenchableAccessor;

public class VerticalVaultBlock extends VibrantVaultBlock {
    public VerticalVaultBlock(ModBlocks.VibrantVaultType type, ModBlocks.VibrantVaultColor color, class_2251 properties) {
        super(type, color, properties);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        pBuilder.method_11667(LARGE);
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        return method_9564();
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (context.method_8038().method_10166().method_10179()) {
            class_2586 be = context.method_8045().method_8321(context.method_8037());
            if (be instanceof ItemVaultBlockEntity vault) {
                ItemVaultConnectivityHelper.splitItemVaultMulti(vault);
                vault.removeController(true);
            }
            state = state.method_11657(LARGE, false);
        }

        class_1937 world = context.method_8045();
        class_2680 rotated = getRotatedBlockState(state, context.method_8038());
        if (!rotated.method_26184(world, context.method_8037())) {
            return class_1269.field_5811;
        }

        KineticBlockEntity.switchToBlockState(world, context.method_8037(), updateAfterWrenched(rotated, context));

        if (context.method_8045().method_8321(context.method_8037()) instanceof GeneratingKineticBlockEntity be) {
            be.reActivateSource = true;
        }

        if (world.method_8320(context.method_8037()) != state) {
            IWrenchableAccessor.createVibrantVaults$invokePlayRotateSound(world, context.method_8037());
        }

        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rot) {
        return state;
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        if (targetedFace.method_10166().method_10179()) {
            return getHorizontal().method_9564().method_11657(HORIZONTAL_AXIS, targetedFace.method_10166() == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048);
        }

        return originalState;
    }

    public class_2248 getHorizontal() {
        return type == ModBlocks.VibrantVaultType.ITEM_VAULT && color == ModBlocks.VibrantVaultColor.BASE ? AllBlocks.ITEM_VAULT.get() : ModBlocks.getVibrantVault(type, color, false).get();
    }
}
