package net.zlt.create_vibrant_vaults.ct;

import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.content.logistics.vault.ItemVaultCTBehaviour;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import net.createmod.catnip.data.Couple;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.zlt.create_vibrant_vaults.block.ModBlocks;
import org.jetbrains.annotations.Nullable;

public class HorizontalVaultCTBehaviour extends ItemVaultCTBehaviour {
    protected final ModBlocks.VibrantVaultType type;
    protected final ModBlocks.VibrantVaultColor color;

    public HorizontalVaultCTBehaviour(ModBlocks.VibrantVaultType type, ModBlocks.VibrantVaultColor color) {
        super();
        this.type = type;
        this.color = color;
    }

    @Override
    public CTSpriteShiftEntry getShift(class_2680 state, class_2350 direction, @Nullable class_1058 sprite) {
        class_2350.class_2351 vaultBlockAxis = ItemVaultBlock.getVaultBlockAxis(state);
        if (vaultBlockAxis == null) {
            return null;
        }

        ModSpriteShifts.VibrantVaultSpriteShifts spriteShifts = ModSpriteShifts.ofVibrantVault(type, color, false);
        Couple<CTSpriteShiftEntry> entries = direction.method_10166() == vaultBlockAxis ? spriteShifts.front : direction == class_2350.field_11036 ? spriteShifts.top : direction == class_2350.field_11033 ? spriteShifts.bottom : spriteShifts.side;
        return entries.get(!ItemVaultBlock.isLarge(state));
    }
}
