package net.zlt.create_vibrant_vaults.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricCodecDataProvider;
import net.fabricmc.fabric.api.recipe.v1.ingredient.DefaultCustomIngredients;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_7784;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.ModBlocks;
import net.zlt.create_vibrant_vaults.item.ModItemTags;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

// TODO: move to normal recipe provider
public class CreateVibrantVaultsCreateSplashingRecipeProvider extends FabricCodecDataProvider<CreateVibrantVaultsCreateSplashingRecipeProvider.Entry> {
    protected CreateVibrantVaultsCreateSplashingRecipeProvider(FabricDataOutput dataOutput) {
        super(dataOutput, class_7784.class_7490.field_39367, "recipes", Entry.CODEC);
    }

    @Override
    protected void configure(BiConsumer<class_2960, Entry> provider) {
        for (ModBlocks.VibrantVaultType type : ModBlocks.VibrantVaultType.values()) {
            DefaultCustomIngredients.difference(class_1856.method_8106(ModItemTags.ofType(type).tag), class_1856.method_8106(ModItemTags.BASE_VAULTS.tag));
            if (type == ModBlocks.VibrantVaultType.ITEM_VAULT) {
                provider.accept(CreateVibrantVaults.asResource(ModBlocks.VibrantVaultType.ITEM_VAULT.asId(false) + "_color_washing"), new Entry(ModItemTags.COLORED_HORIZONTAL_ITEM_VAULTS.tag.comp_327(), AllBlocks.ITEM_VAULT.getId()));
            } else {
                provider.accept(CreateVibrantVaults.asResource(type.asId(false) + "_color_washing"), new Entry(ModItemTags.ofColored(type, false).tag.comp_327(), ModBlocks.getVibrantVault(type, ModBlocks.VibrantVaultColor.BASE, false).getId()));
            }
            provider.accept(CreateVibrantVaults.asResource(type.asId(true) + "_color_washing"), new Entry(ModItemTags.ofColored(type, true).tag.comp_327(), ModBlocks.getVibrantVault(type, ModBlocks.VibrantVaultColor.BASE, true).getId()));
        }
    }

    @Override
    public String method_10321() {
        return "Create: Vibrant Vaults Create Splashing Recipes";
    }

    public record Entry(class_2960 type, List<Map<String, class_2960>> ingredients, List<Map<String, class_2960>> results) {
        public Entry(class_2960 ingredientTag, class_2960 resultItem) {
            this(Create.asResource("splashing"), List.of(Map.of("tag", ingredientTag)), List.of(Map.of("item", resultItem)));
        }

        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("type").forGetter(Entry::type),
            Codec.list(Codec.unboundedMap(Codec.STRING, class_2960.field_25139)).fieldOf("ingredients").forGetter(Entry::ingredients),
            Codec.list(Codec.unboundedMap(Codec.STRING, class_2960.field_25139)).fieldOf("results").forGetter(Entry::results)
        ).apply(instance, Entry::new));
    }
}
