package net.zlt.create_vibrant_vaults.data;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.tterrag.registrate.util.entry.BlockEntry;
import io.github.fabricators_of_create.porting_lib.tags.Tags;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.recipe.v1.ingredient.DefaultCustomIngredients;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2456;
import net.minecraft.class_3981;
import net.minecraft.class_7800;
import net.minecraft.data.recipes.*;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.*;
import net.zlt.create_vibrant_vaults.item.CreateVibrantVaultsItemPredicateBuilder;
import net.zlt.create_vibrant_vaults.item.ModItemTags;
import net.zlt.create_vibrant_vaults.item.crafting.ModRecipeSerializers;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public class CreateVibrantVaultsRecipeProvider extends FabricRecipeProvider {
    public CreateVibrantVaultsRecipeProvider(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void method_10419(Consumer<class_2444> exporter) {
        class_2456.method_10476(ModRecipeSerializers.VAULT_COLORING).method_10475(exporter, "vault_coloring");
        class_2456.method_10476(ModRecipeSerializers.VAULT_ROTATING).method_10475(exporter, "vault_rotating");

        class_2450.method_10448(class_7800.field_40642, AllBlocks.FACTORY_GAUGE, 2)
            .method_10446(ModItemTags.VIBRANT_STOCK_LINKS.tag)
            .method_10454(AllItems.PRECISION_MECHANISM)
            .method_10442("has_stock_link", method_10420(ModItemTags.VIBRANT_STOCK_LINKS.tag))
            .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(AllBlocks.FACTORY_GAUGE) + "_from_vibrant_stock_links");
        class_2447.method_10437(class_7800.field_40642, AllBlocks.STOCK_TICKER)
            .method_10433('A', ModItemTags.VIBRANT_STOCK_LINKS.tag)
            .method_10433('B', Tags.Items.INGOTS_GOLD)
            .method_10433('C', Tags.Items.GLASS)
            .method_10439("C")
            .method_10439("A")
            .method_10439("B")
            .method_10429("has_item", method_10426(AllItems.CARDBOARD))
            .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(AllBlocks.STOCK_TICKER) + "_from_vibrant_stock_links");
        class_2450.method_10447(class_7800.field_40642, AllBlocks.REPACKAGER)
            .method_10446(ModItemTags.VIBRANT_PACKAGERS.tag)
            .method_10442("has_packager", method_10420(ModItemTags.VIBRANT_PACKAGERS.tag))
            .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(AllBlocks.REPACKAGER) + "_from_vibrant_packagers");

        for (ModBlocks.VibrantVaultColor color : ModBlocks.VibrantVaultColor.values()) {
            class_2248 frogport = color == ModBlocks.VibrantVaultColor.BASE ? AllBlocks.PACKAGE_FROGPORT.get() : ModBlocks.getVibrantFrogport(color).get();
            class_2248 stockLink = color == ModBlocks.VibrantVaultColor.BASE ? AllBlocks.STOCK_LINK.get() : ModBlocks.getVibrantStockLink(color).get();

            class_1856 vibrantColorVaults = color == ModBlocks.VibrantVaultColor.BASE ? DefaultCustomIngredients.difference(class_1856.method_8106(ModItemTags.ofColor(color).tag), class_1856.method_8091(AllBlocks.ITEM_VAULT)) : class_1856.method_8106(ModItemTags.ofColor(color).tag);

            class_2447.method_10437(class_7800.field_40642, frogport)
                .method_10428('A', vibrantColorVaults)
                .method_10433('B', Tags.Items.SLIMEBALLS)
                .method_10434('C', AllItems.ANDESITE_ALLOY)
                .method_10439("B")
                .method_10439("A")
                .method_10439("C")
                .method_10429("has_item", method_10426(AllItems.CARDBOARD))
                .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(frogport));

            class_2447.method_10437(class_7800.field_40642, stockLink)
                .method_10428('B', vibrantColorVaults)
                .method_10434('C', AllItems.TRANSMITTER)
                .method_10439("C")
                .method_10439("B")
                .method_10429("has_item", method_10426(AllItems.CARDBOARD))
                .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(stockLink));

            if (color == ModBlocks.VibrantVaultColor.BASE) {
                continue;
            }

            class_2450.method_10447(class_7800.field_40642, frogport)
                .method_10446(ModItemTags.FROGPORTS.tag)
                .method_10454(class_1769.method_7803(class_1767.method_7791(color.ordinal())))
                .method_10442("has_frogport", method_10420(ModItemTags.FROGPORTS.tag))
                .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(frogport) + "_from_dyeing");

            class_2450.method_10447(class_7800.field_40642, stockLink)
                .method_10454(stockLink)
                .method_10442("has_item", method_10426(stockLink))
                .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(stockLink) + "_clear");
            class_2450.method_10447(class_7800.field_40642, stockLink)
                .method_10446(ModItemTags.STOCK_LINKS.tag)
                .method_10454(class_1769.method_7803(class_1767.method_7791(color.ordinal())))
                .method_10442("has_stock_link", method_10420(ModItemTags.STOCK_LINKS.tag))
                .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(stockLink) + "_from_dyeing");

            BlockEntry<VibrantRedstoneRequesterBlock> redstoneRequester = ModBlocks.getVibrantRedstoneRequester(color);
            class_2447.method_10437(class_7800.field_40642, redstoneRequester)
                .method_10434('A', stockLink)
                .method_10433('B', Tags.Items.INGOTS_IRON)
                .method_10433('C', Tags.Items.DUSTS_REDSTONE)
                .method_10439("C")
                .method_10439("A")
                .method_10439("B")
                .method_10429("has_item", method_10426(AllItems.CARDBOARD))
                .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(redstoneRequester));
            class_2450.method_10447(class_7800.field_40642, redstoneRequester)
                .method_10454(redstoneRequester)
                .method_10442("has_item", method_10426(redstoneRequester))
                .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(redstoneRequester) + "_clear");
            class_2450.method_10447(class_7800.field_40642, redstoneRequester)
                .method_10446(ModItemTags.REDSTONE_REQUESTERS.tag)
                .method_10454(class_1769.method_7803(class_1767.method_7791(color.ordinal())))
                .method_10442("has_redstone_requester", method_10420(ModItemTags.REDSTONE_REQUESTERS.tag))
                .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(redstoneRequester) + "_from_dyeing");

            BlockEntry<VibrantPackagerBlock> packager = ModBlocks.getVibrantPackager(color);
            class_2450.method_10447(class_7800.field_40642, packager)
                .method_10446(ModItemTags.PACKAGERS.tag)
                .method_10454(class_1769.method_7803(class_1767.method_7791(color.ordinal())))
                .method_10442("has_packager", method_10420(ModItemTags.PACKAGERS.tag))
                .method_36443(exporter, CreateVibrantVaults.ID + ":crafting/" + method_33716(packager));
        }

        for (List<BlockEntry<VibrantVaultBlock>> vaults : ModBlocks.VIBRANT_VAULTS) {
            for (BlockEntry<VibrantVaultBlock> vault : vaults) {
                VibrantVaultBlock block = vault.get();
                String colorId = block.color.asId();
                boolean vertical = block instanceof VerticalVaultBlock;
                class_1856 colorAndOrientationIngredient = DefaultCustomIngredients.difference(DefaultCustomIngredients.all(class_1856.method_8106(ModItemTags.ofColor(block.color).tag), class_1856.method_8106(ModItemTags.ofOrientation(vertical).tag)), class_1856.method_8106(ModItemTags.ofType(block.type).tag));
                class_3981.method_17968(colorAndOrientationIngredient, class_7800.field_40642, vault)
                    .method_17970("has_" + colorId + "_" + (vertical ? "vertical" : "horizontal") + "_vault", method_10423(CreateVibrantVaultsItemPredicateBuilder.create().ingredient(colorAndOrientationIngredient).method_8976()))
                    .method_36443(exporter, CreateVibrantVaults.ID + ":" + method_33716(vault) + "_from_" + colorId + "_"  + (vertical ? "vertical" : "horizontal") + "_vaults");
            }
        }

        class_1856 colorAndOrientationIngredient = DefaultCustomIngredients.difference(DefaultCustomIngredients.all(class_1856.method_8106(ModItemTags.BASE_VAULTS.tag), class_1856.method_8106(ModItemTags.HORIZONTAL_VAULTS.tag)), class_1856.method_8106(ModItemTags.ITEM_VAULTS.tag));
        String baseColorId = ModBlocks.VibrantVaultColor.BASE.asId();
        class_3981.method_17968(colorAndOrientationIngredient, class_7800.field_40642, AllBlocks.ITEM_VAULT)
            .method_17970("has_" + baseColorId + "_horizontal_vault", method_10423(CreateVibrantVaultsItemPredicateBuilder.create().ingredient(colorAndOrientationIngredient).method_8976()))
            .method_36443(exporter, CreateVibrantVaults.ID + ":" + method_33716(AllBlocks.ITEM_VAULT) + "_from_" + baseColorId + "_horizontal_vaults");

        CreateProcessingRecipeProvider.of(AllRecipeTypes.SPLASHING, exporter)
            .add("frogport_color_washing", b -> b
                .require(ModItemTags.VIBRANT_FROGPORTS.tag)
                .output(AllBlocks.PACKAGE_FROGPORT))
            .add("stock_link_color_washing", b -> b
                .require(ModItemTags.VIBRANT_STOCK_LINKS.tag)
                .output(AllBlocks.STOCK_LINK))
            .add("redstone_requester_color_washing", b -> b
                .require(ModItemTags.VIBRANT_REDSTONE_REQUESTERS.tag)
                .output(AllBlocks.REDSTONE_REQUESTER))
            .add("packager_color_washing", b -> b
                .require(ModItemTags.VIBRANT_PACKAGERS.tag)
                .output(AllBlocks.PACKAGER));
    }

    public abstract static class CreateProcessingRecipeProvider {
        public static CreateProcessingRecipeProvider of(IRecipeTypeInfo recipeType, Consumer<class_2444> exporter) {
            return new CreateProcessingRecipeProvider() {
                @Override
                public IRecipeTypeInfo getRecipeType() {
                    return recipeType;
                }

                @Override
                public void register(BaseRecipeProvider.GeneratedRecipe recipe) {
                    recipe.register(exporter);
                }
            };
        }

        public <T extends ProcessingRecipe<?>> BaseRecipeProvider.GeneratedRecipe recipe(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
            return output -> transform.apply(new ProcessingRecipeBuilder<>(getRecipeType().<ProcessingRecipeSerializer<T>>getSerializer().getFactory(), CreateVibrantVaults.asResource(name))).build(output);
        }

        public <T extends ProcessingRecipe<?>> CreateProcessingRecipeProvider add(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
            register(recipe(name, transform));
            return this;
        }

        public <T> CreateProcessingRecipeProvider forEach(T[] values, BiFunction<CreateProcessingRecipeProvider, T, List<BaseRecipeProvider.GeneratedRecipe>> recipes) {
            for (T value : values) {
                for (BaseRecipeProvider.GeneratedRecipe recipe : recipes.apply(this, value)) {
                    register(recipe);
                }
            }
            return this;
        }

        public abstract IRecipeTypeInfo getRecipeType();

        public abstract void register(BaseRecipeProvider.GeneratedRecipe recipe);
    }
}
