package net.zlt.create_vibrant_vaults.data;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.*;
import net.zlt.create_vibrant_vaults.item.ModItemTags;

import java.util.List;

public class CreateVibrantVaultsTagProvider {
    public static void addGenerators() {
        CreateVibrantVaults.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, CreateVibrantVaultsTagProvider::genBlockTags);
        CreateVibrantVaults.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, CreateVibrantVaultsTagProvider::genItemTags);
    }

    @SuppressWarnings("deprecation")
    private static void genBlockTags(RegistrateTagsProvider<class_2248> provIn) {
        TagGen.CreateTagsProvider<class_2248> prov = new TagGen.CreateTagsProvider<>(provIn, class_2248::method_40142);

        TagGen.CreateTagAppender<class_2248> vibrantVaultsTag = prov.tag(ModBlockTags.VIBRANT_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> horizontalVaultsTag = prov.tag(ModBlockTags.HORIZONTAL_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> verticalVaultsTag = prov.tag(ModBlockTags.VERTICAL_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> itemVaultsTag = prov.tag(ModBlockTags.ITEM_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> shippingContainersTag = prov.tag(ModBlockTags.SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_2248> basicShippingContainersTag = prov.tag(ModBlockTags.BASIC_SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_2248> whiteVaultsTag = prov.tag(ModBlockTags.WHITE_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> orangeVaultsTag = prov.tag(ModBlockTags.ORANGE_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> magentaVaultsTag = prov.tag(ModBlockTags.MAGENTA_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> lightBlueVaultsTag = prov.tag(ModBlockTags.LIGHT_BLUE_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> yellowVaultsTag = prov.tag(ModBlockTags.YELLOW_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> limeVaultsTag = prov.tag(ModBlockTags.LIME_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> pinkVaultsTag = prov.tag(ModBlockTags.PINK_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> grayVaultsTag = prov.tag(ModBlockTags.GRAY_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> lightGrayVaultsTag = prov.tag(ModBlockTags.LIGHT_GRAY_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> cyanVaultsTag = prov.tag(ModBlockTags.CYAN_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> purpleVaultsTag = prov.tag(ModBlockTags.PURPLE_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> blueVaultsTag = prov.tag(ModBlockTags.BLUE_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> brownVaultsTag = prov.tag(ModBlockTags.BROWN_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> greenVaultsTag = prov.tag(ModBlockTags.GREEN_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> redVaultsTag = prov.tag(ModBlockTags.RED_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> blackVaultsTag = prov.tag(ModBlockTags.BLACK_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> baseVaultsTag = prov.tag(ModBlockTags.BASE_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> coloredHorizontalItemVaultsTag = prov.tag(ModBlockTags.COLORED_HORIZONTAL_ITEM_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> coloredVerticalItemVaultsTag = prov.tag(ModBlockTags.COLORED_VERTICAL_ITEM_VAULTS.tag);
        TagGen.CreateTagAppender<class_2248> coloredHorizontalShippingContainersTag = prov.tag(ModBlockTags.COLORED_HORIZONTAL_SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_2248> coloredVerticalShippingContainersTag = prov.tag(ModBlockTags.COLORED_VERTICAL_SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_2248> coloredHorizontalBasicShippingContainersTag = prov.tag(ModBlockTags.COLORED_HORIZONTAL_BASIC_SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_2248> coloredVerticalBasicShippingContainersTag = prov.tag(ModBlockTags.COLORED_VERTICAL_BASIC_SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_2248> frogportsTag = prov.tag(ModBlockTags.FROGPORTS.tag);
        TagGen.CreateTagAppender<class_2248> vibrantFrogportsTag = prov.tag(ModBlockTags.VIBRANT_FROGPORTS.tag);
        TagGen.CreateTagAppender<class_2248> stockLinksTag = prov.tag(ModBlockTags.STOCK_LINKS.tag);
        TagGen.CreateTagAppender<class_2248> vibrantStockLinksTag = prov.tag(ModBlockTags.VIBRANT_STOCK_LINKS.tag);
        TagGen.CreateTagAppender<class_2248> redstoneRequestersTag = prov.tag(ModBlockTags.REDSTONE_REQUESTERS.tag);
        TagGen.CreateTagAppender<class_2248> vibrantRedstoneRequestersTag = prov.tag(ModBlockTags.VIBRANT_REDSTONE_REQUESTERS.tag);
        TagGen.CreateTagAppender<class_2248> packagersTag = prov.tag(ModBlockTags.PACKAGERS.tag);
        TagGen.CreateTagAppender<class_2248> vibrantPackagersTag = prov.tag(ModBlockTags.VIBRANT_PACKAGERS.tag);

        horizontalVaultsTag.add(AllBlocks.ITEM_VAULT.get());
        itemVaultsTag.add(AllBlocks.ITEM_VAULT.get());
        baseVaultsTag.add(AllBlocks.ITEM_VAULT.get());

        for (List<BlockEntry<VibrantVaultBlock>> vaults : ModBlocks.VIBRANT_VAULTS) {
            for (BlockEntry<VibrantVaultBlock> vault : vaults) {
                VibrantVaultBlock block = vault.get();
                vibrantVaultsTag.add(block);
                boolean vertical = block instanceof VerticalVaultBlock;
                if (vertical) {
                    verticalVaultsTag.add(block);
                } else {
                    horizontalVaultsTag.add(block);
                }
                if (block.type == ModBlocks.VibrantVaultType.ITEM_VAULT) {
                    itemVaultsTag.add(block);

                    if (block.color != ModBlocks.VibrantVaultColor.BASE) {
                        if (vertical) {
                            coloredVerticalItemVaultsTag.add(block);
                        } else {
                            coloredHorizontalItemVaultsTag.add(block);
                        }
                    }
                } else if (block.type == ModBlocks.VibrantVaultType.SHIPPING_CONTAINER) {
                    shippingContainersTag.add(block);

                    if (block.color != ModBlocks.VibrantVaultColor.BASE) {
                        if (vertical) {
                            coloredVerticalShippingContainersTag.add(block);
                        } else {
                            coloredHorizontalShippingContainersTag.add(block);
                        }
                    }
                } else if (block.type == ModBlocks.VibrantVaultType.BASIC_SHIPPING_CONTAINER) {
                    basicShippingContainersTag.add(block);

                    if (block.color != ModBlocks.VibrantVaultColor.BASE) {
                        if (vertical) {
                            coloredVerticalBasicShippingContainersTag.add(block);
                        } else {
                            coloredHorizontalBasicShippingContainersTag.add(block);
                        }
                    }
                }
                if (block.color == ModBlocks.VibrantVaultColor.WHITE) {
                    whiteVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.ORANGE) {
                    orangeVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.MAGENTA) {
                    magentaVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.LIGHT_BLUE) {
                    lightBlueVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.YELLOW) {
                    yellowVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.LIME) {
                    limeVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.PINK) {
                    pinkVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.GRAY) {
                    grayVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.LIGHT_GRAY) {
                    lightGrayVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.CYAN) {
                    cyanVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.PURPLE) {
                    purpleVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.BLUE) {
                    blueVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.BROWN) {
                    brownVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.GREEN) {
                    greenVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.RED) {
                    redVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.BLACK) {
                    blackVaultsTag.add(block);
                } else if (block.color == ModBlocks.VibrantVaultColor.BASE) {
                    baseVaultsTag.add(block);
                }
            }
        }

        frogportsTag.method_26792(ModBlockTags.VIBRANT_FROGPORTS.tag);
        frogportsTag.add(AllBlocks.PACKAGE_FROGPORT.get());

        for (BlockEntry<VibrantFrogportBlock> frogport : ModBlocks.VIBRANT_FROGPORTS) {
            vibrantFrogportsTag.add(frogport.get());
        }

        stockLinksTag.method_26792(ModBlockTags.VIBRANT_STOCK_LINKS.tag);
        stockLinksTag.add(AllBlocks.STOCK_LINK.get());

        for (BlockEntry<VibrantStockLinkBlock> stockLink : ModBlocks.VIBRANT_STOCK_LINKS) {
            vibrantStockLinksTag.add(stockLink.get());
        }

        redstoneRequestersTag.method_26792(ModBlockTags.VIBRANT_REDSTONE_REQUESTERS.tag);
        redstoneRequestersTag.add(AllBlocks.REDSTONE_REQUESTER.get());

        for (BlockEntry<VibrantRedstoneRequesterBlock> redstoneRequester : ModBlocks.VIBRANT_REDSTONE_REQUESTERS) {
            vibrantRedstoneRequestersTag.add(redstoneRequester.get());
        }

        packagersTag.method_26792(ModBlockTags.VIBRANT_PACKAGERS.tag);
        packagersTag.add(AllBlocks.PACKAGER.get());

        for (BlockEntry<VibrantPackagerBlock> packager : ModBlocks.VIBRANT_PACKAGERS) {
            vibrantPackagersTag.add(packager.get());
        }

        for (ModBlockTags tag : ModBlockTags.values()) {
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    @SuppressWarnings("deprecation")
    private static void genItemTags(RegistrateTagsProvider<class_1792> provIn) {
        TagGen.CreateTagsProvider<class_1792> prov = new TagGen.CreateTagsProvider<>(provIn, class_1792::method_40131);

        TagGen.CreateTagAppender<class_1792> vibrantVaultsTag = prov.tag(ModItemTags.VIBRANT_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> horizontalVaultsTag = prov.tag(ModItemTags.HORIZONTAL_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> verticalVaultsTag = prov.tag(ModItemTags.VERTICAL_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> itemVaultsTag = prov.tag(ModItemTags.ITEM_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> shippingContainersTag = prov.tag(ModItemTags.SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_1792> basicShippingContainersTag = prov.tag(ModItemTags.BASIC_SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_1792> whiteVaultsTag = prov.tag(ModItemTags.WHITE_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> orangeVaultsTag = prov.tag(ModItemTags.ORANGE_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> magentaVaultsTag = prov.tag(ModItemTags.MAGENTA_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> lightBlueVaultsTag = prov.tag(ModItemTags.LIGHT_BLUE_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> yellowVaultsTag = prov.tag(ModItemTags.YELLOW_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> limeVaultsTag = prov.tag(ModItemTags.LIME_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> pinkVaultsTag = prov.tag(ModItemTags.PINK_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> grayVaultsTag = prov.tag(ModItemTags.GRAY_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> lightGrayVaultsTag = prov.tag(ModItemTags.LIGHT_GRAY_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> cyanVaultsTag = prov.tag(ModItemTags.CYAN_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> purpleVaultsTag = prov.tag(ModItemTags.PURPLE_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> blueVaultsTag = prov.tag(ModItemTags.BLUE_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> brownVaultsTag = prov.tag(ModItemTags.BROWN_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> greenVaultsTag = prov.tag(ModItemTags.GREEN_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> redVaultsTag = prov.tag(ModItemTags.RED_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> blackVaultsTag = prov.tag(ModItemTags.BLACK_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> baseVaultsTag = prov.tag(ModItemTags.BASE_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> coloredHorizontalItemVaultsTag = prov.tag(ModItemTags.COLORED_HORIZONTAL_ITEM_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> coloredVerticalItemVaultsTag = prov.tag(ModItemTags.COLORED_VERTICAL_ITEM_VAULTS.tag);
        TagGen.CreateTagAppender<class_1792> coloredHorizontalShippingContainersTag = prov.tag(ModItemTags.COLORED_HORIZONTAL_SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_1792> coloredVerticalShippingContainersTag = prov.tag(ModItemTags.COLORED_VERTICAL_SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_1792> coloredHorizontalBasicShippingContainersTag = prov.tag(ModItemTags.COLORED_HORIZONTAL_BASIC_SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_1792> coloredVerticalBasicShippingContainersTag = prov.tag(ModItemTags.COLORED_VERTICAL_BASIC_SHIPPING_CONTAINERS.tag);
        TagGen.CreateTagAppender<class_1792> frogportsTag = prov.tag(ModItemTags.FROGPORTS.tag);
        TagGen.CreateTagAppender<class_1792> vibrantFrogportsTag = prov.tag(ModItemTags.VIBRANT_FROGPORTS.tag);
        TagGen.CreateTagAppender<class_1792> stockLinksTag = prov.tag(ModItemTags.STOCK_LINKS.tag);
        TagGen.CreateTagAppender<class_1792> vibrantStockLinksTag = prov.tag(ModItemTags.VIBRANT_STOCK_LINKS.tag);
        TagGen.CreateTagAppender<class_1792> redstoneRequestersTag = prov.tag(ModItemTags.REDSTONE_REQUESTERS.tag);
        TagGen.CreateTagAppender<class_1792> vibrantRedstoneRequestersTag = prov.tag(ModItemTags.VIBRANT_REDSTONE_REQUESTERS.tag);
        TagGen.CreateTagAppender<class_1792> packagersTag = prov.tag(ModItemTags.PACKAGERS.tag);
        TagGen.CreateTagAppender<class_1792> vibrantPackagersTag = prov.tag(ModItemTags.VIBRANT_PACKAGERS.tag);

        horizontalVaultsTag.add(AllBlocks.ITEM_VAULT.method_8389());
        itemVaultsTag.add(AllBlocks.ITEM_VAULT.method_8389());
        baseVaultsTag.add(AllBlocks.ITEM_VAULT.method_8389());

        for (List<BlockEntry<VibrantVaultBlock>> vaults : ModBlocks.VIBRANT_VAULTS) {
            for (BlockEntry<VibrantVaultBlock> vault : vaults) {
                VibrantVaultBlock block = vault.get();
                class_1792 item = vault.method_8389();
                vibrantVaultsTag.add(item);
                boolean vertical = vault.get() instanceof VerticalVaultBlock;
                if (vertical) {
                    verticalVaultsTag.add(item);
                } else {
                    horizontalVaultsTag.add(item);
                }
                if (block.type == ModBlocks.VibrantVaultType.ITEM_VAULT) {
                    itemVaultsTag.add(item);

                    if (block.color != ModBlocks.VibrantVaultColor.BASE) {
                        if (vertical) {
                            coloredVerticalItemVaultsTag.add(item);
                        } else {
                            coloredHorizontalItemVaultsTag.add(item);
                        }
                    }
                } else if (block.type == ModBlocks.VibrantVaultType.SHIPPING_CONTAINER) {
                    shippingContainersTag.add(item);

                    if (block.color != ModBlocks.VibrantVaultColor.BASE) {
                        if (vertical) {
                            coloredVerticalShippingContainersTag.add(item);
                        } else {
                            coloredHorizontalShippingContainersTag.add(item);
                        }
                    }
                } else if (block.type == ModBlocks.VibrantVaultType.BASIC_SHIPPING_CONTAINER) {
                    basicShippingContainersTag.add(item);

                    if (block.color != ModBlocks.VibrantVaultColor.BASE) {
                        if (vertical) {
                            coloredVerticalBasicShippingContainersTag.add(item);
                        } else {
                            coloredHorizontalBasicShippingContainersTag.add(item);
                        }
                    }
                }
                if (block.color == ModBlocks.VibrantVaultColor.WHITE) {
                    whiteVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.ORANGE) {
                    orangeVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.MAGENTA) {
                    magentaVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.LIGHT_BLUE) {
                    lightBlueVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.YELLOW) {
                    yellowVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.LIME) {
                    limeVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.PINK) {
                    pinkVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.GRAY) {
                    grayVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.LIGHT_GRAY) {
                    lightGrayVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.CYAN) {
                    cyanVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.PURPLE) {
                    purpleVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.BLUE) {
                    blueVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.BROWN) {
                    brownVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.GREEN) {
                    greenVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.RED) {
                    redVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.BLACK) {
                    blackVaultsTag.add(item);
                } else if (block.color == ModBlocks.VibrantVaultColor.BASE) {
                    baseVaultsTag.add(item);
                }
            }
        }

        frogportsTag.method_26792(ModItemTags.VIBRANT_FROGPORTS.tag);
        frogportsTag.add(AllBlocks.PACKAGE_FROGPORT.method_8389());

        for (BlockEntry<VibrantFrogportBlock> frogport : ModBlocks.VIBRANT_FROGPORTS) {
            vibrantFrogportsTag.add(frogport.method_8389());
        }

        stockLinksTag.method_26792(ModItemTags.VIBRANT_STOCK_LINKS.tag);
        stockLinksTag.add(AllBlocks.STOCK_LINK.method_8389());

        for (BlockEntry<VibrantStockLinkBlock> stockLink : ModBlocks.VIBRANT_STOCK_LINKS) {
            vibrantStockLinksTag.add(stockLink.method_8389());
        }

        redstoneRequestersTag.method_26792(ModItemTags.VIBRANT_REDSTONE_REQUESTERS.tag);
        redstoneRequestersTag.add(AllBlocks.REDSTONE_REQUESTER.method_8389());

        for (BlockEntry<VibrantRedstoneRequesterBlock> redstoneRequester : ModBlocks.VIBRANT_REDSTONE_REQUESTERS) {
            vibrantRedstoneRequestersTag.add(redstoneRequester.method_8389());
        }

        packagersTag.method_26792(ModItemTags.VIBRANT_PACKAGERS.tag);
        packagersTag.add(AllBlocks.PACKAGER.method_8389());

        for (BlockEntry<VibrantPackagerBlock> packager : ModBlocks.VIBRANT_PACKAGERS) {
            vibrantPackagersTag.add(packager.method_8389());
        }

        for (ModItemTags tag : ModItemTags.values()) {
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }
}
