package net.zlt.create_vibrant_vaults.data;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packager.PackagerBlock;
import com.simibubi.create.foundation.data.SpecialBlockStateGen;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.block.BlockModelBuilder;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.VibrantPackagerBlock;
import net.zlt.create_vibrant_vaults.duck.ModelBuilderMixinDuck;

public class VibrantPackagerBlockStateGenerator extends SpecialBlockStateGen {
    @Override
    protected int getXRotation(class_2680 state) {
        return 0;
    }

    @Override
    protected int getYRotation(class_2680 state) {
        return horizontalAngle(state.method_11654(PackagerBlock.field_10927));
    }

    @Override
    public <T extends class_2248> ModelFile getModel(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, class_2680 state) {
        if (!(state.method_26204() instanceof VibrantPackagerBlock vibrantPackager)) {
            throw new IllegalArgumentException("Invalid vibrant packager");
        }

        String colorId = vibrantPackager.color.asId();
        boolean linked = state.method_28500(PackagerBlock.LINKED).orElse(false);
        boolean powered = state.method_11654(PackagerBlock.POWERED);
        return state.method_11654(PackagerBlock.field_10927).method_10166() == class_2350.class_2351.field_11052 ? getVerticalModel(ctx, prov, linked, powered, colorId) : getHorizontalModel(ctx, prov, linked, powered, colorId);
    }

    @SuppressWarnings("unchecked")
    private <T extends class_2248> ModelFile getHorizontalModel(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, boolean linked, boolean powered, String colorId) {
        if (linked) {
            return prov.models()
                .getBuilder("block/" + ctx.getName() + "/block_linked")
                .parent(new ModelFile.UncheckedModelFile(CreateVibrantVaults.asResource("block/" + ctx.getName() + "/block")))
                .texture("2", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_horizontal_linked"));
        }

        if (powered) {
            return prov.models()
                .getBuilder("block/" + ctx.getName() + "/block_powered")
                .parent(new ModelFile.UncheckedModelFile(CreateVibrantVaults.asResource("block/" + ctx.getName() + "/block")))
                .texture("2", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_horizontal_powered"));
        }

        BlockModelBuilder builder = prov.models()
            .getBuilder("block/" + ctx.getName() + "/block")
            .parent(new ModelFile.UncheckedModelFile(Create.asResource("block/packager/block")));
        ((ModelBuilderMixinDuck<BlockModelBuilder>) builder).createVibrantVaults$uncheckedTexture("0", Create.asResource("block/packager_frame"));
        builder
            .texture("1", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_details"))
            .texture("2", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_horizontal_unpowered"))
            .texture("particle", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_particle"));
        return builder;
    }

    @SuppressWarnings("unchecked")
    private <T extends class_2248> ModelFile getVerticalModel(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, boolean linked, boolean powered, String colorId) {
        if (linked) {
            return prov.models()
                .getBuilder("block/" + ctx.getName() + "/block_vertical_linked")
                .parent(new ModelFile.UncheckedModelFile(CreateVibrantVaults.asResource("block/" + ctx.getName() + "/block_vertical")))
                .texture("5", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_vertical_linked"));
        }

        if (powered) {
            return prov.models()
                .getBuilder("block/" + ctx.getName() + "/block_vertical_powered")
                .parent(new ModelFile.UncheckedModelFile(CreateVibrantVaults.asResource("block/" + ctx.getName() + "/block_vertical")))
                .texture("5", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_vertical_powered"));
        }

        BlockModelBuilder builder = prov.models()
            .getBuilder("block/" + ctx.getName() + "/block_vertical")
            .parent(new ModelFile.UncheckedModelFile(Create.asResource("block/packager/block_vertical")));
        ((ModelBuilderMixinDuck<BlockModelBuilder>) builder).createVibrantVaults$uncheckedTexture("0", Create.asResource("block/packager_frame"));
        builder
            .texture("1", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_details"))
            .texture("5", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_vertical_unpowered"))
            .texture("particle", CreateVibrantVaults.asResource("block/packager/" + colorId + "/packager_particle"));
        return builder;
    }
}
