package net.zlt.create_vibrant_vaults.data;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlock;
import com.simibubi.create.foundation.data.SpecialBlockStateGen;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.block.BlockModelBuilder;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.zlt.create_vibrant_vaults.CreateVibrantVaults;
import net.zlt.create_vibrant_vaults.block.VibrantStockLinkBlock;
import net.zlt.create_vibrant_vaults.duck.ModelBuilderMixinDuck;

public class VibrantStockLinkBlockStateGenerator extends SpecialBlockStateGen {
    @Override
    protected int getXRotation(class_2680 state) {
        return state.method_11654(PackagerLinkBlock.field_11007) == class_2738.field_12473 ? 180 : 0;
    }

    @Override
    protected int getYRotation(class_2680 state) {
        return horizontalAngle(state.method_11654(PackagerLinkBlock.field_11177));
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T extends class_2248> ModelFile getModel(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, class_2680 state) {
        if (!(state.method_26204() instanceof VibrantStockLinkBlock vibrantStockLink)) {
            throw new IllegalArgumentException("Invalid vibrant stock link");
        }

        String colorId = vibrantStockLink.color.asId();
        boolean horizontal = state.method_11654(PackagerLinkBlock.field_11007) == class_2738.field_12471;
        boolean powered = state.method_11654(PackagerLinkBlock.POWERED);
        String variant = horizontal ? "block_horizontal" : "block_vertical";
        if (powered) {
            variant += "_powered";
        }
        BlockModelBuilder builder = prov.models().withExistingParent("block/" + colorId + "_stock_link/" + variant, CreateVibrantVaults.asResource("block/stock_link/template_" + variant));
        ((ModelBuilderMixinDuck<BlockModelBuilder>) builder).createVibrantVaults$uncheckedTexture("particle", Create.asResource("block/brass_casing"));
        builder
            .renderType("cutout")
            .customLoader(CompositeModelBuilder::begin)
            .child("base", new BlockModelBuilder(null, prov.models().existingFileHelper)
                .parent(prov.models().getExistingFile(CreateVibrantVaults.asResource("block/stock_link/template_block_" + (horizontal ? "horizontal" : "vertical") + "_base")))
                .texture("0", CreateVibrantVaults.asResource("block/stock_link/" + colorId + "/link_base_" + (powered ? "powered" : "unpowered")))
                .texture("1", CreateVibrantVaults.asResource("block/stock_link/" + colorId + "/link_details"))
                .texture("particle", CreateVibrantVaults.asResource("block/item_vault/" + colorId + "/vault_front_small")))
            .child("bulb", new BlockModelBuilder(null, prov.models().existingFileHelper)
                .parent(prov.models().getExistingFile(CreateVibrantVaults.asResource("block/stock_link/template_block_" + (horizontal ? "horizontal" : "vertical") + "_bulb")))
                .texture("1", CreateVibrantVaults.asResource("block/stock_link/" + colorId + "/link_details")));
        return builder;
    }
}
