package net.zlt.create_vibrant_vaults.item.crafting;

import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import net.zlt.create_vibrant_vaults.block.ItemVaultConnectivityHelper;
import net.zlt.create_vibrant_vaults.block.ModBlockTags;
import net.zlt.create_vibrant_vaults.block.ModBlocks;
import net.zlt.create_vibrant_vaults.block.VibrantVaultBlock;

public class VaultColoringRecipe extends class_1852 {
    public VaultColoringRecipe(class_2960 id, class_7710 category) {
        super(id, category);
    }

    @Override
    public boolean matches(class_8566 container, class_1937 level) {
        int vaultCount = 0;
        int dyeCount = 0;

        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 itemStack = container.method_5438(i);
            if (itemStack.method_7960()) {
                continue;
            }

            if (class_2248.method_9503(itemStack.method_7909()) instanceof ItemVaultBlock vault) {
                if (!ItemVaultConnectivityHelper.isVault(vault)) {
                    return false;
                }

                ++vaultCount;
            } else if (itemStack.method_7909() instanceof class_1769) {
                ++dyeCount;
            } else {
                return false;
            }

            if (vaultCount > 1 || dyeCount > 1) {
                return false;
            }
        }

        return vaultCount == 1 && dyeCount == 1;
    }

    @Override
    public class_1799 assemble(class_8566 container, class_5455 registryAccess) {
        ItemVaultBlock vault = null;
        class_1769 dye = null;

        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (!stack.method_7960()) {
                class_1792 item = stack.method_7909();
                if (class_2248.method_9503(item) instanceof ItemVaultBlock itemVaultBlock) {
                    vault = itemVaultBlock;
                } else if (item instanceof class_1769 dyeItem) {
                    dye = dyeItem;
                }

                if (vault != null && dye != null) {
                    break;
                }
            }
        }

        ModBlocks.VibrantVaultColor color = ModBlocks.VibrantVaultColor.byId(dye.method_7802().method_7789());

        if (vault instanceof VibrantVaultBlock vibrantVault) {
            return new class_1799(ModBlocks.getVibrantVault(vibrantVault.type, color, ModBlockTags.VERTICAL_VAULTS.matches(vibrantVault)));
        }

        return new class_1799(ModBlocks.getVibrantVault(ModBlocks.VibrantVaultType.ITEM_VAULT, color, false));
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    @Override
    public class_1865<VaultColoringRecipe> method_8119() {
        return ModRecipeSerializers.VAULT_COLORING;
    }
}
