package net.zlt.create_vibrant_vaults.item.crafting;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import net.zlt.create_vibrant_vaults.block.ItemVaultConnectivityHelper;
import net.zlt.create_vibrant_vaults.block.ModBlockTags;
import net.zlt.create_vibrant_vaults.block.ModBlocks;
import net.zlt.create_vibrant_vaults.block.VibrantVaultBlock;

public class VaultRotatingRecipe extends class_1852 {
    public VaultRotatingRecipe(class_2960 id, class_7710 category) {
        super(id, category);
    }

    @Override
    public boolean matches(class_8566 container, class_1937 level) {
        int vaultCount = 0;

        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 itemStack = container.method_5438(i);
            if (itemStack.method_7960()) {
                continue;
            }

            if (class_2248.method_9503(itemStack.method_7909()) instanceof ItemVaultBlock vault) {
                if (!ItemVaultConnectivityHelper.isVault(vault)) {
                    return false;
                }

                ++vaultCount;
            } else {
                return false;
            }

            if (vaultCount > 1) {
                return false;
            }
        }

        return vaultCount == 1;
    }

    @Override
    public class_1799 assemble(class_8566 container, class_5455 registryAccess) {
        ItemVaultBlock vault = null;

        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (!stack.method_7960()) {
                if (class_2248.method_9503(stack.method_7909()) instanceof ItemVaultBlock itemVaultBlock) {
                    vault = itemVaultBlock;
                    break;
                }
            }
        }

        if (vault instanceof VibrantVaultBlock vibrantVault) {
            return new class_1799(vibrantVault.type == ModBlocks.VibrantVaultType.ITEM_VAULT && vibrantVault.color == ModBlocks.VibrantVaultColor.BASE ? AllBlocks.ITEM_VAULT : ModBlocks.getVibrantVault(vibrantVault.type, vibrantVault.color, !ModBlockTags.VERTICAL_VAULTS.matches(vibrantVault)));
        }

        return new class_1799(ModBlocks.getVibrantVault(ModBlocks.VibrantVaultType.ITEM_VAULT, ModBlocks.VibrantVaultColor.BASE, true));
    }

    @Override
    public boolean method_8113(int width, int height) {
        return width * height >= 1;
    }

    @Override
    public class_1865<VaultRotatingRecipe> method_8119() {
        return ModRecipeSerializers.VAULT_ROTATING;
    }
}
