package net.zlt.create_vibrant_vaults.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.zlt.create_vibrant_vaults.block.ModBlockTags;
import net.zlt.create_vibrant_vaults.block.ModBlocks;
import net.zlt.create_vibrant_vaults.block.VibrantPackagerBlock;
import net.zlt.create_vibrant_vaults.duck.FactoryPanelBlockEntityRenderDataMixinDuck;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(FactoryPanelBlockEntity.class)
public abstract class FactoryPanelBlockEntityMixin {
    @Shadow(remap = false)
    public boolean restocker;

    @Unique
    private static class_2680 createVibrantVaults$lazyTickBlockState = null;

    @Unique
    private ModBlocks.VibrantVaultColor createVibrantVaults$restockerColor = null;

    @Inject(method = "<init>", at = @At("TAIL"), remap = false)
    private void createVibrantVaults$initRestockerColor(class_2591<?> type, class_2338 pos, class_2680 state, CallbackInfo ci) {
        createVibrantVaults$restockerColor = ModBlocks.VibrantVaultColor.BASE;
    }

    @ModifyExpressionValue(method = "lazyTick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"))
    private class_2680 createVibrantVaults$grabLazyTickBlockState(class_2680 original) {
        createVibrantVaults$lazyTickBlockState = original;
        return original;
    }

    @ModifyExpressionValue(method = "lazyTick", at = @At(value = "INVOKE", target = "Lcom/tterrag/registrate/util/entry/BlockEntry;has(Lnet/minecraft/world/level/block/state/BlockState;)Z", ordinal = 1))
    private boolean createVibrantVaults$hasPackager(boolean original) {
        return original || createVibrantVaults$lazyTickBlockState != null && ModBlockTags.VIBRANT_PACKAGERS.matches(createVibrantVaults$lazyTickBlockState);
    }

    @Inject(method = "lazyTick", at = @At("RETURN"), remap = false)
    private void createVibrantVaults$clearLazyTickBlockState(CallbackInfo ci) {
        createVibrantVaults$lazyTickBlockState = null;
    }

    @Inject(method = "lazyTick", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/content/logistics/factoryBoard/FactoryPanelBlockEntity;sendData()V"), remap = false)
    private void createVibrantVaults$setRestockerColor(CallbackInfo ci) {
        createVibrantVaults$restockerColor = restocker && createVibrantVaults$lazyTickBlockState.method_26204() instanceof VibrantPackagerBlock vibrantPackager ? vibrantPackager.color : ModBlocks.VibrantVaultColor.BASE;
    }

    @Inject(method = "read", at = @At("TAIL"), remap = false)
    private void createVibrantVaults$readRestockerColor(class_2487 tag, boolean clientPacket, CallbackInfo ci) {
        createVibrantVaults$restockerColor = ModBlocks.VibrantVaultColor.byName(tag.method_10558("CreateVibrantVaultsRestockerColor"));
    }

    @Inject(method = "write", at = @At("TAIL"), remap = false)
    private void createVibrantVaults$writeRestockerColor(class_2487 tag, boolean clientPacket, CallbackInfo ci) {
        if (createVibrantVaults$restockerColor != null) {
            tag.method_10582("CreateVibrantVaultsRestockerColor", createVibrantVaults$restockerColor.method_15434());
        }
    }

    @ModifyReturnValue(method = "getRenderData", at = @At(value = "RETURN"), remap = false)
    private Object createVibrantVaults$getExtraData(Object original) {
        ((FactoryPanelBlockEntityRenderDataMixinDuck) original).createVibrantVaults$setRestockerColor(createVibrantVaults$restockerColor);
        return original;
    }
}
