package net.zlt.create_vibrant_vaults.mixin;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.zlt.create_vibrant_vaults.block.ModBlocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(IWrenchable.class)
public interface IWrenchableMixin {
    @Inject(method = "getRotatedBlockState", at = @At("HEAD"), cancellable = true, remap = false)
    private void createVibrantVaults$rotateItemVault(class_2680 originalState, class_2350 targetedFace, CallbackInfoReturnable<class_2680> cir) {
        if (originalState.method_27852(AllBlocks.ITEM_VAULT.get()) && targetedFace.method_10166().method_10179() && targetedFace.method_10166() != originalState.method_11654(ItemVaultBlock.HORIZONTAL_AXIS)) {
            cir.setReturnValue(ModBlocks.getVibrantVault(ModBlocks.VibrantVaultType.ITEM_VAULT, ModBlocks.VibrantVaultColor.BASE, true).getDefaultState());
        }
    }
}
