package net.zlt.create_vibrant_vaults.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.zlt.create_vibrant_vaults.block.ItemVaultConnectivityHelper;
import net.zlt.create_vibrant_vaults.block.ModBlockTags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(ItemVaultBlockEntity.class)
public abstract class ItemVaultBlockEntityMixin extends SmartBlockEntity {
    @Shadow(remap = false)
    public abstract int getMaxWidth();

    @Shadow(remap = false)
    protected boolean recalculateComparatorsNextTick;

    @Shadow(remap = false)
    public abstract ItemVaultBlockEntity getControllerBE();

    private ItemVaultBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Redirect(method = "removeController", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/content/logistics/vault/ItemVaultBlock;isVault(Lnet/minecraft/world/level/block/state/BlockState;)Z"))
    private boolean createVibrantVaults$removeControllerIsVault(class_2680 state) {
        return ItemVaultConnectivityHelper.isVault(method_11010(), state);
    }

    @Redirect(method = "notifyMultiUpdated", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/content/logistics/vault/ItemVaultBlock;isVault(Lnet/minecraft/world/level/block/state/BlockState;)Z"), remap = false)
    private boolean createVibrantVaults$notifyMultiUpdatedIsVault(class_2680 state) {
        return ItemVaultConnectivityHelper.isVault(state);
    }

    @Redirect(method = "updateConnectivity", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/api/connectivity/ConnectivityHandler;formMulti(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"))
    private <T extends class_2586 & IMultiBlockEntityContainer> void createVibrantVaults$formMulti(T be) {
        ItemVaultConnectivityHelper.formItemVaultMulti(be);
    }

    @Redirect(method = "initCapability", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/api/connectivity/ConnectivityHandler;partAt(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;"))
    private <T extends class_2586 & IMultiBlockEntityContainer> T createVibrantVaults$partAt(class_2591<?> type, class_1922 level, class_2338 pos) {
        return ItemVaultConnectivityHelper.partAt(this, level, pos);
    }

    @WrapOperation(method = "getMaxLength(Lnet/minecraft/core/Direction$Axis;I)I", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/content/logistics/vault/ItemVaultBlockEntity;getMaxWidth()I"), remap = false)
    private int createVibrantVaults$getMaxHeight(ItemVaultBlockEntity instance, Operation<Integer> original, @Local(argsOnly = true) int width) {
        return ModBlockTags.VERTICAL_VAULTS.matches(method_11010()) ? ItemVaultBlockEntity.getMaxLength(width) : original.call(instance);
    }

    @WrapOperation(method = "getMaxLength(Lnet/minecraft/core/Direction$Axis;I)I", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/content/logistics/vault/ItemVaultBlockEntity;getMaxLength(I)I"))
    private int createVibrantVaults$getMaxHeight(int radius, Operation<Integer> original, @Local(argsOnly = true) int width) {
        return ModBlockTags.VERTICAL_VAULTS.matches(method_11010()) ? getMaxWidth() : original.call(radius);
    }

    @Inject(method = "updateComparators", at = @At("HEAD"), cancellable = true, remap = false)
    private void createVibrantVaults$updateComparators(CallbackInfo ci) {
        if (!ModBlockTags.VERTICAL_VAULTS.matches(method_11010())) {
            return;
        }

        recalculateComparatorsNextTick = false;

        ItemVaultBlockEntity controllerBE = getControllerBE();
        if (controllerBE == null) {
            return;
        }

        field_11863.method_8524(controllerBE.method_11016());

        class_2338 pos = controllerBE.method_11016();
        for (int y = 0; y < controllerBE.getHeight(); y++) {
            for (int z = 0; z < controllerBE.getWidth(); z++) {
                for (int x = 0; x < controllerBE.getWidth(); x++) {
                    field_11863.method_8455(pos.method_10069(x, y, z), method_11010().method_26204());
                }
            }
        }

        ci.cancel();
    }

    @ModifyExpressionValue(method = "initCapability", at = @At(value = "INVOKE", target = "Lnet/minecraft/core/BlockPos;offset(III)Lnet/minecraft/core/BlockPos;", ordinal = 1))
    private class_2338 createVibrantVaults$getVaultPos(class_2338 original, @Local(ordinal = 0) int yOffset, @Local(ordinal = 1) int xOffset, @Local(ordinal = 2) int zOffset) {
        return ModBlockTags.VERTICAL_VAULTS.matches(method_11010()) ? method_11016().method_10069(xOffset, yOffset, zOffset) : original;
    }
}
