package net.zlt.create_vibrant_vaults.mixin;

import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.zlt.create_vibrant_vaults.block.ItemVaultConnectivityHelper;
import net.zlt.create_vibrant_vaults.block.ModBlockTags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(ItemVaultBlock.class)
public abstract class ItemVaultBlockMixin extends class_2248 {
    private ItemVaultBlockMixin(class_2251 properties) {
        super(properties);
    }

    @Redirect(method = "onWrenched", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/api/connectivity/ConnectivityHandler;splitMulti(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"), remap = false)
    private <T extends class_2586 & IMultiBlockEntityContainer> void createVibrantVaults$onWrenchedSplitMulti(T be) {
        ItemVaultConnectivityHelper.splitItemVaultMulti(be);
    }

    @Redirect(method = "onRemove", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/api/connectivity/ConnectivityHandler;splitMulti(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"))
    private <T extends class_2586 & IMultiBlockEntityContainer> void createVibrantVaults$onRemoveSplitMulti(T be) {
        ItemVaultConnectivityHelper.splitItemVaultMulti(be);
    }

    @Inject(method = "getVaultBlockAxis", at = @At("HEAD"), cancellable = true, remap = false)
    private static void createVibrantVaults$getVerticalVaultAxis(class_2680 state, CallbackInfoReturnable<class_2350.class_2351> cir) {
        if (ModBlockTags.VERTICAL_VAULTS.matches(state)) {
            cir.setReturnValue(class_2350.class_2351.field_11052);
        }
    }

    @Redirect(method = "getVaultBlockAxis", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/content/logistics/vault/ItemVaultBlock;isVault(Lnet/minecraft/world/level/block/state/BlockState;)Z"))
    private static boolean createVibrantVaults$getVaultBlockAxisIsVault(class_2680 state) {
        return ItemVaultConnectivityHelper.isVault(state);
    }

    @Redirect(method = "isLarge", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/content/logistics/vault/ItemVaultBlock;isVault(Lnet/minecraft/world/level/block/state/BlockState;)Z"), remap = false)
    private static boolean createVibrantVaults$isLargeIsVault(class_2680 state) {
        return ItemVaultConnectivityHelper.isVault(state);
    }

    @Redirect(method = "getStateForPlacement", at = @At(value = "INVOKE", target = "Lcom/simibubi/create/content/logistics/vault/ItemVaultBlock;getVaultBlockAxis(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/core/Direction$Axis;"))
    private class_2350.class_2351 createVibrantVaults$getVaultPreferredAxis(class_2680 state) {
        return ItemVaultConnectivityHelper.getItemVaultPreferredAxis(this, state);
    }
}
