#include "/lib/settings.glsl"
#include "/lib/constants.glsl"


uniform vec3 sunPosition;
uniform float sunAngle;
uniform int heldItemId;
uniform int heldItemId2;


vec3 getAtmosphericLight(vec2 lightCoord, vec3 viewNormal) {
    float lightLvl = lightCoord.y;

    // Moon position & location
    vec3 moonPosition = -sunPosition;
    float moonAngle = 1-sunAngle;

    float lightReachSharp = pow(lightLvl, 16);
    float lightReachSmooth = pow(lightLvl, 2);

    float sunCycleProgress = (sin(sunAngle*2*PI)+1)/2;
    float sunDirectness = pow((dot(viewNormal, normalize(sunPosition))+1)/2, 3);
    float sunIntensity = sunDirectness * pow(sunCycleProgress, 3) * lightReachSharp * 6;

    float moonCycleProgress = (sin(moonAngle*2*PI)+1)/2;
    float moonDirectness = max(0, dot(viewNormal, normalize(moonPosition)));
    float moonIntensity = moonDirectness * pow(moonCycleProgress, 3) * lightReachSmooth * 0.01;

    // Calculate ambient light
    vec3 adjustedAmbientColor = mix(sunColor, ambientColor, max(0, (sunCycleProgress-0.5)*4));
    adjustedAmbientColor = mix(adjustedAmbientColor, moonColor, max(0, (moonCycleProgress-0.5)*4));
    float ambientLightIntensity = max((0.05), pow(sunCycleProgress, 3)) * lightReachSmooth * 0.4;

    // Return the combination of our light values
    return (adjustedAmbientColor * ambientLightIntensity + sunColor * sunIntensity + moonColor * moonIntensity);
}

vec3 getBlockLight(vec2 lightCoord) {
    float lightLvl = lightCoord.x;
    return pow(lightLvl, 5) * blockLightColor * 12;
}

vec3 getHeldLight(float vertDist) {
    if (heldItemId == 1 || heldItemId2 == 1) {
        return pow(max(0, (8-vertDist)/8), 4)*8*blockLightColor;
    }
    return vec3(0);
}
