#version 330 compatibility


uniform sampler2D colortex0;
uniform sampler2D colortex1;

in vec2 texCoord;


// Output pixel color
layout(location = 0) out vec4 pixelColor;


vec3 blur() {
    int size = 1;
    int width = size*2+1;

    vec3 sum = vec3(0);
    for (int y = -size; y <= size; y++) {
        for (int x = -size; x <= size; x++) {
            vec3 pixel = texelFetch(colortex0, ivec2(x+floor(gl_FragCoord.x), y+floor(gl_FragCoord.y)), 0).rgb;
            sum += pixel;
        }
    }
    sum = sum/(width*width);

    return sum;
}

void main() {
    vec4 color = texture(colortex0, texCoord);
    vec3 bloom = blur();
    pixelColor = vec4(mix(vec3(bloom), color.rgb, .8), color.a);
}
