#version 330 compatibility


#include "/lib/tonemapping.glsl"


uniform sampler2D colortex0;
uniform sampler2D depthtex0;

in vec2 texCoord;


// Output pixel color
layout(location = 0) out vec4 pixelColor;


void main() {
    vec4 color = texture(colortex0, texCoord);

    float depth = texture(depthtex0, texCoord).r;
    pixelColor = vec4(tonemap(color.rgb), color.a);
}
