#version 330 compatibility


in vec4 at_midBlock;

out vec2 lmcoord;
out vec2 texcoord;
out vec4 glcolor;
out vec3 viewNormal;
out float vertDist;


uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjection;
uniform vec3 cameraPosition;
uniform vec3 eyePosition;
uniform sampler2D noisetex;
uniform float frameTimeCounter;
uniform bool is_on_ground;

float getFloatness(vec3 position) {
    return texture(noisetex, position.xz/1024+vec2(frameTimeCounter/256)).r*1*0.55-0.4;
}

void main() {
    gl_Position = ftransform();
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    glcolor = gl_Color;
    viewNormal = gl_NormalMatrix * gl_Normal;
    float camVertDist = length((gl_ModelViewMatrix * gl_Vertex).xyz);
    vertDist = camVertDist - length(eyePosition - cameraPosition);
    // Block based wavyness
    vec3 eyeCameraPosition = cameraPosition + gbufferModelViewInverse[3].xyz;
    vec3 worldVertex = mat3(gbufferModelViewInverse)*(gl_ModelViewMatrix*gl_Vertex).xyz+eyeCameraPosition;
    // Modify here
    if (!is_on_ground) {
        float yOffset = getFloatness(worldVertex);
        worldVertex.y += yOffset;
    }
    worldVertex.y -= 0.05;
    // Back to view space
    vec4 outputVertex = gbufferProjection * vec4(mat3(gbufferModelView)*(worldVertex-eyeCameraPosition), 1);


    gl_Position = outputVertex;
}
