#version 330 compatibility


#include "/lib/settings.glsl"
#include "/lib/constants.glsl"
#include "/lib/tonemapping.glsl"
#include "/lib/lights.glsl"
#include "/lib/color_utils.glsl"


uniform sampler2D gtexture;
uniform float ambientLight;
uniform float screenBrightness;


in vec2 lmcoord;
in vec2 texcoord;
in vec4 glcolor;
in vec3 viewNormal;
in float vertDist;


// Output pixel color
layout(location = 0) out vec4 pixelColor;
/* RENDERTARGETS: 0 */


void main() {
    vec4 texColor = sampleTexture(gtexture, glcolor, texcoord);

    vec3 blockLight = getBlockLight(lmcoord);
    vec3 dirLight = getAtmosphericLight(lmcoord, viewNormal);
    vec3 heldLight = vec3(0);
    #ifdef HELD_ITEM_LIGHT
        heldLight = getHeldLight(vertDist);
    #endif
    vec3 light = (dirLight + blockLight + heldLight);
    light = max(vec3(ambientLight)+screenBrightness*0.05, light);
    vec3 pixelNoAlpha = texColor.rgb * light;
    pixelColor = vec4(pixelNoAlpha.r, pixelNoAlpha.g, pixelNoAlpha.b, texColor.a);
}
