#version 330 compatibility


out vec2 lmcoord;
out vec2 texcoord;
out vec4 glcolor;
out vec3 viewNormal;
out float vertDist;


uniform mat4 gbufferModelViewInverse;
uniform vec3 cameraPosition;
uniform vec3 eyePosition;

void main() {
    gl_Position = ftransform();
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    glcolor = gl_Color;
    viewNormal = gl_NormalMatrix * gl_Normal;
    float camVertDist = length((gl_ModelViewMatrix * gl_Vertex).xyz);
    vertDist = camVertDist - length(eyePosition - cameraPosition);
}
