#version 330 compatibility


#include "/lib/settings.glsl"
#include "/lib/constants.glsl"
#include "/lib/tonemapping.glsl"
#include "/lib/lights.glsl"
#include "/lib/color_utils.glsl"


// Inputs
in vec2 texCoord;
in vec2 lightCoord;
in vec4 vertColor;
in float vertDist;
in float camVertDist;
in vec3 viewNormal;


// Outputs
layout(location = 0) out vec4 pixelColor;
/* RENDERTARGETS: 0 */


// Uniforms
uniform sampler2D gtexture;
uniform float ambientLight;
uniform float screenBrightness;


void main() {
    //vec3 viewNormal = normalize(cross(dFdx(viewPos), dFdy(viewPos)));
    vec4 texColor = sampleTexture(gtexture, vertColor, texCoord);
    vec3 blockLight = getBlockLight(lightCoord);
    vec3 dirLight = getAtmosphericLight(lightCoord, viewNormal);
    vec3 heldLight = vec3(0);
    #ifdef HELD_ITEM_LIGHT
        heldLight = getHeldLight(vertDist);
    #endif
    vec3 light = (dirLight + blockLight + heldLight);
    light = max(vec3(ambientLight)+screenBrightness*0.05, light);
    vec3 pixelNoAlpha = texColor.rgb * light;
    pixelColor = vec4(pixelNoAlpha.r, pixelNoAlpha.g, pixelNoAlpha.b, texColor.a);
}
