/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.particle.AirParticleData;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.client.renderer.ArmorsArmsRenderer;
import fr.iglee42.createqualityoflife.client.renderer.EnderRenderer;
import fr.iglee42.createqualityoflife.client.renderer.GoggleArmorLayer;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.items.armors.ShadowRadianceArmorItem;
import fr.iglee42.createqualityoflife.items.armors.ShadowRadianceChestplate;
import fr.iglee42.createqualityoflife.items.armors.ShadowSteelArmorItem;
import fr.iglee42.createqualityoflife.ponder.QOLPonderPlugin;
import fr.iglee42.createqualityoflife.registries.QOLEntityTypes;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLPartialModels;
import fr.iglee42.createqualityoflife.registries.QOLSprites;
import fr.iglee42.createqualityoflife.statue.StatueModel;
import fr.iglee42.createqualityoflife.statue.StatueRenderer;
import fr.iglee42.createqualityoflife.utils.CommonKeysHandler;
import fr.iglee42.createqualityoflife.utils.KeyBindManager;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.Pos3D;
import java.util.Random;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.ponder.PonderClient;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateQOLClient {
    public static final ModelLayerLocation STATUE = new ModelLayerLocation(CreateQOL.asResource("statue"), "main");
    public static final ModelLayerLocation STATUE_INNER_ARMOR = new ModelLayerLocation(CreateQOL.asResource("statue"), "inner_armor");
    public static final ModelLayerLocation STATUE_OUTER_ARMOR = new ModelLayerLocation(CreateQOL.asResource("statue"), "outer_armor");
    private static final Logger log = LoggerFactory.getLogger(CreateQOLClient.class);

    public static void onCtorClient(IEventBus modEventBus, IEventBus forgeEventBus) {
        QOLPartialModels.init();
        modEventBus.addListener(CreateQOLClient::clientInit);
        modEventBus.addListener(CreateQOLClient::addEntityRendererLayers);
        modEventBus.addListener(CreateQOLClient::registerKeys);
        modEventBus.addListener(CreateQOLClient::registerEntityRendererLayers);
        forgeEventBus.addListener(CreateQOLClient::onClientTick);
        forgeEventBus.addListener(CreateQOLClient::onPlayerTick);
        forgeEventBus.addListener(CreateQOLClient::onLivingJump);
    }

    public static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(KeyBindManager.FANS_KEY);
        event.register(KeyBindManager.HOVER_KEY);
        event.register(KeyBindManager.ELYTRA_KEY);
        event.register(KeyBindManager.TOGGLE_FANS_ELYTRA_KEY);
        event.register(KeyBindManager.OPEN_ARMOR_CONFIG);
        event.register(KeyBindManager.DASH_KEY);
        event.register(KeyBindManager.HELMET_EFFECT_KEY);
        event.register(KeyBindManager.CHESTPLATE_EFFECT_KEY);
        event.register(KeyBindManager.LEGGINGS_EFFECT_KEY);
        event.register(KeyBindManager.BOOTS_EFFECT_KEY);
    }

    public static void clientInit(FMLClientSetupEvent event) {
        new QOLSprites();
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)QOLItems.PLAYER_PAPER.get()), (ResourceLocation)CreateQOL.asResource("has_player"), (stack, level, living, id) -> stack.m_41784_().m_128441_("linkedPlayer") ? 1.0f : 0.0f));
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)QOLItems.SHADOW_RADIANCE_CHESTPLATE.get()), (ResourceLocation)CreateQOL.asResource("elytra"), (stack, level, living, id) -> ShadowRadianceChestplate.hasElytra(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)QOLItems.REFINED_RADIANCE_CHESTPLATE.get()), (ResourceLocation)CreateQOL.asResource("elytra"), (stack, level, living, id) -> ShadowRadianceChestplate.hasElytra(stack) ? 1.0f : 0.0f);
        });
        EntityRenderers.m_174036_((EntityType)((EntityType)QOLEntityTypes.STATUE.get()), StatueRenderer::new);
        PonderIndex.addPlugin((PonderPlugin)new QOLPonderPlugin());
    }

    public static void showPropellers(BlockState renderedState, int light, PoseStack ms, MultiBufferSource buffer, RenderType renderType, LevelAccessor level) {
        PartialModel partial = AnimationTickHolder.getRenderTime((LevelAccessor)level) % 10.0f >= 5.0f ? QOLPartialModels.SHADOW_RADIANCE_CHESTPLATE_PROPELLERS : QOLPartialModels.SHADOW_RADIANCE_CHESTPLATE_PROPELLERS_ALT;
        SuperByteBuffer propellers = CachedBuffers.partial((PartialModel)partial, (BlockState)renderedState);
        propellers.light(light).renderInto(ms, buffer.m_6299_(renderType));
    }

    public static void addEntityRendererLayers(EntityRenderersEvent.AddLayers event) {
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        GoggleArmorLayer.registerOnAll(dispatcher);
    }

    public static void registerEntityRendererLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(STATUE, StatueModel::createBodyLayer);
        event.registerLayerDefinition(STATUE_INNER_ARMOR, () -> ArmorStandArmorModel.m_170347_((CubeDeformation)LayerDefinitions.f_171107_));
        event.registerLayerDefinition(STATUE_OUTER_ARMOR, () -> ArmorStandArmorModel.m_170347_((CubeDeformation)LayerDefinitions.f_171106_));
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.END) {
            ArmorsArmsRenderer.clientTick();
            if (minecraft.f_91074_ != null && minecraft.f_91073_ != null && !minecraft.m_91104_() && !minecraft.f_91074_.m_5833_()) {
                ItemStack chest = minecraft.f_91074_.m_6844_(EquipmentSlot.CHEST);
                Item item = chest.m_41720_();
                if (!chest.m_41619_() && item instanceof ShadowRadianceChestplate && CreateQOLClient.isFlying((Player)minecraft.f_91074_) && !minecraft.f_91074_.m_7500_() && minecraft.f_91066_.m_231929_().m_231551_() != ParticleStatus.MINIMAL) {
                    CreateQOLClient.showJetpackParticles(minecraft);
                }
            }
        }
    }

    private static void showJetpackParticles(Minecraft minecraft) {
        double[] dArray;
        LocalPlayer player = minecraft.f_91074_;
        Random rand = new Random();
        float random = (rand.nextFloat() - 0.5f) * 0.1f;
        if (player.m_6047_()) {
            double[] dArray2 = new double[2];
            dArray2[0] = -0.3;
            dArray = dArray2;
            dArray2[1] = -0.1;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 0.0;
            dArray = dArray3;
            dArray3[1] = 0.0;
        }
        double[] sneakBonus = dArray;
        Pos3D playerPos = new Pos3D((Entity)player).translate(0.0, 1.5, 0.0);
        Pos3D vCenter = new Pos3D((rand.nextFloat() - 0.5f) * 0.25f, -0.9 + sneakBonus[1], -0.5 + sneakBonus[0]).rotate(player.f_20883_, 0.0f);
        Pos3D v = playerPos.translate((Vec3)vCenter).translate((Vec3)new Pos3D(player.m_20184_()));
        SimpleParticleType particle = player.m_5842_() ? ParticleTypes.f_123795_ : new AirParticleData(0.0f, 0.002f);
        minecraft.f_91061_.m_107370_((ParticleOptions)particle, v.f_82479_, v.f_82480_, v.f_82481_, (double)random, -0.2, (double)random);
    }

    public static boolean isFlying(Player player) {
        Item item;
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ShadowRadianceChestplate && ShadowRadianceChestplate.isFansEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty()) {
            if (ShadowRadianceChestplate.isHoverEnable(stack)) {
                return !player.m_20096_();
            }
            return CommonKeysHandler.isHoldingUp(player);
        }
        return false;
    }

    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)livingEntity;
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        if (!(legs.m_41720_() instanceof ShadowSteelArmorItem) && !(legs.m_41720_() instanceof ShadowRadianceArmorItem)) {
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.voidWalking.get()).booleanValue()) {
            return;
        }
        if (!NBTConstants.getOrDefault(legs, "void_walk", true)) {
            return;
        }
        Level level = player.m_9236_();
        boolean isOverVoid = !(!level.m_46859_(player.m_20183_().m_7495_()) && level.m_46575_(player.m_20183_().m_7495_(), (Entity)player) || level.m_6924_(Heightmap.Types.MOTION_BLOCKING, player.m_146903_(), player.m_146907_()) != level.m_141937_() && !(player.m_20186_() <= (double)level.m_141937_()));
        boolean isSneaking = player.m_6047_();
        if (isOverVoid && !isSneaking) {
            player.m_20334_(player.m_20184_().f_82479_, 0.0, player.m_20184_().f_82481_);
            player.m_6853_(true);
            player.f_19864_ = true;
        }
    }

    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player p = event.player;
        if (!p.m_9236_().f_46443_ || !(p instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)p;
        if (player.m_150110_().f_35935_) {
            return;
        }
        ItemStack legs = player.m_6844_(EquipmentSlot.LEGS);
        if (!(legs.m_41720_() instanceof ShadowSteelArmorItem) && !(legs.m_41720_() instanceof ShadowRadianceArmorItem)) {
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.voidWalking.get()).booleanValue()) {
            return;
        }
        if (!NBTConstants.getOrDefault(legs, "void_walk", true)) {
            return;
        }
        Level level = player.m_9236_();
        boolean hasVoidUnder = true;
        for (int y = player.m_146904_(); y >= level.m_141937_(); --y) {
            if (level.m_8055_(new BlockPos(player.m_146903_(), y, player.m_146907_())).m_60795_()) continue;
            hasVoidUnder = false;
            break;
        }
        if (hasVoidUnder) {
            player.m_20256_(new Vec3(player.m_20184_().f_82479_, 0.0, player.m_20184_().f_82481_));
            player.f_19864_ = true;
            player.m_6853_(true);
            float f = player.m_20096_() && !player.m_21224_() && !player.m_6069_() ? Math.min(0.1f, (float)player.m_20184_().m_165924_()) : 0.0f;
            player.f_36100_ += (f - player.f_36100_) * 0.4f;
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class TickEvents {
        @SubscribeEvent
        public static void onTickPre(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            TickEvents.onTick(true);
        }

        @SubscribeEvent
        public static void onTickPost(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            TickEvents.onTick(false);
        }

        public static void onTick(boolean isPreEvent) {
            if (!PonderClient.isGameActive()) {
                return;
            }
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (isPreEvent) {
                return;
            }
            EnderRenderer.tick();
        }
    }
}

