/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import fr.iglee42.createqualityoflife.blocks.StockManagerBlock;
import fr.iglee42.createqualityoflife.menus.ChooseLogisticNetworkMenu;
import fr.iglee42.createqualityoflife.menus.StockManagerMenu;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StockManagerBlockEntity
extends SmartBlockEntity
implements IHaveHoveringInformation {
    public LogisticallyLinkedBehaviour behaviour;
    public LerpedFloat headAnimation = LerpedFloat.linear();
    public LerpedFloat headAngle = LerpedFloat.angular();
    public UUID placedBy;

    public StockManagerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.headAngle.startWithValue((double)((AngleHelper.horizontalAngle((Direction)state.m_61145_((Property)StockManagerBlock.f_54117_).orElse(Direction.SOUTH)) + 180.0f) % 360.0f));
        this.placedBy = null;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.behaviour = new LogisticallyLinkedBehaviour((SmartBlockEntity)this, true);
        behaviours.add((BlockEntityBehaviour)this.behaviour);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean shouldTickAnimation() {
        return !VisualizationManager.supportsVisualization((LevelAccessor)this.f_58857_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAnimation() {
        float target = 0.0f;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !player.m_20145_()) {
            double z;
            double x;
            if (this.isVirtual()) {
                x = -4.0;
                z = -10.0;
            } else {
                x = player.m_20185_();
                z = player.m_20189_();
            }
            double dx = x - ((double)this.m_58899_().m_123341_() + 0.5);
            double dz = z - ((double)this.m_58899_().m_123343_() + 0.5);
            target = AngleHelper.deg((double)(-Mth.m_14136_((double)dz, (double)dx))) - 90.0f;
        }
        target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
        this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
        this.headAngle.tickChaser();
        this.headAnimation.chase(0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            if (this.shouldTickAnimation()) {
                this.tickAnimation();
            }
            return;
        }
    }

    public boolean hasBlazeFromBlock() {
        return this.m_58900_().m_61145_((Property)StockManagerBlock.HAS_BLAZE).orElse(false);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.placedBy != null) {
            tag.m_128362_("PlacedBy", this.placedBy);
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.placedBy = tag.m_128441_("PlacedBy") ? tag.m_128342_("PlacedBy") : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return true;
    }

    public class ChooseNetworkProvider
    implements MenuProvider {
        public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
            return ChooseLogisticNetworkMenu.create(pContainerId, pPlayerInventory, StockManagerBlockEntity.this);
        }

        public Component m_5446_() {
            return Component.m_237119_();
        }
    }

    public class StockManagerProvider
    implements MenuProvider {
        public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
            return StockManagerMenu.create(pContainerId, pPlayerInventory, StockManagerBlockEntity.this);
        }

        public Component m_5446_() {
            return Component.m_237119_();
        }
    }
}

