/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import fr.iglee42.createqualityoflife.utils.TrashFluidTank;
import fr.iglee42.createqualityoflife.utils.TrashItemHandler;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TrashCanBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    TrashItemHandler itemHandler = new TrashItemHandler(this);
    protected TrashFluidTank tankInventory = new TrashFluidTank(this);
    LazyOptional<IItemHandler> lazyHandler = LazyOptional.of(() -> this.itemHandler);
    LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.of(() -> this.tankInventory);
    LazyOptional<IItemHandler> capAbove = LazyOptional.empty();
    LazyOptional<IFluidHandler> fluidCapAbove = LazyOptional.empty();

    public TrashCanBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.lazyHandler.cast() : (cap == ForgeCapabilities.FLUID_HANDLER ? this.lazyFluidHandler.cast() : super.getCapability(cap, side));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
    }

    public boolean canAcceptItem(ItemStack stack) {
        return true;
    }

    public boolean canAcceptFluid(FluidStack stack) {
        return true;
    }

    protected int getExtractionAmount() {
        return 16;
    }

    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return ItemHelper.ExtractionCountMode.UPTO;
    }

    protected boolean canActivate() {
        return true;
    }

    protected void handleInputFromAbove() {
        if (!this.capAbove.isPresent()) {
            this.capAbove = this.grabCapability(Direction.UP);
        }
        this.handleInput((IItemHandler)this.capAbove.orElse(null));
    }

    protected void handleInput(@Nullable IItemHandler inv) {
        if (inv == null) {
            return;
        }
        if (!this.canActivate()) {
            return;
        }
        Predicate<ItemStack> canAccept = this::canAcceptItem;
        int count = this.getExtractionAmount();
        ItemHelper.ExtractionCountMode mode = this.getExtractionMode();
        if (mode == ItemHelper.ExtractionCountMode.UPTO || !ItemHelper.extract((IItemHandler)inv, canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)true).m_41619_()) {
            ItemHelper.extract((IItemHandler)inv, canAccept, (ItemHelper.ExtractionCountMode)mode, (int)count, (boolean)false);
        }
    }

    protected LazyOptional<IItemHandler> grabCapability(Direction side) {
        BlockPos pos = this.f_58858_.m_121945_(side);
        if (this.f_58857_ == null) {
            return LazyOptional.empty();
        }
        BlockEntity be = this.f_58857_.m_7702_(pos);
        if (be == null) {
            return LazyOptional.empty();
        }
        if (be instanceof ChuteBlockEntity && side != Direction.DOWN) {
            return LazyOptional.empty();
        }
        return be.getCapability(ForgeCapabilities.ITEM_HANDLER, side.m_122424_());
    }

    protected void handleFluidInputFromAbove() {
        if (!this.fluidCapAbove.isPresent()) {
            this.fluidCapAbove = this.grabFluidCapability(Direction.UP);
        }
        this.handleFluidInput((IFluidHandler)this.fluidCapAbove.orElse(null));
    }

    protected LazyOptional<IFluidHandler> grabFluidCapability(Direction side) {
        BlockPos pos = this.f_58858_.m_121945_(side);
        if (this.f_58857_ == null) {
            return LazyOptional.empty();
        }
        BlockEntity be = this.f_58857_.m_7702_(pos);
        if (be == null) {
            return LazyOptional.empty();
        }
        return be.getCapability(ForgeCapabilities.FLUID_HANDLER, side.m_122424_());
    }

    protected void handleFluidInput(@Nullable IFluidHandler inv) {
        if (inv == null) {
            return;
        }
        if (!this.canActivate()) {
            return;
        }
        for (int t = 0; t < inv.getTanks(); ++t) {
            if (!this.canAcceptFluid(inv.getFluidInTank(t))) continue;
            inv.drain(inv.getFluidInTank(t), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void invalidate() {
        if (this.lazyHandler != null) {
            this.lazyHandler.invalidate();
        }
        if (this.lazyFluidHandler != null) {
            this.lazyFluidHandler.invalidate();
        }
        super.invalidate();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return true;
    }
}

