/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blocks;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllShapes;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import com.simibubi.create.foundation.block.IBE;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.items.StockManagerBlockItem;
import fr.iglee42.createqualityoflife.registries.QOLBlockEntities;
import fr.iglee42.createqualityoflife.registries.QOLBlocks;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.utils.LogisticsNetworkExtension;
import fr.iglee42.createqualityoflife.utils.NetworkDestructionLevel;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class StockManagerBlock
extends HorizontalDirectionalBlock
implements IBE<StockManagerBlockEntity>,
IWrenchable {
    public static final BooleanProperty HAS_BLAZE = BooleanProperty.m_61465_((String)"has_blaze");

    public StockManagerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HAS_BLAZE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction facing = pContext.m_8125_().m_122424_();
        boolean reverse = pContext.m_43723_() != null && pContext.m_43723_().m_6144_();
        ItemStack stack = pContext.m_43722_();
        Item item = stack.m_41720_();
        BlockState defaultState = this.m_49966_();
        if (!(item instanceof StockManagerBlockItem)) {
            return defaultState;
        }
        return (BlockState)((BlockState)super.m_5573_(pContext).m_61124_((Property)HAS_BLAZE, (Comparable)Boolean.valueOf(((StockManagerBlockItem)item).hasCapturedBlaze()))).m_61124_((Property)f_54117_, (Comparable)(reverse ? facing.m_122424_() : facing));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{f_54117_, HAS_BLAZE}));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer != null && pPlayer.m_21120_(pHand).m_41720_() instanceof LogisticallyLinkedBlockItem) {
            return InteractionResult.PASS;
        }
        return this.onBlockEntityUse((BlockGetter)pLevel, pPos, stbe -> {
            if (!stbe.behaviour.mayInteractMessage(pPlayer)) {
                return InteractionResult.SUCCESS;
            }
            if (pPlayer instanceof ServerPlayer) {
                HashMap<Object, Object> permissions;
                ServerPlayer sp = (ServerPlayer)pPlayer;
                boolean showLockOption = stbe.behaviour.mayAdministrate(pPlayer) && Create.LOGISTICS.isLockable(stbe.behaviour.freqId);
                boolean isCurrentlyLocked = Create.LOGISTICS.isLocked(stbe.behaviour.freqId);
                LogisticsNetwork network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(stbe.behaviour.freqId);
                String name = network != null ? ((LogisticsNetworkExtension)network).createQOL$getName() : "Unnamed Network";
                int links = network != null ? network.totalLinks.size() : 1;
                NetworkDestructionLevel desLevel = network != null ? ((LogisticsNetworkExtension)network).createQOL$getDestructionLevel() : NetworkDestructionLevel.ALL;
                if (network != null) {
                    permissions = new HashMap<UUID, NetworkPermission>(((LogisticsNetworkExtension)network).createQOL$getPlayersPermission());
                    if (network.owner != null) {
                        permissions.put(network.owner, (Object)NetworkPermission.OWNER);
                    }
                    pLevel.m_6907_().stream().filter(p -> !permissions.containsKey(p.m_20148_())).forEach(p -> permissions.put(p.m_20148_(), (Object)NetworkPermission.NONE));
                } else {
                    permissions = new HashMap();
                }
                boolean isOwner = network != null ? pPlayer.m_20148_().equals(network.owner) : false;
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)(StockManagerBlockEntity)((Object)stbe).new StockManagerBlockEntity.StockManagerProvider(), buf -> {
                    buf.writeBoolean(showLockOption);
                    buf.writeBoolean(isOwner);
                    buf.writeBoolean(isCurrentlyLocked);
                    buf.m_130070_(name);
                    buf.writeInt(links);
                    buf.writeByte(desLevel.ordinal());
                    buf.writeBoolean(desLevel.canDestroy(stbe.behaviour.freqId, pPlayer));
                    buf.m_236831_(permissions, FriendlyByteBuf::m_130077_, (b, p) -> b.writeByte(p.ordinal()));
                    buf.m_130064_(pPos);
                });
            }
            return InteractionResult.SUCCESS;
        });
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.STOCK_TICKER;
    }

    @OnlyIn(value=Dist.CLIENT)
    public PartialModel getHat(LevelAccessor level, BlockPos pos, LivingEntity keeper) {
        return AllPartialModels.LOGISTICS_HAT;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        IBE.onRemove((BlockState)pState, (Level)pLevel, (BlockPos)pPos, (BlockState)pNewState);
    }

    public Class<StockManagerBlockEntity> getBlockEntityClass() {
        return StockManagerBlockEntity.class;
    }

    public BlockEntityType<? extends StockManagerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)QOLBlockEntities.STOCK_MANAGER.get();
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return false;
    }

    public static int getLight(BlockState state) {
        boolean hasBlaze = (Boolean)state.m_61143_((Property)HAS_BLAZE);
        return hasBlaze ? 15 : 0;
    }

    public static LootTable.Builder buildLootTable() {
        LootItemCondition.Builder survivesExplosion = ExplosionCondition.m_81661_();
        StockManagerBlock block = (StockManagerBlock)((Object)QOLBlocks.STOCK_MANAGER.get());
        LootTable.Builder builder = LootTable.m_79147_();
        LootPool.Builder poolBuilder = LootPool.m_79043_();
        for (boolean hasBlaze : Iterate.trueAndFalse) {
            ItemLike drop = hasBlaze ? (ItemLike)QOLBlocks.STOCK_MANAGER.get() : (ItemLike)QOLItems.EMPTY_STOCK_MANAGER.get();
            poolBuilder.m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)drop).m_79080_(survivesExplosion)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)HAS_BLAZE, hasBlaze))));
        }
        builder.m_79161_(poolBuilder.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)));
        return builder;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)HAS_BLAZE)).booleanValue()) {
            return null;
        }
        return super.m_142194_(pos, state);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, plbe -> {
            if (pPlacer instanceof Player) {
                Player player = (Player)pPlacer;
                plbe.placedBy = player.m_20148_();
                plbe.notifyUpdate();
            }
        });
    }
}

