/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.renderer;

import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ArmorsArmsRenderer {
    private static final ResourceLocation SHADOW_RADIANCE_ARMS = CreateQOL.asResource("textures/models/armor/shadow_radiance_arm.png");
    private static final ResourceLocation SHADOW_STEEL_ARMS = CreateQOL.asResource("textures/models/armor/shadow_steel_arm.png");
    private static final ResourceLocation REFINED_RADIANCE_ARMS = CreateQOL.asResource("textures/models/armor/refined_radiance_arm.png");
    private static boolean rendererActive = false;

    public static void clientTick() {
        Minecraft mc = Minecraft.m_91087_();
        rendererActive = mc.f_91074_ != null && (QOLItems.SHADOW_RADIANCE_CHESTPLATE.isIn(mc.f_91074_.m_6844_(EquipmentSlot.CHEST)) || QOLItems.REFINED_RADIANCE_CHESTPLATE.isIn(mc.f_91074_.m_6844_(EquipmentSlot.CHEST)) || QOLItems.SHADOW_STEEL_CHESTPLATE.isIn(mc.f_91074_.m_6844_(EquipmentSlot.CHEST))) && NBTConstants.getOrDefault(mc.f_91074_.m_6844_(EquipmentSlot.CHEST), "renderType").shouldRenderArmor() && NBTConstants.getOrDefault(mc.f_91074_.m_6844_(EquipmentSlot.CHEST), "arms", true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPlayerHand(RenderArmEvent event) {
        if (!rendererActive) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        MultiBufferSource buffer = event.getMultiBufferSource();
        EntityRenderer entityRenderer = mc.m_91290_().m_114382_((Entity)player);
        if (!(entityRenderer instanceof PlayerRenderer)) {
            return;
        }
        PlayerRenderer pr = (PlayerRenderer)entityRenderer;
        PlayerModel model = (PlayerModel)pr.m_7200_();
        model.f_102608_ = 0.0f;
        model.f_102817_ = false;
        model.f_102818_ = 0.0f;
        model.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        ModelPart armPart = event.getArm() == HumanoidArm.LEFT ? model.f_103374_ : model.f_103375_;
        armPart.f_104203_ = 0.0f;
        ResourceLocation texture = QOLItems.SHADOW_RADIANCE_CHESTPLATE.isIn(mc.f_91074_.m_6844_(EquipmentSlot.CHEST)) ? SHADOW_RADIANCE_ARMS : (QOLItems.SHADOW_STEEL_CHESTPLATE.isIn(mc.f_91074_.m_6844_(EquipmentSlot.CHEST)) ? SHADOW_STEEL_ARMS : REFINED_RADIANCE_ARMS);
        armPart.m_104301_(event.getPoseStack(), buffer.m_6299_(RenderType.m_110446_((ResourceLocation)texture)), 0xF000F0, OverlayTexture.f_118083_);
        event.setCanceled(true);
    }
}

