/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import fr.iglee42.createqualityoflife.behaviours.EnderPackagerBehaviour;
import fr.iglee42.createqualityoflife.utils.EnderPackagerFrequencySlot;
import fr.iglee42.createqualityoflife.utils.EnderPackagersNetworkHandler;
import java.util.ArrayList;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EnderRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (target == null || !(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        EnderPackagerBehaviour behaviour = (EnderPackagerBehaviour)BlockEntityBehaviour.get((BlockGetter)world, (BlockPos)pos, EnderPackagerBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        MutableComponent freq1 = CreateLang.translateDirect((String)"logistics.firstFrequency", (Object[])new Object[0]);
        MutableComponent freq2 = CreateLang.translateDirect((String)"logistics.secondFrequency", (Object[])new Object[0]);
        for (boolean first : Iterate.trueAndFalse) {
            AABB bb = new AABB(Vec3.f_82478_, Vec3.f_82478_).m_82400_(0.25);
            MutableComponent label = first ? freq1 : freq2;
            boolean hit = behaviour.testHit(first, target.m_82450_());
            EnderPackagerFrequencySlot transform = (EnderPackagerFrequencySlot)(first ? behaviour.firstSlot : behaviour.secondSlot);
            ValueBox box = new ValueBox((Component)label, bb, pos).passive(!hit);
            boolean empty = ((EnderPackagersNetworkHandler.Frequency)behaviour.getNetworkKey().get(first)).getStack().m_41619_();
            if (!empty) {
                box.wideOutline();
            }
            Outliner.getInstance().showOutline((Object)Pair.of((Object)first, (Object)pos), (Outline)box.transform((ValueBoxTransform)transform)).highlightFace(result.m_82434_());
            if (!hit) continue;
            ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
            tip.add(label.m_6881_());
            tip.add(CreateLang.translateDirect((String)(empty ? "logistics.filter.click_to_set" : "logistics.filter.click_to_replace"), (Object[])new Object[0]));
            CreateClient.VALUE_SETTINGS_HANDLER.showHoverTip(tip);
        }
    }

    public static void renderOnBlockEntity(SmartBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (be == null || be.m_58901_()) {
            return;
        }
        Entity cameraEntity = Minecraft.m_91087_().f_91075_;
        float max = AllConfigs.client().filterItemRenderDistance.getF();
        if (!be.isVirtual() && cameraEntity != null && cameraEntity.m_20182_().m_82557_(VecHelper.getCenterOf((Vec3i)be.m_58899_())) > (double)(max * max)) {
            return;
        }
        EnderPackagerBehaviour behaviour = (EnderPackagerBehaviour)be.getBehaviour(EnderPackagerBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        for (boolean first : Iterate.trueAndFalse) {
            ValueBoxTransform transform = first ? behaviour.firstSlot : behaviour.secondSlot;
            ItemStack stack = first ? behaviour.frequencyFirst.getStack() : behaviour.frequencyLast.getStack();
            ms.m_85836_();
            transform.transform((LevelAccessor)be.m_58904_(), be.m_58899_(), be.m_58900_(), ms);
            ValueBoxRenderer.renderItemIntoValueBox((ItemStack)stack, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
            ms.m_85849_();
        }
    }
}

