/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.menus.StockManagerMenu;
import fr.iglee42.createqualityoflife.packets.DestroyLogisticsNetworkComponentPacket;
import fr.iglee42.createqualityoflife.packets.ModifyLogisticsNetworkPacket;
import fr.iglee42.createqualityoflife.packets.ModifyPlayerNetworkPermissionPacket;
import fr.iglee42.createqualityoflife.packets.OpenSwitchLogisticNetworkScreenPacket;
import fr.iglee42.createqualityoflife.packets.StockManagerDestructionLevelPacket;
import fr.iglee42.createqualityoflife.packets.StockManagerLockPacket;
import fr.iglee42.createqualityoflife.registries.QOLGuiTextures;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import fr.iglee42.createqualityoflife.utils.NetworkDestructionLevel;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import org.lwjgl.glfw.GLFW;

public class StockManagerScreen
extends AbstractSimiContainerScreen<StockManagerMenu> {
    private EditBox nameBox;
    private static final AllGuiTextures NUMBERS = AllGuiTextures.NUMBERS;
    private static final QOLGuiTextures HEADER = QOLGuiTextures.STOCK_MANAGER_HEADER;
    private static final QOLGuiTextures UPPER_BODY = QOLGuiTextures.STOCK_MANAGER_UPPER_BODY;
    private static final QOLGuiTextures SEPARATION = QOLGuiTextures.STOCK_MANAGER_SEPARATION;
    private static final QOLGuiTextures LOWER_BODY = QOLGuiTextures.STOCK_MANAGER_LOWER_BODY;
    private static final QOLGuiTextures FOOTER = QOLGuiTextures.STOCK_MANAGER_FOOTER;
    StockManagerBlockEntity blockEntity;
    public LerpedFloat itemScroll;
    int lockX;
    int lockY;
    int destroyX;
    int destroyY;
    int switchX;
    int switchY;
    int windowWidth;
    int windowHeight;
    private boolean isAdmin;
    private boolean isOwner;
    private boolean isLocked;
    private String networkName;
    private int links;
    private List<LogisticallyLinkedBehaviour> behaviours;
    private NetworkDestructionLevel destructionLevel;
    private boolean mayDestroy;
    private boolean scrollHandleActive;
    private Map<UUID, NetworkPermission> permissions;
    private List<Rect2i> extraAreas = Collections.emptyList();
    public LerpedFloat blocksScroll = LerpedFloat.linear().startWithValue(0.0);
    public LerpedFloat playersScroll = LerpedFloat.linear().startWithValue(0.0);
    private int lowerBodyStartY;
    private final Component clickToEdit = CreateQOLLang.translateDirect("gui.choose_network.lmb_manage", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC});

    public StockManagerScreen(StockManagerMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.isAdmin = ((StockManagerMenu)this.f_97732_).isAdmin;
        this.isOwner = ((StockManagerMenu)this.f_97732_).isOwner;
        this.isLocked = ((StockManagerMenu)this.f_97732_).isLocked;
        this.mayDestroy = ((StockManagerMenu)this.f_97732_).mayDestroy;
        this.networkName = ((StockManagerMenu)this.f_97732_).name;
        this.links = ((StockManagerMenu)this.f_97732_).links;
        this.destructionLevel = ((StockManagerMenu)this.f_97732_).destructionLevel;
        this.permissions = ((StockManagerMenu)this.f_97732_).permissions.entrySet().stream().sorted((e1, e2) -> ((NetworkPermission)((Object)((Object)e2.getValue()))).ordinal() - ((NetworkPermission)((Object)((Object)e1.getValue()))).ordinal()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        this.blockEntity = (StockManagerBlockEntity)((Object)container.contentHolder);
        this.behaviours = new ArrayList<LogisticallyLinkedBehaviour>(LogisticallyLinkedBehaviour.getAllPresent((UUID)this.blockEntity.behaviour.freqId, (boolean)true, (boolean)true));
        this.behaviours.sort((a, b) -> {
            if (a.getPos().equals((Object)this.blockEntity.m_58899_()) && !b.getPos().equals((Object)this.blockEntity.m_58899_())) {
                return -1;
            }
            if (!a.getPos().equals((Object)this.blockEntity.m_58899_()) && b.getPos().equals((Object)this.blockEntity.m_58899_())) {
                return 1;
            }
            return 0;
        });
        this.itemScroll = LerpedFloat.linear().startWithValue(0.0);
    }

    protected void m_7856_() {
        int appropriateHeight = Minecraft.m_91087_().m_91268_().m_85446_() - 10;
        appropriateHeight -= Mth.m_14100_((int)(appropriateHeight - HEADER.getHeight() - FOOTER.getHeight()), (int)LOWER_BODY.getHeight());
        appropriateHeight = Math.min(appropriateHeight, HEADER.getHeight() + FOOTER.getHeight() + LOWER_BODY.getHeight() * 17);
        this.windowWidth = 226;
        this.windowHeight = appropriateHeight;
        this.setWindowSize(226, this.windowHeight);
        super.m_7856_();
        this.m_169413_();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.lockX = x + 184;
        this.lockY = y + 18;
        this.destroyX = this.lockX + 16;
        this.destroyY = y + 18;
        this.switchX = x + 25;
        this.switchY = y + 18;
        this.extraAreas = new ArrayList<Rect2i>();
        int leftHeight = 40;
        int rightHeight = 50;
        Consumer<String> onTextChanged = s -> this.nameBox.m_252865_(this.nameBoxX((String)s, this.nameBox));
        this.nameBox = new EditBox((Font)new NoShadowFontWrapper(this.f_96547_), x + 10, y + 4, LOWER_BODY.getWidth() - 15 - 20, 10, (Component)Component.m_237113_((String)this.networkName));
        this.nameBox.m_94182_(false);
        this.nameBox.m_94199_(40);
        this.nameBox.m_94202_(5841956);
        this.nameBox.m_94144_(this.networkName);
        this.nameBox.m_93692_(false);
        this.nameBox.m_6375_(0.0, 0.0, 0);
        this.nameBox.m_94151_(onTextChanged);
        this.nameBox.m_252865_(this.nameBoxX(this.nameBox.m_94155_(), this.nameBox));
        this.nameBox.m_94186_(this.isOwner);
        this.m_142416_((GuiEventListener)this.nameBox);
    }

    private int nameBoxX(String s, EditBox nameBox) {
        return this.getGuiLeft() - 15 + LOWER_BODY.getWidth() / 2 - Math.min(this.f_96547_.m_92895_(s), nameBox.m_5711_()) / 2;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.blocksScroll.tickChaser();
        this.playersScroll.tickChaser();
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        PoseStack ms = guiGraphics.m_280168_();
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.0f, -300.0f);
        super.m_280273_(guiGraphics);
        ms.m_85849_();
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int i;
        if (this != this.f_96541_.f_91080_) {
            return;
        }
        PoseStack ms = graphics.m_280168_();
        ms.m_85836_();
        float currentScroll = this.itemScroll.getValue(partialTicks);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        HEADER.render(graphics, x - 15, y);
        y += HEADER.getHeight();
        for (i = 0; i < (this.windowHeight - HEADER.getHeight() - FOOTER.getHeight() - SEPARATION.getHeight()) / 2 / UPPER_BODY.getHeight(); ++i) {
            UPPER_BODY.render(graphics, x - 15, y);
            y += UPPER_BODY.getHeight();
        }
        SEPARATION.render(graphics, x - 15, y);
        this.lowerBodyStartY = new AtomicInteger(y += SEPARATION.getHeight()).get();
        for (i = 0; i < (this.windowHeight - HEADER.getHeight() - FOOTER.getHeight() - SEPARATION.getHeight()) / 2 / LOWER_BODY.getHeight(); ++i) {
            LOWER_BODY.render(graphics, x - 15, y);
            y += LOWER_BODY.getHeight();
        }
        FOOTER.render(graphics, x - 15, y);
        y = this.getGuiTop();
        ms.m_85836_();
        this.renderBehaviours(graphics, mouseX, mouseY, partialTicks);
        this.renderPlayers(graphics, mouseX, mouseY, partialTicks, this.lowerBodyStartY);
        ms.m_85849_();
        if (this.isAdmin) {
            (this.isLocked ? QOLGuiTextures.STOCK_MANAGER_LOCKED : QOLGuiTextures.STOCK_MANAGER_UNLOCKED).render(graphics, this.lockX, this.lockY);
        }
        if (this.isAdmin) {
            (switch (this.destructionLevel) {
                case NetworkDestructionLevel.MEMBERS -> QOLGuiTextures.STOCK_MANAGER_DESTRUCTION_MEMBERS;
                case NetworkDestructionLevel.ADMINS -> QOLGuiTextures.STOCK_MANAGER_DESTRUCTION_ADMINS;
                default -> QOLGuiTextures.STOCK_MANAGER_DESTRUCTION_ALLOW;
            }).render(graphics, this.destroyX, this.destroyY);
        }
        QOLGuiTextures.STOCK_MANAGER_SWITCH_NETWORK.render(graphics, this.switchX, this.switchY);
        String text = this.nameBox.m_94155_();
        if (!this.nameBox.m_93696_() && this.isOwner) {
            QOLGuiTextures.STOCK_MANAGER_EDIT_NAME.render(graphics, this.nameBoxX(text, this.nameBox) + this.f_96547_.m_92895_(text) + 5, y + 1);
        }
        ms.m_85849_();
    }

    protected void renderBehaviours(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = graphics.m_280168_();
        int yOffset = this.getGuiTop() + HEADER.getHeight() - 8;
        float scrollOffset = -this.blocksScroll.getValue(partialTicks);
        for (int i = 0; i < this.behaviours.size(); ++i) {
            LogisticallyLinkedBehaviour entry = this.behaviours.get(i);
            int itemWindowX = this.f_97735_ + 3;
            int itemWindowY = this.f_97736_ + HEADER.getHeight();
            int itemWindowX2 = itemWindowX + 210;
            int itemWindowY2 = (int)((float)itemWindowY + (float)(this.windowHeight - HEADER.getHeight() - FOOTER.getHeight() - SEPARATION.getHeight()) / 2.0f / (float)LOWER_BODY.getHeight() * (float)UPPER_BODY.getHeight());
            graphics.m_280588_(itemWindowX - 5, itemWindowY, itemWindowX2 + 10, itemWindowY2);
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, scrollOffset, 40.0f);
            int cardHeight = this.renderBehaviourEntry(graphics, i, entry, yOffset, mouseX, mouseY, partialTicks);
            yOffset += cardHeight;
            matrixStack.m_85849_();
            graphics.m_280618_();
        }
    }

    public int renderBehaviourEntry(GuiGraphics graphics, int i, LogisticallyLinkedBehaviour entry, int yOffset, int mouseX, int mouseY, float partialTicks) {
        int cardWidth = 160;
        int cardHeader = 20;
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(this.f_97735_ + 18), (float)(this.f_97736_ + yOffset), 0.0f);
        QOLGuiTextures.CHOOSE_NETWORK_ENTRY.render(graphics, 0, 0);
        if (Minecraft.m_91087_().f_91077_ != null && Minecraft.m_91087_().f_91074_ != null) {
            graphics.m_280480_(Minecraft.m_91087_().f_91073_.m_8055_(entry.getPos()).getCloneItemStack(Minecraft.m_91087_().f_91077_, (BlockGetter)Minecraft.m_91087_().f_91073_, entry.getPos(), (Player)Minecraft.m_91087_().f_91074_), 10, 1);
        }
        MutableComponent name = Component.m_237113_((String)entry.getPos().m_123344_());
        graphics.m_280056_(this.f_96547_, name.m_130668_(20).stripTrailing() + (name.m_130668_(20).stripTrailing().length() > 20 ? "..." : ""), 30, 5, 0x656565, false);
        if (!entry.getPos().equals((Object)this.blockEntity.m_58899_())) {
            (this.canDestroyEntry(entry) ? QOLGuiTextures.CHOOSE_NETWORK_DELETE : QOLGuiTextures.CHOOSE_NETWORK_DELETE_DISABLED).render(graphics, 171, 4);
        }
        matrixStack.m_85849_();
        return cardHeader;
    }

    private boolean canDestroyEntry(LogisticallyLinkedBehaviour behaviour) {
        return this.mayDestroy && Minecraft.m_91087_().f_91074_.m_20183_().m_123314_((Vec3i)behaviour.getPos(), (double)((Integer)CreateQOLConfigs.server().logistics.stockManagerMaxDestroyDistance.get()).intValue());
    }

    protected void renderPlayers(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, int lowerBodyStart) {
        PoseStack matrixStack = graphics.m_280168_();
        int yOffset = lowerBodyStart;
        float scrollOffset = -this.playersScroll.getValue(partialTicks);
        ArrayList<Map.Entry<UUID, NetworkPermission>> entries = new ArrayList<Map.Entry<UUID, NetworkPermission>>(this.permissions.entrySet());
        for (int i = 0; i < entries.size(); ++i) {
            int itemWindowX = this.f_97735_ + 3;
            int itemWindowY = lowerBodyStart;
            int itemWindowX2 = itemWindowX + 210;
            int itemWindowY2 = (int)((float)itemWindowY + (float)(this.windowHeight - HEADER.getHeight() - FOOTER.getHeight() - SEPARATION.getHeight()) / 2.0f / (float)LOWER_BODY.getHeight() * (float)UPPER_BODY.getHeight());
            graphics.m_280588_(itemWindowX - 5, itemWindowY, itemWindowX2 + 10, itemWindowY2);
            matrixStack.m_85836_();
            matrixStack.m_252880_(0.0f, scrollOffset, 0.0f);
            int cardHeight = this.renderPlayerEntry(graphics, i, (Map.Entry)entries.get(i), yOffset, mouseX, mouseY, partialTicks);
            yOffset += cardHeight;
            matrixStack.m_85849_();
            graphics.m_280618_();
        }
    }

    public int renderPlayerEntry(GuiGraphics graphics, int i, Map.Entry<UUID, NetworkPermission> entry, int yOffset, int mouseX, int mouseY, float partialTicks) {
        int cardWidth = 160;
        int cardHeader = 20;
        PoseStack matrixStack = graphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)(this.f_97735_ + 18), (float)(this.f_97736_ + yOffset), 0.0f);
        QOLGuiTextures.CHOOSE_NETWORK_ENTRY.render(graphics, 0, 0);
        if (Minecraft.m_91087_().f_91073_ != null) {
            MutableComponent playerName;
            GameProfile result = Minecraft.m_91087_().m_91108_().fillProfileProperties(new GameProfile(entry.getKey(), ""), false);
            MutableComponent mutableComponent = playerName = Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.f_108617_.m_104949_(entry.getKey()) != null ? Component.m_237113_((String)Minecraft.m_91087_().f_91074_.f_108617_.m_104949_(entry.getKey()).m_105312_().getName()) : Component.m_237119_();
            if (playerName.equals(Component.m_237119_())) {
                playerName = result.isComplete() ? Component.m_237113_((String)result.getName()) : CreateQOLLang.translateDirect("gui.stock_manager.unknow_player", new Object[0]);
            }
            PlayerInfo info = Minecraft.m_91087_().f_91074_.f_108617_.m_104949_(entry.getKey());
            boolean hasDrawn = false;
            if (info != null) {
                PlayerFaceRenderer.m_280354_((GuiGraphics)graphics, (ResourceLocation)info.m_105337_(), (int)12, (int)3, (int)11);
                hasDrawn = true;
            }
            if (!hasDrawn && result.isComplete()) {
                PlayerFaceRenderer.m_280354_((GuiGraphics)graphics, (ResourceLocation)Minecraft.m_91087_().m_91109_().m_240306_(result), (int)12, (int)3, (int)11);
                hasDrawn = true;
            }
            if (!hasDrawn) {
                PlayerFaceRenderer.m_280354_((GuiGraphics)graphics, (ResourceLocation)DefaultPlayerSkin.m_118627_((UUID)entry.getKey()), (int)12, (int)3, (int)11);
            }
            graphics.m_280056_(this.f_96547_, playerName.m_130668_(23).stripTrailing() + (playerName.getString().length() > 23 ? "..." : ""), 24, 5, 0x656565, false);
            graphics.m_280614_(this.f_96547_, (Component)CreateQOLLang.translateDirect("gui.stock_manager.permission." + entry.getValue().m_7912_(), new Object[0]), 124, 5, 0x656565, false);
            if (this.isAdmin && entry.getValue().next().equals((Object)NetworkPermission.MEMBER)) {
                QOLGuiTextures.CHOOSE_NETWORK_ADD_PLAYER.render(graphics, 161, 4);
            }
            if (this.isAdmin && entry.getValue().previous().equals((Object)NetworkPermission.NONE)) {
                QOLGuiTextures.CHOOSE_NETWORK_DELETE_PLAYER.render(graphics, 174, 4);
            }
            if (this.isOwner && entry.getValue().next().equals((Object)NetworkPermission.ADMIN)) {
                QOLGuiTextures.CHOOSE_NETWORK_PROMOTE_PLAYER.render(graphics, 161, 4);
            }
            if (this.isOwner && entry.getValue().previous().equals((Object)NetworkPermission.MEMBER)) {
                QOLGuiTextures.CHOOSE_NETWORK_DEMOTE_PLAYER.render(graphics, 174, 4);
            }
        }
        matrixStack.m_85849_();
        return cardHeader;
    }

    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
        float currentScroll = this.itemScroll.getValue(partialTicks);
        if (currentScroll < 1.0f && this.isAdmin && mouseX > this.lockX && mouseX <= this.lockX + 15 && mouseY > this.lockY && mouseY <= this.lockY + 15) {
            graphics.m_280666_(this.f_96547_, List.of(CreateLang.translate((String)(this.isLocked ? "gui.stock_keeper.network_locked" : "gui.stock_keeper.network_open"), (Object[])new Object[0]).component(), CreateLang.translate((String)"gui.stock_keeper.network_lock_tip", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate((String)"gui.stock_keeper.network_lock_tip_1", (Object[])new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate((String)"gui.stock_keeper.network_lock_tip_2", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
        }
        if (currentScroll < 1.0f && this.isAdmin && mouseX > this.destroyX && mouseX <= this.destroyX + 15 && mouseY > this.destroyY && mouseY <= this.destroyY + 15) {
            graphics.m_280666_(this.f_96547_, List.of(CreateQOLLang.translate("gui.stock_manager.destruction_level", new Object[0]).add(this.destructionLevel.getName()).component(), CreateQOLLang.translate("gui.stock_manager.destruction_level_tip", new Object[0]).style(ChatFormatting.GRAY).component(), CreateQOLLang.translate("gui.stock_manager.destruction_level_tip_1", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate((String)"gui.stock_keeper.network_lock_tip_2", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
        }
        if (currentScroll < 1.0f && mouseX > this.switchX && mouseX <= this.switchX + 15 && mouseY > this.switchY && mouseY <= this.switchY + 15) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(List.of(CreateQOLLang.translate("gui.stock_manager.network_switch", new Object[0]).component(), CreateQOLLang.translate("gui.stock_manager.network_switch_tip", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()));
            if (this.links <= 1) {
                components.addAll(1, List.of(CreateQOLLang.translate("gui.choose_network.delete_warning", new Object[0]).style(ChatFormatting.RED).component(), CreateQOLLang.translate("gui.choose_network.delete_warning_1", new Object[0]).style(ChatFormatting.RED).component()));
            }
            graphics.m_280666_(this.f_96547_, components, mouseX, mouseY);
        }
        this.action(graphics, mouseX, mouseY, -1);
    }

    public boolean action(@Nullable GuiGraphics graphics, double mouseX, double mouseY, int click) {
        int fieldSize;
        int cardHeight;
        Object entry;
        int i;
        List<LogisticallyLinkedBehaviour> entries;
        if (mouseX < (double)this.f_97735_ || mouseX >= (double)(this.f_97735_ + this.f_97726_) || mouseY < (double)(this.f_97736_ + 15) || mouseY >= (double)(this.f_97736_ + this.windowHeight)) {
            return false;
        }
        int mx = (int)mouseX;
        int my = (int)mouseY;
        int x = mx - this.f_97735_ - 20;
        int y = my - this.f_97736_ - HEADER.getHeight();
        if (x < 0 || x >= 196) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        if (y < (this.windowHeight - FOOTER.getHeight() - SEPARATION.getHeight()) / 2 / LOWER_BODY.getHeight() * UPPER_BODY.getHeight() - 20) {
            y = (int)((float)y + this.blocksScroll.getValue(0.0f));
            entries = this.behaviours;
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                cardHeight = 20;
                if (y >= cardHeight) {
                    if ((y -= cardHeight) >= 0) continue;
                    return false;
                }
                fieldSize = 165;
                if (x > 0 && x <= 30 && y > 0 && y <= 16 && Minecraft.m_91087_().f_91077_ != null && Minecraft.m_91087_().f_91074_ != null) {
                    ItemStack stack = Minecraft.m_91087_().f_91073_.m_8055_(entry.getPos()).getCloneItemStack(Minecraft.m_91087_().f_91077_, (BlockGetter)Minecraft.m_91087_().f_91073_, entry.getPos(), (Player)Minecraft.m_91087_().f_91074_);
                    if (graphics != null) {
                        graphics.m_280153_(this.f_96547_, stack, (int)mouseX, (int)mouseY);
                    }
                    return true;
                }
                if (x > fieldSize && x <= fieldSize + 16 && y > 0 && y <= 16) {
                    if (this.mayDestroy) {
                        if (Minecraft.m_91087_().f_91074_.m_20183_().m_123314_((Vec3i)entry.getPos(), (double)((Integer)CreateQOLConfigs.server().logistics.stockManagerMaxDestroyDistance.get()).intValue())) {
                            this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.break_block", new Object[0]).component()), mx, my);
                            if (click == 0) {
                                QOLPackets.getChannel().sendToServer((Object)new DestroyLogisticsNetworkComponentPacket(((StockManagerBlockEntity)((Object)((StockManagerMenu)this.f_97732_).contentHolder)).m_58899_(), entry.getPos()));
                                this.behaviours.remove(entry);
                            }
                            return true;
                        }
                        this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.too_far", new Object[0]).style(ChatFormatting.RED).component(), (Object)CreateQOLLang.translate("gui.stock_manager.too_far_1", new Object[0]).style(ChatFormatting.RED).component()), mx, my);
                    } else {
                        this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.destroy_no_permission", new Object[0]).style(ChatFormatting.RED).component(), (Object)CreateQOLLang.translate("gui.stock_manager.destroy_no_permission_1", new Object[0]).style(ChatFormatting.RED).component()), mx, my);
                    }
                }
                if ((x -= 18) >= 0 && (y -= 28) >= 0 && x <= 160) continue;
                return false;
            }
        }
        x = mx - this.f_97735_ - 20;
        y = my - this.f_97736_ - this.lowerBodyStartY;
        if (x < 0 || x >= 196) {
            return false;
        }
        if (y < 0) {
            return false;
        }
        y = (int)((float)y + this.playersScroll.getValue(0.0f));
        entries = new ArrayList<Map.Entry<UUID, NetworkPermission>>(this.permissions.entrySet());
        for (i = 0; i < entries.size(); ++i) {
            entry = (Map.Entry)entries.get(i);
            cardHeight = 20;
            if (y >= cardHeight) {
                if ((y -= cardHeight) >= 0) continue;
                return false;
            }
            fieldSize = 165;
            if (x <= 0 || x > 30 || y <= 0 || y <= 16) {
                // empty if block
            }
            if (x > fieldSize - 9 && x <= fieldSize + 4 && y > 0 && y <= 16) {
                NetworkPermission next = ((NetworkPermission)((Object)entry.getValue())).next();
                if (next == NetworkPermission.MEMBER && this.isAdmin) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.add_user", new Object[0]).component()), mx, my);
                    if (click == 0) {
                        this.permissions.put((UUID)entry.getKey(), next);
                        QOLPackets.getChannel().sendToServer((Object)new ModifyPlayerNetworkPermissionPacket(this.blockEntity.m_58899_(), (UUID)entry.getKey(), next));
                    }
                    return true;
                }
                if (next == NetworkPermission.ADMIN && this.isOwner) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.promote_to", new Object[0]).component().m_7220_((Component)CreateQOLLang.translateDirect("gui.stock_manager.permission." + next.m_7912_(), new Object[0]))), mx, my);
                    if (click == 0) {
                        this.permissions.put((UUID)entry.getKey(), next);
                        QOLPackets.getChannel().sendToServer((Object)new ModifyPlayerNetworkPermissionPacket(this.blockEntity.m_58899_(), (UUID)entry.getKey(), next));
                    }
                    return true;
                }
            }
            if (x > fieldSize + 4 && x <= fieldSize + 16 && y > 0 && y <= 16) {
                NetworkPermission previous = ((NetworkPermission)((Object)entry.getValue())).previous();
                if (previous == NetworkPermission.NONE && this.isAdmin) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.remove_user", new Object[0]).component()), mx, my);
                    if (click == 0) {
                        this.permissions.put((UUID)entry.getKey(), previous);
                        QOLPackets.getChannel().sendToServer((Object)new ModifyPlayerNetworkPermissionPacket(this.blockEntity.m_58899_(), (UUID)entry.getKey(), previous));
                    }
                    return true;
                }
                if (previous == NetworkPermission.MEMBER && this.isOwner) {
                    this.renderActionTooltip(graphics, (List<Component>)ImmutableList.of((Object)CreateQOLLang.translate("gui.stock_manager.demote_to", new Object[0]).component().m_7220_((Component)CreateQOLLang.translateDirect("gui.stock_manager.permission." + previous.m_7912_(), new Object[0]))), mx, my);
                    if (click == 0) {
                        this.permissions.put((UUID)entry.getKey(), previous);
                        QOLPackets.getChannel().sendToServer((Object)new ModifyPlayerNetworkPermissionPacket(this.blockEntity.m_58899_(), (UUID)entry.getKey(), previous));
                    }
                    return true;
                }
            }
            if ((x -= 18) >= 0 && (y -= 28) >= 0 && x <= 160) continue;
            return false;
        }
        return false;
    }

    private void renderActionTooltip(@Nullable GuiGraphics graphics, List<Component> tooltip, int mx, int my) {
        if (graphics != null) {
            graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mx, my);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        boolean lmb = pButton == 0;
        boolean rmb = pButton == 1;
        int barX = 1;
        if (this.getMaxScroll() > 0 && lmb && pMouseX > (double)barX && pMouseX <= (double)(barX + 8) && pMouseY > (double)(this.getGuiTop() + 15) && pMouseY < (double)(this.getGuiTop() + this.windowHeight - 82)) {
            this.scrollHandleActive = true;
            if (this.f_96541_.m_91302_()) {
                GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212994);
            }
            return true;
        }
        if (this.isAdmin && this.itemScroll.getChaseTarget() == 0.0f && lmb && pMouseX > (double)this.lockX && pMouseX <= (double)(this.lockX + 15) && pMouseY > (double)this.lockY && pMouseY <= (double)(this.lockY + 15)) {
            this.isLocked = !this.isLocked;
            QOLPackets.getChannel().sendToServer((Object)new StockManagerLockPacket(this.blockEntity.m_58899_(), this.isLocked));
            this.playUiSound((SoundEvent)SoundEvents.f_12490_.m_203334_(), 1.0f, 1.0f);
            return true;
        }
        if (this.isAdmin && this.itemScroll.getChaseTarget() == 0.0f && lmb && pMouseX > (double)this.destroyX && pMouseX <= (double)(this.destroyX + 15) && pMouseY > (double)this.destroyY && pMouseY <= (double)(this.destroyY + 15)) {
            this.destructionLevel = this.destructionLevel.next();
            QOLPackets.getChannel().sendToServer((Object)new StockManagerDestructionLevelPacket(this.blockEntity.m_58899_(), this.destructionLevel));
            this.playUiSound((SoundEvent)SoundEvents.f_12490_.m_203334_(), 1.0f, 1.0f);
            return true;
        }
        if (this.itemScroll.getChaseTarget() == 0.0f && lmb && pMouseX > (double)this.switchX && pMouseX <= (double)(this.switchX + 15) && pMouseY > (double)this.switchY && pMouseY <= (double)(this.switchY + 15)) {
            QOLPackets.getChannel().sendToServer((Object)new OpenSwitchLogisticNetworkScreenPacket(this.blockEntity.m_58899_()));
            this.playUiSound((SoundEvent)SoundEvents.f_12490_.m_203334_(), 1.0f, 1.0f);
            return true;
        }
        if (this.isOwner && !this.nameBox.m_93696_() && pMouseY > (double)this.getGuiTop() && pMouseY < (double)(this.getGuiTop() + 14) && pMouseX > (double)this.getGuiLeft() && pMouseX < (double)(this.getGuiLeft() + HEADER.getWidth())) {
            this.nameBox.m_93692_(true);
            this.nameBox.m_94208_(0);
            this.m_7522_((GuiEventListener)this.nameBox);
            return true;
        }
        if (this.action(null, pMouseX, pMouseY, pButton)) {
            this.playUiSound((SoundEvent)SoundEvents.f_12490_.m_203334_(), 1.0f, 1.0f);
            return true;
        }
        return true;
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.scrollHandleActive) {
            this.scrollHandleActive = false;
            if (this.f_96541_.m_91302_()) {
                GLFW.glfwSetInputMode((long)this.f_96541_.m_91268_().m_85439_(), (int)208897, (int)212993);
            }
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (mouseY < (double)this.lowerBodyStartY) {
            float chaseTarget = this.blocksScroll.getChaseTarget();
            float max = 40 - (3 + AllGuiTextures.STOCK_KEEPER_CATEGORY.getHeight() * 4);
            if ((max += (float)(this.behaviours.size() * 20 + 24)) > 0.0f) {
                chaseTarget -= (float)(scrollY * 12.0);
                chaseTarget = Mth.m_14036_((float)chaseTarget, (float)0.0f, (float)max);
                this.blocksScroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
            } else {
                this.blocksScroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
            }
        } else {
            float chaseTarget = this.playersScroll.getChaseTarget();
            float max = 40 - (3 + AllGuiTextures.STOCK_KEEPER_CATEGORY.getHeight() * 4);
            if ((max += (float)(this.permissions.size() * 20 + 24)) > 0.0f) {
                chaseTarget -= (float)(scrollY * 12.0);
                chaseTarget = Mth.m_14036_((float)chaseTarget, (float)0.0f, (float)max);
                this.playersScroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
            } else {
                this.playersScroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
            }
        }
        return true;
    }

    private void clampScrollBar() {
        float newTarget;
        int maxScroll = this.getMaxScroll();
        float prevTarget = this.itemScroll.getChaseTarget();
        if (prevTarget != (newTarget = Mth.m_14036_((float)prevTarget, (float)0.0f, (float)maxScroll))) {
            this.itemScroll.startWithValue((double)newTarget);
        }
    }

    private int getMaxScroll() {
        int visibleHeight = this.windowHeight - 84;
        int totalRows = 2;
        int maxScroll = Math.max(0, totalRows - visibleHeight + 50);
        return maxScroll;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0 || !this.scrollHandleActive) {
            return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        Window window = this.f_96541_.m_91268_();
        double scaleX = (double)window.m_85445_() / (double)window.m_85443_();
        double scaleY = (double)window.m_85446_() / (double)window.m_85444_();
        int windowH = this.windowHeight - 92;
        int totalH = this.getMaxScroll() + windowH;
        int barSize = Math.max(5, Mth.m_14143_((float)((float)windowH / (float)totalH * (float)(windowH - 2))));
        int minY = this.getGuiTop() + 15 + barSize / 2;
        int maxY = this.getGuiTop() + 15 + windowH - barSize / 2;
        if (barSize >= windowH - 2) {
            return true;
        }
        int barX = 0;
        double target = (pMouseY - (double)this.getGuiTop() - 15.0 - (double)barSize / 2.0) * (double)totalH / (double)(windowH - 2);
        this.itemScroll.chase(Mth.m_14008_((double)target, (double)0.0, (double)this.getMaxScroll()), 0.8, LerpedFloat.Chaser.EXP);
        if (this.f_96541_.m_91302_()) {
            double forceX = (double)(barX + 2) / scaleX;
            double forceY = Mth.m_14008_((double)pMouseY, (double)minY, (double)maxY) / scaleY;
            GLFW.glfwSetCursorPos((long)window.m_85439_(), (double)forceX, (double)forceY);
        }
        return true;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        boolean hitEnter;
        boolean bl = hitEnter = this.m_7222_() instanceof EditBox && (pKeyCode == 257 || pKeyCode == 335);
        if (hitEnter && this.nameBox.m_93696_()) {
            this.nameBox.m_93692_(false);
            if (!this.nameBox.m_94155_().equals(this.networkName)) {
                QOLPackets.getChannel().sendToServer((Object)new ModifyLogisticsNetworkPacket(this.blockEntity.m_58899_(), this.nameBox.m_94155_()));
                this.networkName = this.nameBox.m_94155_();
                return true;
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_7861_() {
        BlockPos pos = this.blockEntity.m_58899_();
        super.m_7861_();
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        return super.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    private record PlayerEntry(UUID player, Component name, NetworkPermission permission) {
    }
}

