/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.itemsconfig;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import fr.iglee42.createqualityoflife.client.screens.itemsconfig.InventoryConfigScreen;
import fr.iglee42.createqualityoflife.client.screens.itemsconfig.TooltipsConfigScreen;
import fr.iglee42.createqualityoflife.client.screens.widgets.ArmorConfigScreenList;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.BooleanEntry;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.ValueEntry;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.createmod.catnip.animation.Force;
import net.createmod.catnip.animation.PhysicalFloat;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.FadableScreenElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemConfigScreen
extends AbstractSimiScreen {
    public static final PhysicalFloat cogSpin = PhysicalFloat.create().withLimit(10.0f).withDrag(0.3).addForce((Force)new Force.Static(0.2f));
    public static DelegatedStencilElement shadowElement = new DelegatedStencilElement((graphics, x, y, alpha) -> ItemConfigScreen.renderCog(graphics), (graphics, x, y, alpha) -> graphics.m_280509_(-200, -200, 200, 200, 0x60000000));
    private final ItemStack item;
    private final int itemSlot;
    protected ArmorConfigScreenList list;
    protected int listWidth;
    private List<Integer> armors;

    public ItemConfigScreen(int slot) {
        this.itemSlot = slot;
        this.item = Minecraft.m_91087_().f_91074_.m_150109_().m_8020_(slot);
    }

    protected void m_7856_() {
        Item item;
        super.m_7856_();
        this.listWidth = Math.min(this.f_96543_ - 80, 300);
        int yCenter = this.f_96544_ / 2;
        int listL = this.f_96543_ / 2 - this.listWidth / 2;
        int listR = this.f_96543_ / 2 + this.listWidth / 2;
        this.list = new ArmorConfigScreenList(this.f_96541_, this.listWidth, this.f_96544_ - 80, 35, this.f_96544_ - 45, 40, (Screen)this);
        this.list.m_93507_(listL);
        this.m_142416_((GuiEventListener)this.list);
        this.list.m_6702_().clear();
        BoxWidget goBack = (BoxWidget)new BoxWidget(this.f_96543_ / 2 - this.listWidth / 2 - 30, this.f_96544_ / 2 - 30, 20, 20).withPadding(2.0f, 2.0f).withCallback(() -> ScreenOpener.open((Screen)new InventoryConfigScreen()));
        goBack.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_BACK.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(goBack)));
        goBack.getToolTip().add(Component.m_237115_((String)"createqol.gui.config_screen.go_back"));
        this.m_142416_((GuiEventListener)goBack);
        if (this.item.m_41720_() instanceof QOLConfigurableItem) {
            this.list.m_6702_().add(new TooltipButtonEntry("Tooltips", "Open the config menu to choose which tooltips are displayed"));
        }
        if ((item = this.item.m_41720_()) instanceof QOLConfigurableItem) {
            QOLConfigurableItem configurableItem = (QOLConfigurableItem)item;
            try {
                List<QOLConfigurableItem.Configuration<?>> configurations = configurableItem.getConfigurations(this.item);
                this.list.m_6702_().addAll(configurations.stream().map(c -> c.type().getWidget(c)).toList());
            }
            catch (InvalidClassException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void m_86600_() {
        super.m_86600_();
        cogSpin.tick();
        this.list.m_6702_().stream().filter(e -> e instanceof ValueEntry).map(e -> (ValueEntry)((Object)e)).forEach(entry -> {
            List<ValueEntry> entries = this.list.m_6702_().stream().filter(e -> e instanceof ValueEntry).map(e -> (ValueEntry)((Object)((Object)e))).toList();
            if (entry.isEditable() && !entry.getEnableFunction().apply((ValueEntry<?>)((Object)entry), (List<ValueEntry<?>>)entries).booleanValue() && entry instanceof BooleanEntry) {
                BooleanEntry be = (BooleanEntry)((Object)entry);
                be.setValue(false);
            }
            entry.setEditable(entry.getEnableFunction().apply((ValueEntry<?>)((Object)entry), (List<ValueEntry<?>>)entries));
        });
    }

    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1339544524);
        shadowElement.at((float)this.f_96543_ * 0.5f, (float)this.f_96544_ * 0.5f, 0.0f).render(graphics);
        super.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
    }

    protected void prepareFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.f_96541_.m_91385_(), (RenderTarget)UIRenderHelper.framebuffer);
        RenderSystem.clear((int)1280, (boolean)Minecraft.f_91002_);
    }

    protected void endFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.f_96541_.m_91385_());
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.f_96543_ / 2;
        graphics.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237110_((String)"createqol.gui.item_config_screen.title", (Object[])new Object[]{this.item.m_41786_()}), x, 15, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        cogSpin.bump(3, -scroll * 5.0);
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7043_() {
        return false;
    }

    protected static void renderCog(GuiGraphics graphics) {
        float partialTicks = Minecraft.m_91087_().getPartialTick();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(-100.0f, 100.0f, -100.0f);
        poseStack.m_85841_(200.0f, 200.0f, 1.0f);
        GuiGameElement.of((BlockState)((BlockState)AllBlocks.LARGE_COGWHEEL.getDefaultState().m_61124_((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.Y))).rotateBlock(22.5, (double)cogSpin.getValue(partialTicks), 22.5).render(graphics);
        poseStack.m_85849_();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getItemSlot() {
        return this.itemSlot;
    }

    public void m_6574_(Minecraft p_96575_, int p_96576_, int p_96577_) {
        super.m_6574_(p_96575_, p_96576_, p_96577_);
    }

    public class TooltipButtonEntry
    extends ArmorConfigScreenList.LabeledEntry {
        protected List<String> commentLines;
        BoxWidget button;

        public TooltipButtonEntry(String label, String ... comments) {
            super(label);
            this.commentLines = new ArrayList<String>(List.of("."));
            this.labelTooltip.add(Component.m_237113_((String)label).m_130940_(ChatFormatting.WHITE));
            this.commentLines.addAll(Arrays.stream(comments).toList());
            this.labelTooltip.addAll(this.commentLines.stream().map(s -> s.equals(".") ? " " : s).map(Component::m_237113_).flatMap(stc -> FontHelper.cutTextComponent((Component)stc, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_RED).stream()).toList());
            this.button = (BoxWidget)new BoxWidget().withCallback(() -> ScreenOpener.open((Screen)new TooltipsConfigScreen(ItemConfigScreen.this.itemSlot)));
            this.button.showingElement(PonderGuiTextures.ICON_CONFIG_OPEN.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(this.button)).at(10.0f, 0.0f));
            this.listeners.add(this.button);
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            super.m_6311_(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
            this.button.m_252865_(x + width - 80 - 28);
            this.button.m_253211_(y + 10);
            this.button.m_93674_(35);
            this.button.setHeight(height - 20);
            this.button.updateGradientFromState();
            this.button.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        protected int getLabelWidth(int totalWidth) {
            return (int)((float)totalWidth * 0.4f) + 30;
        }
    }
}

