/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.itemsconfig;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.foundation.gui.AllIcons;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.client.screens.itemsconfig.ItemConfigScreen;
import fr.iglee42.createqualityoflife.client.screens.widgets.ArmorConfigScreenList;
import fr.iglee42.createqualityoflife.packets.ChangeItemTooltipsPacket;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.createmod.catnip.animation.Force;
import net.createmod.catnip.animation.PhysicalFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.FadableScreenElement;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.RenderElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TooltipsConfigScreen
extends AbstractSimiScreen {
    public static final PhysicalFloat cogSpin = PhysicalFloat.create().withLimit(10.0f).withDrag(0.3).addForce((Force)new Force.Static(0.2f));
    public static DelegatedStencilElement shadowElement = new DelegatedStencilElement((graphics, x, y, alpha) -> TooltipsConfigScreen.renderCog(graphics), (graphics, x, y, alpha) -> graphics.m_280509_(-200, -200, 200, 200, 0x60000000));
    private final ItemStack item;
    private final int itemSlot;
    protected ArmorConfigScreenList list;
    protected int listWidth;

    public TooltipsConfigScreen(int slot) {
        this.itemSlot = slot;
        this.item = Minecraft.m_91087_().f_91074_.m_150109_().m_8020_(slot);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.listWidth = Math.min(this.f_96543_ - 80, 300);
        int yCenter = this.f_96544_ / 2;
        int listL = this.f_96543_ / 2 - this.listWidth / 2;
        int listR = this.f_96543_ / 2 + this.listWidth / 2;
        this.list = new ArmorConfigScreenList(this.f_96541_, this.listWidth, this.f_96544_ - 80, 35, this.f_96544_ - 45, 40, (Screen)this);
        this.list.m_93507_(listL);
        this.m_142416_((GuiEventListener)this.list);
        this.list.m_6702_().clear();
        BoxWidget goBack = (BoxWidget)new BoxWidget(this.f_96543_ / 2 - this.listWidth / 2 - 30, this.f_96544_ / 2 - 30, 20, 20).withPadding(2.0f, 2.0f).withCallback(() -> ScreenOpener.open((Screen)new ItemConfigScreen(this.itemSlot)));
        goBack.showingElement((RenderElement)PonderGuiTextures.ICON_CONFIG_BACK.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(goBack)));
        goBack.getToolTip().add(Component.m_237115_((String)"createqol.gui.config_screen.go_back"));
        this.m_142416_((GuiEventListener)goBack);
        ItemTooltips tooltips = NBTConstants.getTooltipOrDefault(this.item);
        for (ItemTooltips.Tooltip t : ItemTooltips.Tooltip.values()) {
            this.list.m_6702_().add(new TooltipEntry(t.getDisplayName(), tooltips.isEnable(t), t, "Disable " + t.getDisplayName() + " in the item's tooltips"));
        }
        BoxWidget enableAll = (BoxWidget)new BoxWidget(this.f_96543_ / 2 + this.listWidth / 2 + 8, this.f_96544_ / 2 - 45, 20, 20).withPadding(2.0f, 2.0f).withCallback(() -> this.list.m_6702_().stream().map(TooltipEntry.class::cast).forEach(e -> e.setValue(true)));
        enableAll.showingElement((RenderElement)AllIcons.I_CONFIRM.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(enableAll)));
        enableAll.getToolTip().add(Component.m_237115_((String)"createqol.gui.tooltips_config_screen.enable_all"));
        this.m_142416_((GuiEventListener)enableAll);
        BoxWidget disableAll = (BoxWidget)new BoxWidget(this.f_96543_ / 2 + this.listWidth / 2 + 8, this.f_96544_ / 2 - 15, 20, 20).withPadding(2.0f, 2.0f).withCallback(() -> this.list.m_6702_().stream().map(TooltipEntry.class::cast).forEach(e -> e.setValue(false)));
        disableAll.showingElement((RenderElement)AllIcons.I_DISABLE.asStencil().withElementRenderer((FadableScreenElement)BoxWidget.gradientFactory.apply(disableAll)));
        disableAll.getToolTip().add(Component.m_237115_((String)"createqol.gui.tooltips_config_screen.disable_all"));
        this.m_142416_((GuiEventListener)disableAll);
    }

    public void m_86600_() {
        super.m_86600_();
        cogSpin.tick();
    }

    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1339544524);
        shadowElement.at((float)this.f_96543_ * 0.5f, (float)this.f_96544_ * 0.5f, 0.0f).render(graphics);
        super.renderWindowBackground(graphics, mouseX, mouseY, partialTicks);
    }

    protected void prepareFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)this.f_96541_.m_91385_(), (RenderTarget)UIRenderHelper.framebuffer);
        RenderSystem.clear((int)1280, (boolean)Minecraft.f_91002_);
    }

    protected void endFrame() {
        UIRenderHelper.swapAndBlitColor((RenderTarget)UIRenderHelper.framebuffer, (RenderTarget)this.f_96541_.m_91385_());
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.f_96543_ / 2;
        graphics.m_280653_(this.f_96541_.f_91062_, (Component)Component.m_237110_((String)"createqol.gui.tooltips_config_screen.title", (Object[])new Object[]{this.item.m_41786_()}), x, 15, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        cogSpin.bump(3, -scroll * 5.0);
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7043_() {
        return false;
    }

    protected static void renderCog(GuiGraphics graphics) {
        float partialTicks = Minecraft.m_91087_().getPartialTick();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(-100.0f, 100.0f, -100.0f);
        poseStack.m_85841_(200.0f, 200.0f, 1.0f);
        GuiGameElement.of((BlockState)((BlockState)AllBlocks.LARGE_COGWHEEL.getDefaultState().m_61124_((Property)CogWheelBlock.AXIS, (Comparable)Direction.Axis.Y))).rotateBlock(22.5, (double)cogSpin.getValue(partialTicks), 22.5).render(graphics);
        poseStack.m_85849_();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getItemSlot() {
        return this.itemSlot;
    }

    public void m_6574_(Minecraft p_96575_, int p_96576_, int p_96577_) {
        super.m_6574_(p_96575_, p_96576_, p_96577_);
    }

    public class TooltipEntry
    extends ArmorConfigScreenList.LabeledEntry {
        protected boolean value;
        protected List<String> commentLines;
        protected ItemTooltips.Tooltip tooltip;
        RenderElement enabled;
        RenderElement disabled;
        BoxWidget button;

        public TooltipEntry(String label, boolean value, ItemTooltips.Tooltip tooltip, String ... comments) {
            super(label);
            this.commentLines = new ArrayList<String>(List.of("."));
            this.value = value;
            this.tooltip = tooltip;
            this.labelTooltip.add(Component.m_237113_((String)label).m_130940_(ChatFormatting.WHITE));
            this.commentLines.addAll(Arrays.stream(comments).toList());
            this.labelTooltip.addAll(this.commentLines.stream().map(s -> s.equals(".") ? " " : s).map(Component::m_237113_).flatMap(stc -> FontHelper.cutTextComponent((Component)stc, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_RED).stream()).toList());
            this.enabled = PonderGuiTextures.ICON_CONFIRM.asStencil().withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient((GuiGraphics)ms, (float)0.0f, (int)0, (int)(height / 2), (float)height, (float)width, (Couple)AbstractSimiWidget.COLOR_SUCCESS)).at(10.0f, 0.0f);
            this.disabled = PonderGuiTextures.ICON_DISABLE.asStencil().withElementRenderer((ms, width, height, alpha) -> UIRenderHelper.angledGradient((GuiGraphics)ms, (float)0.0f, (int)0, (int)(height / 2), (float)height, (float)width, (Couple)AbstractSimiWidget.COLOR_FAIL)).at(10.0f, 0.0f);
            this.button = (BoxWidget)new BoxWidget().showingElement(this.enabled).withCallback(() -> this.setValue(!this.getValue()));
            this.listeners.add(this.button);
            this.onReset();
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            super.m_6311_(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
            this.button.m_252865_(x + width - 80 - 28);
            this.button.m_253211_(y + 10);
            this.button.m_93674_(35);
            this.button.setHeight(height - 20);
            this.button.updateGradientFromState();
            this.button.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }

        @Override
        protected int getLabelWidth(int totalWidth) {
            return (int)((float)totalWidth * 0.4f) + 30;
        }

        public void setValue(@Nonnull boolean value) {
            this.value = value;
            this.onValueChange(value);
        }

        @Nonnull
        public boolean getValue() {
            return this.value;
        }

        public void onReset() {
            this.onValueChange(this.getValue());
        }

        public void onValueChange() {
            this.onValueChange(this.getValue());
        }

        public void onValueChange(boolean newValue) {
            this.button.showingElement(newValue ? this.enabled : this.disabled);
            this.bumpCog(newValue ? 15.0f : -16.0f);
            if (Minecraft.m_91087_().f_91080_ == null) {
                CreateQOL.LOGGER.error("Cannot change component on a ValueEntry because the screen is null");
                return;
            }
            int slot = TooltipsConfigScreen.this.getItemSlot();
            QOLPackets.getChannel().sendToServer((Object)new ChangeItemTooltipsPacket(slot, this.value, this.tooltip));
        }

        protected void bumpCog() {
            this.bumpCog(10.0f);
        }

        protected void bumpCog(float force) {
            ItemConfigScreen.cogSpin.bump(3, (double)force);
        }
    }
}

