/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllKeys;
import fr.iglee42.createqualityoflife.client.screens.ConfigureStatueScreen;
import fr.iglee42.createqualityoflife.registries.QOLEntityTypes;
import fr.iglee42.createqualityoflife.registries.QOLGuiTextures;
import fr.iglee42.createqualityoflife.statue.Statue;
import fr.iglee42.createqualityoflife.statue.StatueDefaultRotations;
import java.util.Objects;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class StatuePoseWidget
extends AbstractSimiWidget {
    private final StatueDefaultRotations pose;
    private final ConfigureStatueScreen parent;

    public StatuePoseWidget(int x, int y, StatueDefaultRotations pose, ConfigureStatueScreen parent) {
        super(x, y, 45, 60);
        this.pose = pose;
        this.parent = parent;
        this.withCallback(() -> {
            pose.applyToStatue(parent.getExampleStatue());
            parent.sendUpdatePacket();
        });
    }

    protected void doRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.doRender(graphics, mouseX, mouseY, partialTicks);
        this.drawScrollingString(graphics, Minecraft.m_91087_().f_91062_, (Component)this.pose.getName(), this.m_252754_(), this.m_252754_() + this.m_5711_(), this.m_252907_() - 11, 0xFFFFFF);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        if (mouseX >= this.m_252754_() && mouseX <= this.m_252754_() + this.m_5711_() && mouseY > this.m_252907_() + this.m_93694_() && mouseY <= this.m_252907_() + this.m_93694_() + 11 && this.pose.getSource().getString().equals("Vanilla Tweaks")) {
            this.drawScrollingString(graphics, Minecraft.m_91087_().f_91062_, (Component)this.pose.getSource().m_130940_(ChatFormatting.UNDERLINE), this.m_252754_() * 2, (this.m_252754_() + this.m_5711_()) * 2, (this.m_252907_() + this.m_93694_() + 2) * 2, 5726074);
        } else {
            this.drawScrollingString(graphics, Minecraft.m_91087_().f_91062_, (Component)this.pose.getSource(), this.m_252754_() * 2, (this.m_252754_() + this.m_5711_()) * 2, (this.m_252907_() + this.m_93694_() + 2) * 2, 5726074);
        }
        graphics.m_280168_().m_85849_();
        QOLGuiTextures button = !this.f_93623_ ? QOLGuiTextures.POSE_BUTTON_DISABLED : (this.f_93622_ && AllKeys.isMouseButtonDown((int)0) ? QOLGuiTextures.POSE_BUTTON_CLICKED : (this.f_93622_ ? QOLGuiTextures.POSE_BUTTON_HOVER : QOLGuiTextures.POSE_BUTTON));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        button.render(graphics, this.m_252754_(), this.m_252907_());
        float renderTime = AnimationTickHolder.getRenderTime();
        Statue example = new Statue((EntityType<? extends LivingEntity>)((EntityType)QOLEntityTypes.STATUE.get()), (Level)Minecraft.m_91087_().f_91073_);
        CompoundTag tag = new CompoundTag();
        this.parent.getExampleStatue().m_20240_(tag);
        example.m_20258_(tag);
        example.m_20340_(false);
        this.pose.applyToStatue(example);
        int posX = this.m_252754_() + 22;
        int posY = this.m_252907_() + 51;
        InventoryScreen.m_280432_((GuiGraphics)graphics, (int)posX, (int)posY, (int)24, (Quaternionf)new Quaternionf().rotationXYZ((float)Math.toRadians(180.0), (float)Math.toRadians(renderTime / 96.0f * 360.0f), 0.0f), null, (LivingEntity)example);
    }

    private void drawScrollingString(GuiGraphics graphics, Font font, Component text, int minX, int maxX, int y, int color) {
        int maxWidth = maxX - minX;
        int textWidth = font.m_92724_(text.m_7532_());
        if (textWidth <= maxWidth) {
            graphics.m_280653_(font, text, (minX + maxX) / 2, y, color);
        } else {
            Objects.requireNonNull(font);
            AbstractWidget.m_280138_((GuiGraphics)graphics, (Font)font, (Component)text, (int)minX, (int)(y - 1), (int)maxX, (int)(y + 8), (int)color);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.m_5711_()) && mouseY > (double)(this.m_252907_() + this.m_93694_()) && mouseY <= (double)(this.m_252907_() + this.m_93694_() + 11) && this.pose.getSource().getString().equals("Vanilla Tweaks")) {
            ConfirmLinkScreen.m_274480_((String)"https://vanillatweaks.net/", (Screen)this.parent, (boolean)true);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

