/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.armors;

import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.BooleanEntry;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.items.armors.ShadowRadianceChestplate;
import fr.iglee42.createqualityoflife.registries.QOLArmorMaterials;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.PreferredRender;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RefinedRadianceChestplate
extends BacktankItem.Layered
implements QOLConfigurableItem {
    public RefinedRadianceChestplate(Item.Properties properties, Supplier<BacktankItem.BacktankBlockItem> placeable) {
        super((ArmorMaterial)QOLArmorMaterials.REFINED_RADIANCE, properties, CreateQOL.asResource("refined_radiance"), placeable);
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        this.invTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    @Override
    public int effectLevel(ItemStack stack) {
        return 0;
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ARMOR;
    }

    @Override
    public List<ArmorRenderType> renderTypes(ItemStack stack) {
        return Arrays.asList(ArmorRenderType.ALL, ArmorRenderType.NONE);
    }

    @Override
    public MobEffect providedEffect(ItemStack stack) {
        return MobEffects.f_19605_;
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(new QOLConfigurableItem.Configuration<PreferredRender>("Preferred Render", NBTConstants.getOrDefault("preferredRender", stack), "preferredRender", QOLConfigurableItem.Configuration.ConfigType.ENUM, Arrays.asList("Define how the additions should be rendered.", "\"Elytra\" renders only the elytra", "\"Backtank\" renders only the backtank"), (direction, entry) -> {
            PreferredRender e = (PreferredRender)((Object)((Object)entry.getValue()));
            PreferredRender[] options = (PreferredRender[])Arrays.stream(PreferredRender.values()).toArray(PreferredRender[]::new);
            e = options[Math.floorMod(e.ordinal() + direction, options.length)];
            return e;
        }, (e, oe) -> true));
        if (ShadowRadianceChestplate.hasElytra(stack)) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Elytra", NBTConstants.getOrDefault(stack, "elytraState", true), "elytraState", Arrays.asList("Activate the elytra on the backtank", "_Can't be enabled if the fan is enabled_"), (entry, oe) -> {
                boolean flag = oe.stream().noneMatch(e -> {
                    BooleanEntry oEntry;
                    return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getNbtKey().equals("fans") && (Boolean)oEntry.getValue() != false;
                });
                return (Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get() != false && flag;
            }));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.air").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)String.valueOf(BacktankUtil.getAir((ItemStack)stack))).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)("/" + BacktankUtil.maxAir((ItemStack)stack))).m_130940_(ChatFormatting.GOLD)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.elytra").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get(), ShadowRadianceChestplate.hasElytra(stack), ShadowRadianceChestplate.isElytraEnable(stack), true, false)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.arms").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState(true, true, NBTConstants.getOrDefault(stack, "arms", true), false, true)));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    public boolean m_142522_(ItemStack stack) {
        return super.m_142522_(stack) && BacktankUtil.getAir((ItemStack)stack) < (float)BacktankUtil.maxAir((ItemStack)stack);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ShadowRadianceChestplate.hasElytra(stack) && ShadowRadianceChestplate.isElytraEnable(stack) && (Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get() != false;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return true;
    }
}

