/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.armors;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.DivingHelmetItem;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLArmorMaterials;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RefinedRadianceHelmet
extends DivingHelmetItem
implements QOLConfigurableItem {
    public RefinedRadianceHelmet(Item.Properties properties) {
        super((ArmorMaterial)QOLArmorMaterials.REFINED_RADIANCE, properties, CreateQOL.asResource("refined_radiance"));
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        this.invTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.goggles").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.helmetHaveGoggles.get(), true, NBTConstants.getOrDefault(stack, "goggles", true), false, true)));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Enable Googles", NBTConstants.getOrDefault(stack, "goggles", true), "goggles", Arrays.asList("Should engineer's goggle's information be displayed"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.armors.helmetHaveGoggles.get()));
    }

    @Override
    public MobEffect providedEffect(ItemStack stack) {
        return MobEffects.f_19611_;
    }

    @Override
    public int effectTime(ItemStack stack) {
        return 220;
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ARMOR;
    }

    @Override
    public List<ArmorRenderType> renderTypes(ItemStack stack) {
        return Arrays.stream(ArmorRenderType.values()).toList();
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    static {
        GogglesItem.addIsWearingPredicate(player -> QOLItems.REFINED_RADIANCE_HELMET.isIn(player.m_6844_(EquipmentSlot.HEAD)) && NBTConstants.getOrDefault(player.m_6844_(EquipmentSlot.HEAD), "goggles", true) && (Boolean)CreateQOLConfigs.server().equipments.armors.helmetHaveGoggles.get() != false);
    }
}

