/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.armors;

import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.BooleanEntry;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLArmorMaterials;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.CommonKeysHandler;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.KeyBindManager;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.PreferredRender;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import fr.iglee42.createqualityoflife.utils.ShadowRadianceEffects;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShadowRadianceChestplate
extends BacktankItem.Layered
implements QOLConfigurableItem {
    private static final double FANS_ACCELERATION = 0.15;
    private static final double FANS_SPEED = 0.25;
    private static final double FANS_HOVER_SPEED = 0.2;

    public ShadowRadianceChestplate(Item.Properties properties, Supplier<BacktankItem.BacktankBlockItem> placeable) {
        super((ArmorMaterial)QOLArmorMaterials.SHADOW_RADIANCE, properties, CreateQOL.asResource("shadow_radiance"), placeable);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ShadowRadianceChestplate.hasElytra(stack) && ShadowRadianceChestplate.isElytraEnable(stack) && (!ShadowRadianceChestplate.hasPropeller(stack) || !ShadowRadianceChestplate.isFansEnable(stack)) && (Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get() != false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return true;
    }

    private static boolean hasPlayerStackInInventory(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack currentStack = player.m_150109_().m_8020_(i);
            if (currentStack.m_41619_() || !currentStack.m_150930_(item)) continue;
            return true;
        }
        return false;
    }

    private static int getFirstInventoryIndex(Player player, Item item) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack currentStack = player.m_150109_().m_8020_(i);
            if (currentStack.m_41619_() || !currentStack.m_150930_(item)) continue;
            return i;
        }
        return -1;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public void tick(ItemStack stack, Level level, Player player, int slot, boolean offHand) {
        boolean second;
        boolean bl = second = level.m_46467_() % 20L == 0L;
        if (player.m_21255_() && ShadowRadianceChestplate.isElytraEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ((Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get()).booleanValue() && ((Boolean)CreateQOLConfigs.server().equipments.armors.elytraBoostAllowed.get()).booleanValue() && CommonKeysHandler.isHoldingUp(player)) {
            if (((Boolean)CreateQOLConfigs.server().equipments.armors.useFireworksForBoost.get()).booleanValue()) {
                if (ShadowRadianceChestplate.hasPlayerStackInInventory(player, Items.f_42688_)) {
                    int rocketSlot = ShadowRadianceChestplate.getFirstInventoryIndex(player, Items.f_42688_);
                    ItemStack firework = player.m_150109_().m_8020_(rocketSlot);
                    if ((NBTConstants.getOrDefault(stack, "boost_on_launch", false) || player.m_21256_() > 20) && player.m_21256_() % (Integer)CreateQOLConfigs.server().equipments.armors.fireworkDuration.get() == 0 || NBTConstants.getOrDefault(stack, "boost_on_launch", false) && player.m_21256_() == 0) {
                        FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(level, firework, (LivingEntity)player);
                        level.m_7967_((Entity)fireworkrocketentity);
                        player.m_150109_().m_7407_(rocketSlot, 1);
                    }
                }
            } else if (level.m_46467_() % 10L == 0L) {
                Vec3 vec31 = player.m_20154_();
                double d0 = 1.5;
                double d1 = 0.1;
                Vec3 vec32 = player.m_20184_();
                player.m_20256_(vec32.m_82520_(vec31.f_82479_ * d1 + (vec31.f_82479_ * d0 - vec32.f_82479_) * 0.5, vec31.f_82480_ * d1 + (vec31.f_82480_ * d0 - vec32.f_82480_) * 0.5, vec31.f_82481_ * d1 + (vec31.f_82481_ * d0 - vec32.f_82481_) * 0.5));
                if (!player.m_7500_()) {
                    BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (float)1.0f);
                }
            }
        }
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        if (ShadowRadianceChestplate.isFansEnable(stack) && !BacktankUtil.getAllWithAir((LivingEntity)player).isEmpty() && ShadowRadianceChestplate.hasPropeller(stack) && ((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get()).booleanValue()) {
            boolean hover = ShadowRadianceChestplate.isHoverEnable(stack) && (Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get() != false;
            boolean jumpKeyActive = CommonKeysHandler.isHoldingUp(player);
            boolean shiftKeyActive = CommonKeysHandler.isHoldingDown(player);
            player.m_183634_();
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).f_8906_.f_9737_ = 0;
            }
            if (!player.m_6069_()) {
                if (jumpKeyActive) {
                    if (!hover) {
                        if (shiftKeyActive) {
                            this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, -0.0));
                        } else {
                            this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, 0.25));
                        }
                    } else if (((Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get()).booleanValue()) {
                        this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, 0.2));
                    }
                    if (second) {
                        BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (float)1.0f);
                    }
                } else if (hover) {
                    if (((Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get()).booleanValue()) {
                        if (shiftKeyActive) {
                            this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, -0.4));
                        } else {
                            this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, -0.0));
                            if (second) {
                                BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (float)1.0f);
                            }
                        }
                    }
                } else if (shiftKeyActive) {
                    this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, -0.4));
                } else {
                    this.pushVertically(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + 0.15, -0.30000000000000004));
                }
                if (CommonKeysHandler.isHoldingForwards(player)) {
                    player.m_19920_(1.0f, new Vec3(0.0, 0.0, player.m_20142_() ? 0.05625 : 0.05));
                }
                if (CommonKeysHandler.isHoldingBackwards(player)) {
                    player.m_19920_(1.0f, new Vec3(0.0, 0.0, -0.037500000000000006));
                }
                if (CommonKeysHandler.isHoldingLeft(player)) {
                    player.m_19920_(1.0f, new Vec3(0.05, 0.0, 0.0));
                }
                if (CommonKeysHandler.isHoldingRight(player)) {
                    player.m_19920_(1.0f, new Vec3(-0.05, 0.0, 0.0));
                }
            } else if (jumpKeyActive) {
                player.m_19920_(1.0f, new Vec3(0.0, 0.0, 0.05625));
                if (second) {
                    BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)stack, (float)1.0f);
                }
            }
        }
    }

    private void pushVertically(Player p, double y) {
        Vec3 motion = p.m_20184_();
        p.m_20334_(motion.m_82507_(Direction.Axis.X), y, motion.m_82507_(Direction.Axis.Z));
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.air").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)String.valueOf(BacktankUtil.getAir((ItemStack)stack))).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)("/" + BacktankUtil.maxAir((ItemStack)stack))).m_130940_(ChatFormatting.GOLD)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.effect").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)this.providedEffect(stack).m_19481_()).m_130940_(ChatFormatting.YELLOW)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.arms").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState(true, true, NBTConstants.getOrDefault(stack, "arms", true), false, true)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.elytra").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get(), ShadowRadianceChestplate.hasElytra(stack), ShadowRadianceChestplate.isElytraEnable(stack), true, false)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.dash").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.cooldownState((Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get(), NBTConstants.getOrDefault(stack, "dash", true), (int)Math.ceil(Minecraft.m_91087_().f_91074_.m_36335_().m_41521_((Item)this, 0.0f) * (float)((Integer)CreateQOLConfigs.server().equipments.armors.dashCooldown.get()).intValue()))));
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.propeller").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get(), ShadowRadianceChestplate.hasPropeller(stack), true, false, false)));
        if (ShadowRadianceChestplate.hasPropeller(stack) && ((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get()).booleanValue()) {
            components.add((Component)Component.m_237119_());
            components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.fan").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState(true, true, ShadowRadianceChestplate.isFansEnable(stack), false, true)));
            components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.hover").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get(), true, ShadowRadianceChestplate.isHoverEnable(stack), false, true)));
        }
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    public static void toggleFans(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get()).booleanValue()) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.armor.disabled", CreateQOLLang.translateDirect("ability.armor.propeller_mode", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (ShadowRadianceChestplate.isElytraEnable(chestplate)) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.armor.unavailable", CreateQOLLang.translateDirect("ability.armor.fan_mode", new Object[0]).getString(), CreateQOLLang.translateDirect("ability.armor.elytra_mode", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        chestplate.m_41784_().m_128379_("fans", chestplate.m_41784_().m_128441_("fans") && !chestplate.m_41784_().m_128471_("fans"));
        boolean fans = ShadowRadianceChestplate.isFansEnable(chestplate);
        p.m_5661_((Component)CreateQOLLang.translateDirect("ability.armor.toggle_message", CreateQOLLang.translateDirect("ability.armor.fan_mode", new Object[0]).getString()).m_7220_(QOLConfigurableItem.chooseState(true, true, fans, false, true)).m_130940_(fans ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public static void toggleHover(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get()).booleanValue()) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.armor.disabled", CreateQOLLang.translateDirect("ability.armor.propeller_mode", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get()).booleanValue()) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.armor.disabled", CreateQOLLang.translateDirect("ability.armor.hover_mode", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        chestplate.m_41784_().m_128379_("hover", chestplate.m_41784_().m_128441_("hover") && !chestplate.m_41784_().m_128471_("hover"));
        boolean hover = ShadowRadianceChestplate.isHoverEnable(chestplate);
        p.m_5661_((Component)CreateQOLLang.translateDirect("ability.armor.toggle_message", CreateQOLLang.translateDirect("ability.armor.hover_mode", new Object[0]).getString()).m_7220_(QOLConfigurableItem.chooseState(true, true, hover, false, true)).m_130940_(hover ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public static void toggleElytra(ItemStack chestplate, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get()).booleanValue()) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.armor.disabled", CreateQOLLang.translateDirect("ability.armor.elytra_mode", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (ShadowRadianceChestplate.isFansEnable(chestplate)) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.armor.unavailable", CreateQOLLang.translateDirect("ability.armor.elytra_mode", new Object[0]).getString(), CreateQOLLang.translateDirect("ability.armor.fan_mode", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        chestplate.m_41784_().m_128379_("elytraState", chestplate.m_41784_().m_128441_("elytraState") && !chestplate.m_41784_().m_128471_("elytraState"));
        boolean elytra = ShadowRadianceChestplate.isElytraEnable(chestplate);
        p.m_5661_((Component)CreateQOLLang.translateDirect("ability.armor.toggle_message", CreateQOLLang.translateDirect("ability.armor.elytra_mode", new Object[0]).getString()).m_7220_(QOLConfigurableItem.chooseState(true, true, elytra, false, true)).m_130940_(elytra ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public static void toggleFansElytra(ItemStack chestplate, Player p) {
        boolean hasElytra = ShadowRadianceChestplate.hasElytra(chestplate);
        boolean hasPropeller = ShadowRadianceChestplate.hasPropeller(chestplate);
        if (hasElytra && hasPropeller) {
            if (!ShadowRadianceChestplate.isFansEnable(chestplate) && !ShadowRadianceChestplate.isElytraEnable(chestplate)) {
                ShadowRadianceChestplate.toggleFans(chestplate, p);
            } else if (ShadowRadianceChestplate.isElytraEnable(chestplate)) {
                ShadowRadianceChestplate.toggleElytra(chestplate, p);
                ShadowRadianceChestplate.toggleFans(chestplate, p);
            } else if (ShadowRadianceChestplate.isFansEnable(chestplate)) {
                ShadowRadianceChestplate.toggleFans(chestplate, p);
                ShadowRadianceChestplate.toggleElytra(chestplate, p);
            }
        } else if (hasElytra) {
            ShadowRadianceChestplate.toggleElytra(chestplate, p);
        } else if (hasPropeller) {
            ShadowRadianceChestplate.toggleFans(chestplate, p);
        }
    }

    public static boolean hasPropeller(ItemStack chestplate) {
        return chestplate.m_41784_().m_128441_("propellers") && chestplate.m_41784_().m_128471_("propellers");
    }

    public static boolean hasElytra(ItemStack chestplate) {
        return chestplate.m_41784_().m_128441_("elytra") && chestplate.m_41784_().m_128471_("elytra");
    }

    public static boolean isElytraEnable(ItemStack chestplate) {
        return !chestplate.m_41784_().m_128441_("elytraState") ? !ShadowRadianceChestplate.isFansEnable(chestplate) : chestplate.m_41784_().m_128471_("elytraState");
    }

    public static boolean isFansEnable(ItemStack chestplate) {
        if (!ShadowRadianceChestplate.hasPropeller(chestplate)) {
            return false;
        }
        return !chestplate.m_41784_().m_128441_("fans") || chestplate.m_41784_().m_128471_("fans");
    }

    public static boolean isHoverEnable(ItemStack chestplate) {
        if (!ShadowRadianceChestplate.hasPropeller(chestplate)) {
            return false;
        }
        return chestplate.m_41784_().m_128441_("hover") && chestplate.m_41784_().m_128471_("hover");
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ARMOR;
    }

    @Override
    public List<ArmorRenderType> renderTypes(ItemStack stack) {
        return Arrays.stream(ArmorRenderType.values()).toList();
    }

    @Override
    public MobEffect providedEffect(ItemStack stack) {
        return NBTConstants.getEffectsOrDefault(stack, ShadowRadianceEffects.REGENERATION).getEffectHolder();
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Enable Custom Arms", NBTConstants.getOrDefault(stack, "arms", true), "arms", Arrays.asList("Should the player's arms be replaced with the armor in first person"), (e, oe) -> true));
        list.add(QOLConfigurableItem.Configuration.ofBool("Enable Dash", NBTConstants.getOrDefault(stack, "dash", true), "dash", List.of("Should the player dash when pressing " + KeyBindManager.DASH_KEY.m_90863_().getString()), (o, oe) -> (Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get()));
        if (ShadowRadianceChestplate.hasPropeller(stack)) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Fan", NBTConstants.getOrDefault(stack, "fans", true), "fans", Arrays.asList("Activate the propeller on the backtank", "_Can't be enabled if the elytra are enabled_"), (entry, oe) -> {
                boolean flag = oe.stream().noneMatch(e -> {
                    BooleanEntry oEntry;
                    return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getNbtKey().equals("elytraState") && (Boolean)oEntry.getValue() != false;
                });
                return (Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get() != false && flag;
            }));
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Hover", NBTConstants.getOrDefault(stack, "hover", false), "hover", Arrays.asList("Activate the hover mode"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.armors.propellerAllowed.get() != false && (Boolean)CreateQOLConfigs.server().equipments.armors.hoverAllowed.get() != false));
        }
        if (ShadowRadianceChestplate.hasElytra(stack)) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Elytra", NBTConstants.getOrDefault(stack, "elytraState", false), "elytraState", Arrays.asList("Activate the elytra on the backtank", "_Can't be enabled if the fan is enabled_"), (entry, oe) -> {
                boolean flag = oe.stream().noneMatch(e -> {
                    BooleanEntry oEntry;
                    return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getNbtKey().equals("fans") && (Boolean)oEntry.getValue() != false;
                });
                return (Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get() != false && flag;
            }));
            if (((Boolean)CreateQOLConfigs.server().equipments.armors.elytraBoostAllowed.get()).booleanValue()) {
                list.add(QOLConfigurableItem.Configuration.ofBool("Boost on Launch", NBTConstants.getOrDefault(stack, "boost_on_launch", false), "boost_on_launch", Arrays.asList("Define if you should be boost when you start flying with elytra", "Works only with fireworks", "(The air boost doesn't have the same behaviour)"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.armors.elytraAllowed.get() != false && (Boolean)CreateQOLConfigs.server().equipments.armors.elytraBoostAllowed.get() != false && (Boolean)CreateQOLConfigs.server().equipments.armors.useFireworksForBoost.get() != false));
            }
        }
        list.add(new QOLConfigurableItem.Configuration<PreferredRender>("Preferred Render", NBTConstants.getOrDefault("preferredRender", stack), "preferredRender", QOLConfigurableItem.Configuration.ConfigType.ENUM, Arrays.asList("Define how the additions should be rendered.", "\"Elytra\" renders only the elytra", "\"Backtank\" renders only the backtank"), (direction, entry) -> {
            PreferredRender e = (PreferredRender)((Object)((Object)entry.getValue()));
            PreferredRender[] options = (PreferredRender[])Arrays.stream(PreferredRender.values()).toArray(PreferredRender[]::new);
            e = options[Math.floorMod(e.ordinal() + direction, options.length)];
            return e;
        }, (e, oe) -> true));
        ShadowRadianceEffects[] valids = (ShadowRadianceEffects[])Arrays.stream(ShadowRadianceEffects.values()).filter(ef -> ef.isValidForItem(stack)).toArray(ShadowRadianceEffects[]::new);
        list.add(new QOLConfigurableItem.Configuration<ShadowRadianceEffects>("Effect", NBTConstants.getEffectsOrDefault(stack, ShadowRadianceEffects.REGENERATION), "choosable_effects", QOLConfigurableItem.Configuration.ConfigType.ENUM, Arrays.asList("Define which mob effect should be provided.", "For this item, there is " + Component.m_237115_((String)valids[0].getEffectHolder().m_19481_()).getString() + " and " + Component.m_237115_((String)valids[1].getEffectHolder().m_19481_()).getString()), (direction, entry) -> {
            ShadowRadianceEffects e = (ShadowRadianceEffects)((Object)((Object)entry.getValue()));
            ShadowRadianceEffects[] options = (ShadowRadianceEffects[])Arrays.stream(ShadowRadianceEffects.values()).filter(ef -> ef.isValidForItem(stack)).toArray(ShadowRadianceEffects[]::new);
            e = options[Math.floorMod(e.ordinal() + direction, options.length)];
            return e;
        }, (e, oe) -> true));
    }

    public boolean m_142522_(ItemStack stack) {
        return super.m_142522_(stack) && BacktankUtil.getAir((ItemStack)stack) < (float)BacktankUtil.maxAir((ItemStack)stack);
    }
}

