/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.armors;

import com.simibubi.create.content.equipment.armor.BacktankItem;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLArmorMaterials;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.KeyBindManager;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShadowSteelChestplate
extends BacktankItem.Layered
implements QOLConfigurableItem {
    public ShadowSteelChestplate(Item.Properties properties, Supplier<BacktankItem.BacktankBlockItem> placeable) {
        super((ArmorMaterial)QOLArmorMaterials.SHADOW_STEEL, properties, CreateQOL.asResource("shadow_steel"), placeable);
    }

    public static void dash(ItemStack chestplate, ServerPlayer player) {
        if (!NBTConstants.getOrDefault(chestplate, "dash", true)) {
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get()).booleanValue()) {
            player.m_5661_((Component)CreateQOLLang.translateDirect("armor.ability.dash_disabled", new Object[0]).m_130940_(ChatFormatting.RED), true);
            return;
        }
        if (player.m_36335_().m_41519_(chestplate.m_41720_())) {
            player.m_5661_((Component)CreateQOLLang.translateDirect("armor.ability.dash_reloading", new Object[0]).m_130940_(ChatFormatting.RED), true);
            return;
        }
        Vec3 look = player.m_20154_().m_82541_().m_82490_(2.5);
        look = new Vec3(look.f_82479_, Mth.m_14008_((double)look.f_82480_, (double)-0.5, (double)0.5), look.f_82481_);
        player.m_20256_(player.m_20184_().m_82549_(look));
        player.f_19864_ = true;
        player.m_36335_().m_41524_(chestplate.m_41720_(), ((Integer)CreateQOLConfigs.server().equipments.armors.dashCooldown.get()).intValue());
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        this.invTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.air").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)String.valueOf(BacktankUtil.getAir((ItemStack)stack))).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)("/" + BacktankUtil.maxAir((ItemStack)stack))).m_130940_(ChatFormatting.GOLD)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.dash").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.cooldownState((Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get(), NBTConstants.getOrDefault(stack, "dash", true), (int)Math.ceil(Minecraft.m_91087_().f_91074_.m_36335_().m_41521_((Item)this, 0.0f) * (float)((Integer)CreateQOLConfigs.server().equipments.armors.dashCooldown.get()).intValue()))));
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.arms").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState(true, true, NBTConstants.getOrDefault(stack, "arms", true), false, true)));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ARMOR;
    }

    @Override
    public List<ArmorRenderType> renderTypes(ItemStack stack) {
        return Arrays.asList(ArmorRenderType.ALL, ArmorRenderType.NONE);
    }

    @Override
    public MobEffect providedEffect(ItemStack stack) {
        return MobEffects.f_19600_;
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Enable Custom Arms", NBTConstants.getOrDefault(stack, "arms", true), "arms", List.of("Should the player's arms be replaced with the armor in first person"), (e, oe) -> true));
        list.add(QOLConfigurableItem.Configuration.ofBool("Enable Dash", NBTConstants.getOrDefault(stack, "dash", true), "dash", List.of("Should the player dash when pressing " + KeyBindManager.DASH_KEY.m_90863_().getString()), (o, oe) -> (Boolean)CreateQOLConfigs.server().equipments.armors.dashAllowed.get()));
    }

    public boolean m_142522_(ItemStack stack) {
        return super.m_142522_(stack) && BacktankUtil.getAir((ItemStack)stack) < (float)BacktankUtil.maxAir((ItemStack)stack);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }
}

