/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.refinedradiance;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class RefinedRadianceAxe
extends AxeItem
implements QOLConfigurableItem {
    public RefinedRadianceAxe(Item.Properties p_42964_) {
        super((Tier)QOLTiers.REFINED_RADIANCE, 5.0f, -3.0f, p_42964_);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.reach").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, NBTConstants.getOrDefault(stack, "reach", true), false, true)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.casingifier").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.casingifier.get(), true, NBTConstants.getOrDefault(stack, "casingifier", false), false, true)));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Casingifier", NBTConstants.getOrDefault(stack, "casingifier", false), "casingifier", List.of("When stripping a log transform it into casing if a valid casing ingredient is available in the off hand", "It also transform adjacent blocks"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.casingifier.get()));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)true);
        }
        if (player.m_6047_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        RefinedRadianceAxe.toggleAbility(player.m_21120_(hand), player);
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.casingifier.get()).booleanValue()) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.casingifier", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        boolean enable = !NBTConstants.getOrDefault(stack, "casingifier", false);
        stack.m_41784_().m_128379_("casingifier", enable);
        p.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.casingifier", new Object[0]).getString()).m_7220_(QOLConfigurableItem.chooseState(true, true, enable, false, true)).m_130940_(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.casingifier.get()).booleanValue() || !NBTConstants.getOrDefault(ctx.m_43722_(), "casingifier", false)) {
            return super.m_6225_(ctx);
        }
        Level level = ctx.m_43725_();
        BlockPos origin = ctx.m_8083_();
        Player player = ctx.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack tool = ctx.m_43722_();
        ItemStack offHandStack = player.m_21206_();
        int limit = (Integer)CreateQOLConfigs.server().equipments.tools.casingifierMaxBlocks.get();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toVisit = new ArrayDeque<BlockPos>();
        toVisit.add(origin);
        int count = 0;
        while (!toVisit.isEmpty() && count < limit) {
            boolean success;
            BlockPos pos = (BlockPos)toVisit.poll();
            if (!visited.add(pos) || !(success = this.transformBlock(level, pos, player, ctx, offHandStack, (bs, recipe) -> {
                boolean keepHeld;
                level.m_7731_(pos, bs, 3);
                recipe.rollResults().forEach(stack -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
                boolean creative = player.m_7500_();
                boolean unbreakable = offHandStack.m_41784_().m_128471_("Unbreakable");
                boolean bl = keepHeld = recipe.shouldKeepHeldItem() || creative;
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(sp, pos, tool);
                }
                tool.m_41622_(1, (LivingEntity)player, e -> {});
                if (!unbreakable && !keepHeld) {
                    this.consumeItem(player, offHandStack);
                }
                RefinedRadianceAxe.awardAdvancements(player, bs);
            }))) continue;
            ++count;
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = pos.m_121945_(dir);
                if (visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return count > 0 ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
    }

    private void consumeItem(Player player, ItemStack reference) {
        if (reference.m_41619_()) {
            return;
        }
        if (reference.m_41763_()) {
            reference.m_41622_(1, (LivingEntity)player, e -> {});
        } else {
            player.m_21206_().m_41774_(1);
        }
    }

    private boolean transformBlock(Level level, BlockPos blockpos, Player player, UseOnContext ctx, ItemStack offHandStack, BiConsumer<BlockState, ManualApplicationRecipe> onSuccess) {
        Optional<BlockState> optional = Optional.ofNullable(level.m_8055_(blockpos).getToolModifiedState(ctx, ToolActions.AXE_STRIP, false));
        if (optional.isEmpty()) {
            return false;
        }
        Optional<ItemApplicationRecipe> foundRecipe = level.m_7465_().m_44013_(AllRecipeTypes.ITEM_APPLICATION.getType()).stream().map(ItemApplicationRecipe.class::cast).filter(r -> {
            ManualApplicationRecipe mar = (ManualApplicationRecipe)r;
            return mar.testBlock((BlockState)optional.get()) && ((Ingredient)mar.m_7527_().get(1)).test(offHandStack);
        }).findFirst();
        if (foundRecipe.isEmpty()) {
            return false;
        }
        ManualApplicationRecipe recipe = (ManualApplicationRecipe)foundRecipe.get();
        level.m_46961_(blockpos, false);
        BlockState transformedBlock = recipe.transformBlock(optional.get());
        onSuccess.accept(transformedBlock, recipe);
        return true;
    }

    private static void awardAdvancements(Player player, BlockState placed) {
        CreateAdvancement advancement = null;
        if (AllBlocks.ANDESITE_CASING.has(placed)) {
            advancement = AllAdvancements.ANDESITE_CASING;
        } else if (AllBlocks.BRASS_CASING.has(placed)) {
            advancement = AllAdvancements.BRASS_CASING;
        } else if (AllBlocks.COPPER_CASING.has(placed)) {
            advancement = AllAdvancements.COPPER_CASING;
        } else if (AllBlocks.RAILWAY_CASING.has(placed)) {
            advancement = AllAdvancements.TRAIN_CASING;
        } else {
            return;
        }
        advancement.awardTo(player);
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BOTH;
    }
}

