/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.refinedradiance;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.mixin.accessor.CropBlockAccessor;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.level.BlockEvent;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class RefinedRadianceHoe
extends HoeItem
implements QOLConfigurableItem {
    public RefinedRadianceHoe(Item.Properties p_42964_) {
        super((Tier)QOLTiers.REFINED_RADIANCE, -3, 0.0f, p_42964_);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.reach").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, NBTConstants.getOrDefault(stack, "reach", true), false, true)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.harvesting").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.harvesting.get(), true, NBTConstants.getOrDefault(stack, "harvesting", false), false, true)));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Harvesting", NBTConstants.getOrDefault(stack, "harvesting", false), "harvesting", List.of("Should replant destroyed crops"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.harvesting.get()));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)true);
        }
        if (player.m_6047_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        RefinedRadianceHoe.toggleAbility(player.m_21120_(hand), player);
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.harvesting.get()).booleanValue()) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.harvesting", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        boolean enable = !NBTConstants.getOrDefault(stack, "harvesting", false);
        stack.m_41784_().m_128379_("harvesting", enable);
        p.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.harvesting", new Object[0]).getString()).m_7220_(QOLConfigurableItem.chooseState(true, true, enable, false, true)).m_130940_(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public static void mineBlock(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.getPlayer().m_21205_().m_150930_((Item)QOLItems.REFINED_RADIANCE_HOE.get()) && !event.getPlayer().m_21205_().m_150930_((Item)QOLItems.SHADOW_RADIANCE_HOE.get())) {
            return;
        }
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.harvesting.get()).booleanValue()) {
            return;
        }
        if (!NBTConstants.getOrDefault(event.getPlayer().m_21205_(), "harvesting", false)) {
            return;
        }
        if (RefinedRadianceHoe.tryHarvestCrop(event.getPlayer().m_9236_(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    public static boolean tryHarvestCrop(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return false;
        }
        BlockState stateVisited = world.m_8055_(pos);
        if (stateVisited.m_60795_() || AllTags.AllBlockTags.NON_HARVESTABLE.matches(stateVisited)) {
            return false;
        }
        boolean notCropButCuttable = false;
        if (!RefinedRadianceHoe.isValidCrop(world, pos, stateVisited)) {
            if (RefinedRadianceHoe.isValidOther(world, pos, stateVisited)) {
                notCropButCuttable = true;
            } else {
                return false;
            }
        }
        ItemStack item = ItemStack.f_41583_;
        float effectChance = 1.0f;
        if (stateVisited.m_204336_(BlockTags.f_13035_)) {
            item = new ItemStack((ItemLike)Items.f_42574_);
            effectChance = 0.45f;
        }
        MutableBoolean seedSubtracted = new MutableBoolean(notCropButCuttable);
        BlockState state = stateVisited;
        BlockHelper.destroyBlockAs((Level)world, (BlockPos)pos, null, (ItemStack)item, (float)effectChance, stack -> {
            if (((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue() && !seedSubtracted.getValue().booleanValue() && ItemHelper.sameItem((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)state.m_60734_()))) {
                stack.m_41774_(1);
                seedSubtracted.setTrue();
            }
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
        });
        BlockState cutCrop = RefinedRadianceHoe.cutCrop(world, pos, stateVisited);
        world.m_46597_(pos, cutCrop.m_60710_((LevelReader)world, pos) ? cutCrop : Blocks.f_50016_.m_49966_());
        return true;
    }

    public static boolean isValidCrop(Level world, BlockPos pos, BlockState state) {
        boolean harvestPartial = (Boolean)AllConfigs.server().kinetics.harvestPartiallyGrown.get();
        boolean replant = (Boolean)AllConfigs.server().kinetics.harvesterReplants.get();
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            if (harvestPartial) {
                return state != crop.m_52289_(0) || !replant;
            }
            return crop.m_52307_(state);
        }
        if (state.m_60812_((BlockGetter)world, pos).m_83281_() || state.m_60734_() instanceof CocoaBlock) {
            for (Property property : state.m_61147_()) {
                if (!(property instanceof IntegerProperty)) continue;
                IntegerProperty ageProperty = (IntegerProperty)property;
                if (!property.m_61708_().equals(BlockStateProperties.f_61405_.m_61708_())) continue;
                int age = (Integer)state.m_61143_((Property)ageProperty);
                if (state.m_60734_() instanceof SweetBerryBushBlock && age <= 1 && replant || age == 0 && replant || !harvestPartial && ageProperty.m_6908_().size() - 1 != age) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidOther(Level world, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof CropBlock) {
            return false;
        }
        if (state.m_60734_() instanceof SugarCaneBlock) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        if (state.m_60734_() instanceof CocoaBlock) {
            return (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) == 2;
        }
        if (state.m_60812_((BlockGetter)world, pos).m_83281_()) {
            if (state.m_60734_() instanceof GrowingPlantBlock) {
                return true;
            }
            for (Property property : state.m_61147_()) {
                if (!(property instanceof IntegerProperty) || !property.m_61708_().equals(BlockStateProperties.f_61405_.m_61708_())) continue;
                return false;
            }
            if (state.m_60734_() instanceof IPlantable) {
                return true;
            }
        }
        return false;
    }

    private static BlockState cutCrop(Level world, BlockPos pos, BlockState state) {
        if (!((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue()) {
            if (state.m_60819_().m_76178_()) {
                return Blocks.f_50016_.m_49966_();
            }
            return state.m_60819_().m_76188_();
        }
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            BlockState newState = crop.m_52289_(0);
            if (!newState.m_60713_(block)) {
                return newState;
            }
            IntegerProperty ageProperty = ((CropBlockAccessor)crop).create$callGetAgeProperty();
            return (BlockState)state.m_61124_((Property)ageProperty, (Comparable)Integer.valueOf(0));
        }
        if (block == Blocks.f_50685_) {
            return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(1));
        }
        if (AllTags.AllBlockTags.SUGAR_CANE_VARIANTS.matches(block) || block instanceof GrowingPlantBlock) {
            if (state.m_60819_().m_76178_()) {
                return Blocks.f_50016_.m_49966_();
            }
            return state.m_60819_().m_76188_();
        }
        if (state.m_60812_((BlockGetter)world, pos).m_83281_() || block instanceof CocoaBlock) {
            for (Property property : state.m_61147_()) {
                if (!(property instanceof IntegerProperty) || !property.m_61708_().equals(BlockStateProperties.f_61405_.m_61708_())) continue;
                return (BlockState)state.m_61124_((Property)((IntegerProperty)property), (Comparable)Integer.valueOf(0));
            }
        }
        if (state.m_60819_().m_76178_()) {
            return Blocks.f_50016_.m_49966_();
        }
        return state.m_60819_().m_76188_();
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BLOCK;
    }
}

