/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.shadowradiance;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.widgets.entries.BooleanEntry;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.items.tools.refinedradiance.RefinedRadianceHoe;
import fr.iglee42.createqualityoflife.items.tools.shadowsteel.ShadowSteelHoe;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class ShadowRadianceHoe
extends HoeItem
implements QOLConfigurableItem {
    public ShadowRadianceHoe(Item.Properties p_42964_) {
        super((Tier)QOLTiers.SHADOW_RADIANCE, -3, 0.0f, p_42964_);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.reach").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, NBTConstants.getOrDefault(stack, "reach", true), false, true)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.harvesting").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.harvesting.get(), true, NBTConstants.getOrDefault(stack, "harvesting", false), false, true)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.ploughing").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.ploughing.get(), true, NBTConstants.getOrDefault(stack, "ploughing", false), false, true)));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Harvesting", NBTConstants.getOrDefault(stack, "harvesting", false), "harvesting", List.of("Should replant destroyed crops"), (entry, oe) -> {
            boolean flag = oe.stream().noneMatch(e -> {
                BooleanEntry oEntry;
                return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getNbtKey().equals("ploughing") && (Boolean)oEntry.getValue() != false;
            });
            return (Boolean)CreateQOLConfigs.server().equipments.tools.harvesting.get() != false && flag;
        }));
        list.add(QOLConfigurableItem.Configuration.ofBool("Ploughing", NBTConstants.getOrDefault(stack, "ploughing", false), "ploughing", List.of("Should plough dirt in a 3x3 square"), (entry, oe) -> {
            boolean flag = oe.stream().noneMatch(e -> {
                BooleanEntry oEntry;
                return e instanceof BooleanEntry && (oEntry = (BooleanEntry)((Object)((Object)e))).getNbtKey().equals("harvesting") && (Boolean)oEntry.getValue() != false;
            });
            return (Boolean)CreateQOLConfigs.server().equipments.tools.ploughing.get() != false && flag;
        }));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)true);
        }
        if (player.m_6047_()) {
            if (NBTConstants.getOrDefault(player.m_21120_(hand), "harvesting", false)) {
                player.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.unavailable", CreateQOLLang.translateDirect("ability.tool.ploughing", new Object[0]).getString(), CreateQOLLang.translateDirect("ability.tool.harvesting", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            } else {
                ShadowSteelHoe.toggleAbility(player.m_21120_(hand), player);
            }
        } else if (NBTConstants.getOrDefault(player.m_21120_(hand), "ploughing", false)) {
            player.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.unavailable", CreateQOLLang.translateDirect("ability.tool.harvesting", new Object[0]).getString(), CreateQOLLang.translateDirect("ability.tool.ploughing", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
        } else {
            RefinedRadianceHoe.toggleAbility(player.m_21120_(hand), player);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BLOCK;
    }

    @Override
    public double reachModifier(ItemStack stack) {
        return 1.0;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.ploughing.get()).booleanValue() || !NBTConstants.getOrDefault(ctx.m_43722_(), "ploughing", false)) {
            return super.m_6225_(ctx);
        }
        Level level = ctx.m_43725_();
        BlockPos basePos = ctx.m_8083_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Pair pair;
                BlockPos blockpos = basePos.m_7918_(x, 0, z);
                BlockState toolModifiedState = level.m_8055_(blockpos).getToolModifiedState(ctx, ToolActions.HOE_TILL, false);
                Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(c -> true, c -> {
                    c.m_43725_().m_7731_(blockpos, toolModifiedState, 11);
                    c.m_43725_().m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)c.m_43723_(), (BlockState)toolModifiedState));
                });
                if (pair == null) continue;
                Predicate predicate = (Predicate)pair.getFirst();
                Consumer consumer = (Consumer)pair.getSecond();
                if (!predicate.test(ctx)) continue;
                Player player = ctx.m_43723_();
                level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (level.f_46443_) continue;
                consumer.accept(ctx);
                if (player == null) continue;
                ctx.m_43722_().m_41622_(1, (LivingEntity)player, e -> {});
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

