/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.shadowsteel;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.BlockHelper;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public class ShadowSteelAxe
extends AxeItem
implements QOLConfigurableItem {
    public ShadowSteelAxe(Item.Properties p_42964_) {
        super((Tier)QOLTiers.SHADOW_STEEL, 5.0f, -3.0f, p_42964_);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.reach").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, NBTConstants.getOrDefault(stack, "reach", true), false, true)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.tree_decapitation").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.treeDecapitation.get(), true, NBTConstants.getOrDefault(stack, "tree_decapitation", false), false, true)));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Tree Decapitation", NBTConstants.getOrDefault(stack, "tree_decapitation", false), "tree_decapitation", List.of("Should destroy a tree when a log is broken like a mechanical saw"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.treeDecapitation.get()));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)true);
        }
        if (player.m_6047_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        ShadowSteelAxe.toggleAbility(player.m_21120_(hand), player);
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.treeDecapitation.get()).booleanValue()) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.tree_decapitation", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        boolean enable = !NBTConstants.getOrDefault(stack, "tree_decapitation", false);
        stack.m_41784_().m_128379_("tree_decapitation", enable);
        p.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.tree_decapitation", new Object[0]).getString()).m_7220_(QOLConfigurableItem.chooseState(true, true, enable, false, true)).m_130940_(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public static void mineBlock(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.getPlayer().m_21205_().m_150930_((Item)QOLItems.SHADOW_STEEL_AXE.get()) && !event.getPlayer().m_21205_().m_150930_((Item)QOLItems.SHADOW_RADIANCE_AXE.get())) {
            return;
        }
        if (!NBTConstants.getOrDefault(event.getPlayer().m_21205_(), "tree_decapitation", false)) {
            return;
        }
        if (!event.getPlayer().m_21205_().m_41735_(event.getState())) {
            return;
        }
        if (!SawBlockEntity.isSawable((BlockState)event.getState())) {
            return;
        }
        BlockState stateToBreak = event.getState();
        BlockPos breakingPos = event.getPos();
        Level level = event.getPlayer().m_9236_();
        Optional dynamicTree = TreeCutter.findDynamicTree((Block)stateToBreak.m_60734_(), (BlockPos)breakingPos);
        if (dynamicTree.isPresent()) {
            ((AbstractBlockBreakQueue)dynamicTree.get()).destroyBlocks(level, null, (pos, stack) -> ShadowSteelAxe.dropItemFromCutTree(level, pos, stack));
            return;
        }
        Vec3 vec = VecHelper.offsetRandomly((Vec3)VecHelper.getCenterOf((Vec3i)breakingPos), (RandomSource)level.f_46441_, (float)0.125f);
        BlockHelper.destroyBlock((Level)level, (BlockPos)breakingPos, (float)1.0f, stack -> {
            if (stack.m_41619_()) {
                return;
            }
            if (!level.m_46469_().m_46207_(GameRules.f_46136_)) {
                return;
            }
            if (level.restoringBlockSnapshots) {
                return;
            }
            ItemEntity itementity = new ItemEntity(level, vec.f_82479_, vec.f_82480_, vec.f_82481_, stack);
            itementity.m_32060_();
            itementity.m_20256_(Vec3.f_82478_);
            level.m_7967_((Entity)itementity);
        });
        TreeCutter.findTree((BlockGetter)level, (BlockPos)breakingPos, (BlockState)stateToBreak).destroyBlocks(level, null, (pos, stack) -> ShadowSteelAxe.dropItemFromCutTree(level, pos, stack));
    }

    private static void dropItemFromCutTree(Level level, BlockPos pos, ItemStack stack) {
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(level, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, stack);
        entity.m_20256_(Vec3.f_82478_);
        level.m_7967_((Entity)entity);
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BOTH;
    }
}

