/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.utils.LogisticsNetworkExtension;
import fr.iglee42.createqualityoflife.utils.NetworkDestructionLevel;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkHooks;

public class ModifyStockManagerLogisticNetworkPacket
extends BlockEntityConfigurationPacket<StockManagerBlockEntity> {
    private UUID networkId;

    public ModifyStockManagerLogisticNetworkPacket(BlockPos pos, UUID networkId) {
        super(pos);
        this.networkId = networkId;
    }

    public ModifyStockManagerLogisticNetworkPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    protected void readSettings(FriendlyByteBuf buffer) {
        this.networkId = buffer.m_130259_();
    }

    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.networkId);
    }

    protected void applySettings(ServerPlayer player, StockManagerBlockEntity stbe) {
        LogisticsNetwork network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(this.networkId);
        if (network != null) {
            stbe.behaviour.unload();
            stbe.behaviour.destroy();
            stbe.behaviour.freqId = this.networkId;
            stbe.behaviour.initialize();
            Create.LOGISTICS.linkAdded(this.networkId, GlobalPos.m_122643_((ResourceKey)stbe.m_58904_().m_46472_(), (BlockPos)stbe.m_58899_()), null);
            Create.LOGISTICS.linkLoaded(this.networkId, GlobalPos.m_122643_((ResourceKey)stbe.m_58904_().m_46472_(), (BlockPos)stbe.m_58899_()));
            stbe.m_6596_();
            network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(this.networkId);
            boolean showLockOption = stbe.behaviour.mayAdministrate((Player)player) && Create.LOGISTICS.isLockable(stbe.behaviour.freqId);
            boolean isCurrentlyLocked = Create.LOGISTICS.isLocked(stbe.behaviour.freqId);
            String name = ((LogisticsNetworkExtension)network).createQOL$getName();
            int links = network.totalLinks.size();
            HashMap<UUID, NetworkPermission> permissions = new HashMap<UUID, NetworkPermission>(((LogisticsNetworkExtension)network).createQOL$getPlayersPermission());
            if (network.owner != null) {
                permissions.put(network.owner, NetworkPermission.OWNER);
            }
            player.m_9236_().m_6907_().stream().filter(p -> !permissions.containsKey(p.m_20148_())).forEach(p -> permissions.put(p.m_20148_(), NetworkPermission.NONE));
            NetworkDestructionLevel desLevel = ((LogisticsNetworkExtension)network).createQOL$getDestructionLevel();
            boolean isOwner = player.m_20148_().equals(network.owner);
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)stbe.new StockManagerBlockEntity.StockManagerProvider(), buf -> {
                buf.writeBoolean(showLockOption);
                buf.writeBoolean(isOwner);
                buf.writeBoolean(isCurrentlyLocked);
                buf.m_130070_(name);
                buf.writeInt(links);
                buf.writeByte(desLevel.ordinal());
                buf.writeBoolean(desLevel.canDestroy(stbe.behaviour.freqId, (Player)player));
                buf.m_236831_(permissions, FriendlyByteBuf::m_130077_, (b, p) -> b.writeByte(p.ordinal()));
                buf.m_130064_(this.pos);
            });
        }
    }

    protected void applySettings(StockManagerBlockEntity stockManagerBlockEntity) {
    }
}

