/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.registries;

import com.simibubi.create.AllFluids;
import com.simibubi.create.api.event.PipeCollisionEvent;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.registries.QOLTags;
import java.util.function.Function;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Mod.EventBusSubscriber
public class QOLFluids {
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SUPERHEATED_LAVA = ((FluidBuilder)((ItemBuilder)((FluidBuilder)CreateQOL.REGISTRATE.standardFluid("superheated_lava", SolidRenderedPlaceableFluidType.create(4947434, () -> Float.valueOf(0.0625f), entity -> entity.m_9236_().m_6042_().f_63857_() ? 0.007 : 0.0023333333333333335)).lang("Super Lava").properties(b -> b.viscosity(6200).temperature(1500).density(3000).pathType(BlockPathTypes.LAVA).adjacentPathType(null).supportsBoating(false).canDrown(false).canSwim(false)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{QOLTags.QOLFluidsTags.SUPERHEATED_LAVA.tag}).source(ForgeFlowingFluid.Source::new).block().properties(p -> p.m_284180_(MapColor.f_283743_)).build()).bucket().onRegister(QOLFluids::registerFluidDispenseBehavior)).defaultModel().tag(new TagKey[]{QOLTags.QOLItemTags.SUPERHEATED_LAVA_BUCKETS.tag}).build()).register();
    private static final DispenseItemBehavior DEFAULT = new DefaultDispenseItemBehavior();
    private static final DispenseItemBehavior DISPENSE_FLUID = new DefaultDispenseItemBehavior(){

        protected ItemStack m_7498_(BlockSource pSource, ItemStack pStack) {
            DispensibleContainerItem dispensibleContainerItem = (DispensibleContainerItem)pStack.m_41720_();
            BlockPos pos = pSource.m_7961_().m_121945_((Direction)pSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = pSource.m_7727_();
            if (dispensibleContainerItem.emptyContents(null, (Level)level, pos, null, pStack)) {
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return DEFAULT.m_6115_(pSource, pStack);
        }
    };

    private static void registerFluidDispenseBehavior(BucketItem bucket) {
        DispenserBlock.m_52672_((ItemLike)bucket, (DispenseItemBehavior)DISPENSE_FLUID);
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((ForgeFlowingFluid.Flowing)SUPERHEATED_LAVA.get()).getFluidType(), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), fluidState -> Blocks.f_50080_.m_49966_()));
    }

    public static void register() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePipeFlowCollisionFallback(PipeCollisionEvent.Flow event) {
        BlockState lavaInteraction;
        Fluid f1 = event.getFirstFluid();
        Fluid f2 = event.getSecondFluid();
        if (f1 == Fluids.f_76193_ && FluidHelper.hasBlockState((Fluid)f2)) {
            BlockState lavaInteraction2 = QOLFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)f2).m_76145_());
            if (lavaInteraction2 != null) {
                event.setState(lavaInteraction2);
            }
        } else if (f2 == Fluids.f_76193_ && FluidHelper.hasBlockState((Fluid)f1) && (lavaInteraction = QOLFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)f1).m_76145_())) != null) {
            event.setState(lavaInteraction);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePipeSpillCollisionFallback(PipeCollisionEvent.Spill event) {
        BlockState lavaInteraction;
        Fluid pf = event.getPipeFluid();
        Fluid wf = event.getWorldFluid();
        if (pf == Fluids.f_76193_) {
            BlockState lavaInteraction2 = QOLFluids.getLavaInteraction(wf.m_76145_());
            if (lavaInteraction2 != null) {
                event.setState(lavaInteraction2);
            }
        } else if (wf == Fluids.f_76192_ && FluidHelper.hasBlockState((Fluid)pf) && (lavaInteraction = QOLFluids.getLavaInteraction(FluidHelper.convertToFlowing((Fluid)pf).m_76145_())) != null) {
            event.setState(lavaInteraction);
        }
    }

    @Nullable
    public static BlockState getLavaInteraction(FluidState fluidState) {
        Fluid fluid = fluidState.m_76152_();
        if (fluid.m_6212_((Fluid)SUPERHEATED_LAVA.get())) {
            return Blocks.f_50080_.m_49966_();
        }
        return null;
    }

    private static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;
        private Function<Entity, Double> motionScale;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance, @Nullable Function<Entity, Double> motionScale) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f){};
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                fluidType.motionScale = motionScale;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }

        public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
            return super.move(state, entity, movementVector, gravity);
        }

        public double motionScale(Entity entity) {
            return this.motionScale != null ? this.motionScale.apply(entity).doubleValue() : super.motionScale(entity);
        }

        public void setItemMovement(ItemEntity entity) {
            Vec3 vec3 = entity.m_20184_();
            entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
        }
    }
}

