/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;

public class ItemTooltips {
    public static final ItemTooltips DEFAULT = ItemTooltips.createDefaultTooltips();
    final Object2BooleanOpenHashMap<Tooltip> tooltips;

    public static ItemTooltips of(CompoundTag tag) {
        Mutable mutable = new Mutable(DEFAULT);
        for (Tooltip t : Tooltip.values()) {
            if (!tag.m_128441_(t.m_7912_())) continue;
            mutable.set(t, tag.m_128471_(t.m_7912_()));
        }
        return mutable.toImmutable();
    }

    private static ItemTooltips createDefaultTooltips() {
        Object2BooleanOpenHashMap map = new Object2BooleanOpenHashMap();
        Arrays.stream(Tooltip.values()).forEach(t -> map.put((Object)t, true));
        return new ItemTooltips((Object2BooleanOpenHashMap<Tooltip>)map);
    }

    ItemTooltips(Object2BooleanOpenHashMap<Tooltip> p_341287_) {
        this.tooltips = p_341287_;
    }

    public boolean isEnable(Tooltip tooltip) {
        return this.tooltips.getBoolean((Object)tooltip);
    }

    public int size() {
        return this.tooltips.size();
    }

    public boolean isEmpty() {
        return this.tooltips.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_331697_) {
        if (this == p_331697_) {
            return true;
        }
        if (!(p_331697_ instanceof ItemTooltips)) return false;
        ItemTooltips itemenchantments = (ItemTooltips)p_331697_;
        if (!this.tooltips.equals(itemenchantments.tooltips)) return false;
        return true;
    }

    public int hashCode() {
        int i = this.tooltips.hashCode();
        return 31 * i;
    }

    public String toString() {
        return "ItemTooltips{tooltips=" + String.valueOf(this.tooltips) + "}";
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        this.tooltips.forEach((t, b) -> tag.m_128379_(t.m_7912_(), b.booleanValue()));
        return tag;
    }

    public static class Mutable {
        private final Object2BooleanOpenHashMap<Tooltip> tooltips = new Object2BooleanOpenHashMap();

        public Mutable(ItemTooltips tooltips) {
            this.tooltips.putAll(tooltips.tooltips);
        }

        public void set(Tooltip tooltip, boolean enable) {
            this.tooltips.put((Object)tooltip, enable);
        }

        public boolean isEnable(Tooltip tooltip) {
            return this.tooltips.getOrDefault((Object)tooltip, true);
        }

        public ItemTooltips toImmutable() {
            return new ItemTooltips(this.tooltips);
        }
    }

    public static enum Tooltip implements StringRepresentable
    {
        ENCHANTMENT("Enchantments"),
        OPTIONS("Abilities"),
        ATTRIBUTE_MODIFIERS("Attributes");

        private final String displayName;

        private Tooltip(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

