/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.behaviours;

import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.blockentitites.EnderPackagerBlockEntity;
import fr.iglee42.createqualityoflife.utils.EnderPackagerItemHandler;
import fr.iglee42.createqualityoflife.utils.EnderPackagersNetworkHandler;
import fr.iglee42.createqualityoflife.utils.IEnderLinkable;
import java.util.function.Function;
import java.util.function.Supplier;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class EnderPackagerBehaviour
extends BlockEntityBehaviour
implements IEnderLinkable,
ClipboardCloneable {
    public static final BehaviourType<EnderPackagerBehaviour> TYPE = new BehaviourType();
    public EnderPackagersNetworkHandler.Frequency frequencyFirst = EnderPackagersNetworkHandler.Frequency.EMPTY;
    public EnderPackagersNetworkHandler.Frequency frequencyLast = EnderPackagersNetworkHandler.Frequency.EMPTY;
    public ValueBoxTransform firstSlot;
    public ValueBoxTransform secondSlot;
    Vec3 textShift;
    public boolean newPosition;
    private Mode mode;
    private Supplier<EnderPackagerItemHandler> handlerSupplier;

    protected EnderPackagerBehaviour(SmartBlockEntity be, Pair<ValueBoxTransform, ValueBoxTransform> slots) {
        super(be);
        this.firstSlot = (ValueBoxTransform)slots.getLeft();
        this.secondSlot = (ValueBoxTransform)slots.getRight();
        this.textShift = Vec3.f_82478_;
        this.newPosition = true;
    }

    public static EnderPackagerBehaviour receiver(SmartBlockEntity be, Pair<ValueBoxTransform, ValueBoxTransform> slots, Supplier<EnderPackagerItemHandler> handlerSupplier) {
        EnderPackagerBehaviour behaviour = new EnderPackagerBehaviour(be, slots);
        behaviour.handlerSupplier = handlerSupplier;
        behaviour.mode = Mode.RECEIVE;
        return behaviour;
    }

    public static EnderPackagerBehaviour transmitter(SmartBlockEntity be, Pair<ValueBoxTransform, ValueBoxTransform> slots) {
        EnderPackagerBehaviour behaviour = new EnderPackagerBehaviour(be, slots);
        behaviour.mode = Mode.TRANSMIT;
        return behaviour;
    }

    public EnderPackagerBehaviour moveText(Vec3 shift) {
        this.textShift = shift;
        return this;
    }

    public void copyItemsFrom(EnderPackagerBehaviour behaviour) {
        if (behaviour == null) {
            return;
        }
        this.frequencyFirst = behaviour.frequencyFirst;
        this.frequencyLast = behaviour.frequencyLast;
    }

    public void sendPackage(ItemStack pItem) {
        this.getHandler().sendPackage((LevelAccessor)this.getWorld(), this, pItem);
    }

    public boolean canSendPackage(ItemStack pItem) {
        return this.getHandler().canSend((LevelAccessor)this.getWorld(), this, pItem);
    }

    @Override
    public boolean isListening() {
        return this.mode == Mode.RECEIVE;
    }

    @Override
    public void setReceivedPackage(ItemStack packageStack) {
        this.handlerSupplier.get().insertItem(packageStack, false, true);
    }

    public void initialize() {
        super.initialize();
        if (this.getWorld().f_46443_) {
            return;
        }
        this.getHandler().addToNetwork((LevelAccessor)this.getWorld(), this);
        this.newPosition = true;
    }

    @Override
    public Couple<EnderPackagersNetworkHandler.Frequency> getNetworkKey() {
        return Couple.create((Object)this.frequencyFirst, (Object)this.frequencyLast);
    }

    public void unload() {
        super.unload();
        if (this.getWorld().f_46443_) {
            return;
        }
        this.getHandler().removeFromNetwork((LevelAccessor)this.getWorld(), this);
    }

    public boolean isSafeNBT() {
        return true;
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.m_128365_("FrequencyFirst", (Tag)this.frequencyFirst.getStack().m_41739_(new CompoundTag()));
        nbt.m_128365_("FrequencyLast", (Tag)this.frequencyLast.getStack().m_41739_(new CompoundTag()));
        nbt.m_128356_("LastKnownPosition", this.blockEntity.m_58899_().m_121878_());
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        long positionKey;
        long positionInTag = this.blockEntity.m_58899_().m_121878_();
        this.newPosition = positionInTag != (positionKey = nbt.m_128454_("LastKnownPosition"));
        super.read(nbt, clientPacket);
        this.frequencyFirst = EnderPackagersNetworkHandler.Frequency.of(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("FrequencyFirst")));
        this.frequencyLast = EnderPackagersNetworkHandler.Frequency.of(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("FrequencyLast")));
    }

    public void setFrequency(boolean first, ItemStack stack) {
        boolean changed;
        stack = stack.m_41777_();
        stack.m_41764_(1);
        ItemStack toCompare = first ? this.frequencyFirst.getStack() : this.frequencyLast.getStack();
        boolean bl = changed = !ItemStack.m_150942_((ItemStack)stack, (ItemStack)toCompare);
        if (changed) {
            this.getHandler().removeFromNetwork((LevelAccessor)this.getWorld(), this);
        }
        if (changed) {
            this.getHandler().removeFromNetwork((LevelAccessor)this.getWorld(), this);
        }
        if (first) {
            this.frequencyFirst = EnderPackagersNetworkHandler.Frequency.of(stack);
        } else {
            this.frequencyLast = EnderPackagersNetworkHandler.Frequency.of(stack);
        }
        if (!changed) {
            return;
        }
        this.blockEntity.sendData();
        this.getHandler().addToNetwork((LevelAccessor)this.getWorld(), this);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    private EnderPackagersNetworkHandler getHandler() {
        return CreateQOL.ENDER_PACKAGER_NETWORK_HANDLER;
    }

    public boolean testHit(Boolean first, Vec3 hit) {
        BlockState state = this.blockEntity.m_58900_();
        Vec3 localHit = hit.m_82546_(Vec3.m_82528_((Vec3i)this.blockEntity.m_58899_()));
        return (first != false ? this.firstSlot : this.secondSlot).testHit((LevelAccessor)this.getWorld(), this.getPos(), state, localHit);
    }

    @Override
    public boolean isAlive() {
        Level level = this.getWorld();
        BlockPos pos = this.getPos();
        if (this.blockEntity.isChunkUnloaded()) {
            return false;
        }
        if (this.blockEntity.m_58901_()) {
            return false;
        }
        if (!level.m_46749_(pos)) {
            return false;
        }
        return level.m_7702_(pos) == this.blockEntity;
    }

    @Override
    public BlockPos getLocation() {
        return this.getPos();
    }

    @Override
    public boolean canAcceptPackage(ItemStack pItem) {
        EnderPackagerBlockEntity be;
        SmartBlockEntity smartBlockEntity = this.blockEntity;
        if (smartBlockEntity instanceof EnderPackagerBlockEntity && !(be = (EnderPackagerBlockEntity)smartBlockEntity).doesMatchAddress(pItem)) {
            return false;
        }
        EnderPackagerItemHandler handler = this.handlerSupplier.get();
        return handler.insertItem(pItem, true, true).m_41619_();
    }

    public String getClipboardKey() {
        return "Frequencies";
    }

    public boolean writeToClipboard(CompoundTag tag, Direction side) {
        tag.m_128365_("First", (Tag)this.frequencyFirst.getStack().m_41739_(new CompoundTag()));
        tag.m_128365_("Last", (Tag)this.frequencyLast.getStack().m_41739_(new CompoundTag()));
        return true;
    }

    public boolean readFromClipboard(CompoundTag tag, Player player, Direction side, boolean simulate) {
        if (tag.m_128441_("First") && tag.m_128441_("Last")) {
            if (simulate) {
                return true;
            }
            this.setFrequency(true, ItemStack.m_41712_((CompoundTag)tag.m_128469_("First")));
            this.setFrequency(false, ItemStack.m_41712_((CompoundTag)tag.m_128469_("Last")));
            return true;
        }
        return false;
    }

    static enum Mode {
        TRANSMIT,
        RECEIVE;

    }

    public static class SlotPositioning {
        Function<BlockState, Pair<Vec3, Vec3>> offsets;
        Function<BlockState, Vec3> rotation;
        float scale;

        public SlotPositioning(Function<BlockState, Pair<Vec3, Vec3>> offsetsForState, Function<BlockState, Vec3> rotationForState) {
            this.offsets = offsetsForState;
            this.rotation = rotationForState;
            this.scale = 1.0f;
        }

        public SlotPositioning scale(float scale) {
            this.scale = scale;
            return this;
        }
    }
}

